/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.render.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.ItemStackHandler;
import sweetmagic.init.block.base.BaseCookBlock;
import sweetmagic.init.block.sm.Plate;
import sweetmagic.init.render.block.RenderAbstractTile;
import sweetmagic.init.tile.sm.TileAbstractSM;
import sweetmagic.init.tile.sm.TileModenRack;
import sweetmagic.util.RenderUtil;

@OnlyIn(value=Dist.CLIENT)
public class RenderModenRack<T extends TileModenRack>
extends RenderAbstractTile<T> {
    public RenderModenRack(BlockEntityRendererProvider.Context con) {
        super(con);
    }

    @Override
    public void render(T tile, float parTick, RenderUtil.RenderInfo info) {
        int data = ((TileModenRack)tile).getData();
        switch (data) {
            case 0: {
                this.renderModenRack(tile, info);
                break;
            }
            case 1: {
                this.renderWallRack(tile, info);
                break;
            }
            case 2: {
                this.renderWallShelf(tile, info);
                break;
            }
            case 3: {
                this.renderWallPartition(tile, info);
                break;
            }
            case 4: {
                this.renderBottleRack(tile, info);
                break;
            }
            case 5: {
                this.renderCeilingShelf(tile, info);
                break;
            }
            case 6: {
                this.renderFruitCrate(tile, info);
                break;
            }
            case 7: {
                this.renderFruitCrateBox(tile, info);
                break;
            }
            case 8: {
                this.renderToolBox(tile, info);
                break;
            }
            case 9: {
                this.renderBoxShelf(tile, info);
            }
        }
    }

    public void renderModenRack(T tile, RenderUtil.RenderInfo info) {
        for (int i = 0; i < ((TileModenRack)tile).getInvSize(); ++i) {
            ItemStack stack = ((TileModenRack)tile).getInputItem(i);
            if (stack.m_41619_()) continue;
            boolean isBlock = stack.m_41720_() instanceof BlockItem;
            double addZ = isBlock ? 0.35 + (double)(i / 3 + (i > 8 ? -3 : 0)) * -0.175 : 0.0;
            double x = 2.075 - 0.75 * (double)i + (double)(i / 3) * 2.25;
            double y = 3.2 + (double)(i / 9) * -1.41;
            double z = 0.5 + addZ + (double)(i / 3) * 0.815 + (double)(i / 9) * -2.45;
            RenderUtil.renderItem(info, tile, stack, x, y, z);
        }
    }

    public void renderWallRack(T tile, RenderUtil.RenderInfo info) {
        for (int i = 0; i < ((TileModenRack)tile).getInvSize(); ++i) {
            ItemStack stack = ((TileModenRack)tile).getInputItem(i);
            if (stack.m_41619_()) continue;
            RenderUtil.renderItem(info, tile, stack, 2.075 - 0.75 * (double)i, 3.2, 1.75);
        }
    }

    public void renderWallShelf(T tile, RenderUtil.RenderInfo info) {
        for (int i = 0; i < ((TileModenRack)tile).getInvSize(); ++i) {
            ItemStack stack = ((TileModenRack)tile).getInputItem(i);
            if (stack.m_41619_()) continue;
            RenderUtil.renderItem(info, tile, stack, 2.075 - 0.75 * (double)i + (i > 2 ? 2.25 : 0.0), 3.2 - (i > 2 ? 1.375 : 0.0), 2.0);
        }
    }

    public void renderWallPartition(T tile, RenderUtil.RenderInfo info) {
        for (int i = 0; i < ((TileModenRack)tile).getInvSize(); ++i) {
            ItemStack stack = ((TileModenRack)tile).getInputItem(i);
            if (stack.m_41619_()) continue;
            boolean isBlock = stack.m_41720_() instanceof BlockItem;
            double x = 1.9875 - 0.65 * (double)i + (double)(i / 3) * 1.95;
            double y = 1.95 + (double)(i / 3) * -1.25 + (i > 5 ? 2.5 : 0.0) + (isBlock ? 0.175 : 0.0);
            double z = 2.415 + (double)(i / 6) * 0.275 + (isBlock ? -0.325 : 0.0) * (i > 5 ? -0.1 : 1.0);
            RenderUtil.renderItem(info, tile, stack, x, y, z);
        }
    }

    public void renderBottleRack(T tile, RenderUtil.RenderInfo info) {
        for (int i = 0; i < ((TileModenRack)tile).getInvSize(); ++i) {
            ItemStack stack = ((TileModenRack)tile).getInputItem(i);
            if (stack.m_41619_()) continue;
            boolean isBlock = stack.m_41720_() instanceof BlockItem;
            double addZ = isBlock ? 0.35 + (double)(i / 3 + (i > 8 ? -3 : 0)) * -0.175 : 0.0;
            for (int k = 0; k < 3; ++k) {
                double x = 2.075 - (double)k * 0.75;
                double y = 1.85 + (double)i * -1.25;
                double z = 2.0 + addZ;
                RenderUtil.renderItem(info, tile, stack, x, y, z);
            }
        }
    }

    public void renderCeilingShelf(T tile, RenderUtil.RenderInfo info) {
        PoseStack pose = info.pose();
        for (int i = 0; i < ((TileModenRack)tile).getInvSize(); ++i) {
            boolean isBlock;
            ItemStack stack = ((TileModenRack)tile).getInputItem(i);
            if (stack.m_41619_()) continue;
            pose.m_85836_();
            Item item = stack.m_41720_();
            if (item instanceof BlockItem) {
                BlockItem bItem = (BlockItem)item;
                v0 = true;
            } else {
                v0 = isBlock = false;
            }
            if (isBlock) {
                pose.m_85845_(Vector3f.f_122225_.m_122240_(((TileAbstractSM)tile).getRot()));
                switch (((TileAbstractSM)tile).getFace()) {
                    case SOUTH: {
                        pose.m_85837_(-1.0, 0.0, -1.0);
                        break;
                    }
                    case WEST: {
                        pose.m_85837_(-1.0, 0.0, 0.0);
                        break;
                    }
                    case EAST: {
                        pose.m_85837_(0.0, 0.0, -1.0);
                    }
                }
                pose.m_85837_(0.0, 0.06 + 0.5 * (double)(-(i - 1)), 0.0);
                Block block = ((BlockItem)stack.m_41720_()).m_40614_();
                ModelBlockRenderer.m_111000_();
                if (block instanceof Plate) {
                    Plate plate = (Plate)block;
                    int size = 1;
                    if (stack.m_41784_().m_128441_("BlockEntityTag")) {
                        ItemStackHandler inputInv = new ItemStackHandler(1);
                        inputInv.deserializeNBT(stack.m_41737_("BlockEntityTag"));
                        size += Math.min(5, inputInv.getStackInSlot(0).m_41613_());
                    } else if (stack.m_41613_() > 1) {
                        size += stack.m_41613_() - 1;
                    }
                    for (int k = 0; k < size; ++k) {
                        RenderUtil.renderBlock(tile.m_58904_(), tile.m_58899_(), plate.m_49966_(), this.bRender, pose, info.buf(), info.overlay());
                        pose.m_85837_(0.0, 0.075, 0.0);
                    }
                } else {
                    BlockState state = block.m_49966_();
                    if (state.m_61138_((Property)BaseCookBlock.COOK)) {
                        state = (BlockState)state.m_61124_((Property)BaseCookBlock.COOK, (Comparable)Integer.valueOf(1));
                    }
                    RenderUtil.renderBlock(tile.m_58904_(), tile.m_58899_(), state, this.bRender, pose, info.buf(), info.overlay());
                }
                ModelBlockRenderer.m_111077_();
            } else {
                switch (((TileAbstractSM)tile).getFace()) {
                    case NORTH: {
                        pose.m_85837_(1.0, 0.0, 0.0);
                        break;
                    }
                    case SOUTH: {
                        pose.m_85837_(0.0, 0.0, -1.0);
                        break;
                    }
                    case WEST: {
                        pose.m_85837_(1.0, 0.0, -1.0);
                    }
                }
                pose.m_85837_(-0.5, 0.21 + 0.5 * (double)(-(i - 1)), 0.5);
                RenderUtil.renderItem(info, tile, stack, 0.0, 0.0, 0.0);
            }
            pose.m_85849_();
        }
    }

    public void renderFruitCrate(T tile, RenderUtil.RenderInfo info) {
        for (int i = 0; i < ((TileModenRack)tile).getInvSize(); ++i) {
            BlockItem bItem;
            Block block;
            ItemStack stack = ((TileModenRack)tile).getInputItem(i);
            if (stack.m_41619_()) continue;
            double x = 1.35 - (double)(i / 4) * 0.75;
            int id = i >= 4 ? i - 4 : i;
            double y = 0.65 + (double)id * 0.25;
            double z = 0.15 + (double)id * 0.3;
            float scale = 1.35f;
            Item item = stack.m_41720_();
            if (item instanceof BlockItem && ((block = (bItem = (BlockItem)item).m_40614_()) instanceof FlowerBlock || block instanceof BushBlock) && !(bItem instanceof ItemNameBlockItem)) {
                scale = 1.75f;
                x = 1.0 - (double)(i / 4) * 0.475;
                y = 0.65 + (double)id * 0.105;
                z = 0.15 + (double)id * 0.25;
            }
            RenderUtil.renderItem(info, tile, stack, x, y, z, scale, true);
        }
    }

    public void renderFruitCrateBox(T tile, RenderUtil.RenderInfo info) {
        for (int i = 0; i < ((TileModenRack)tile).getInvSize(); ++i) {
            BlockItem bItem;
            Block block;
            ItemStack stack = ((TileModenRack)tile).getInputItem(i);
            if (stack.m_41619_()) continue;
            double x = 1.3 - (double)(i / 4) * 0.625;
            int id = i >= 4 ? i - 4 : i;
            double y = 0.6;
            double z = 0.45 + (double)id * 0.35;
            float scale = 1.35f;
            Item item = stack.m_41720_();
            if (item instanceof BlockItem && ((block = (bItem = (BlockItem)item).m_40614_()) instanceof FlowerBlock || block instanceof BushBlock) && !(bItem instanceof ItemNameBlockItem)) {
                scale = 1.75f;
                x = 1.0 - (double)(i / 4) * 0.475;
                z = 0.4 + (double)id * 0.25;
            }
            RenderUtil.renderItem(info, tile, stack, x, y, z, scale, true);
        }
    }

    public void renderToolBox(T tile, RenderUtil.RenderInfo info) {
        PoseStack pose = info.pose();
        for (int i = 0; i < ((TileModenRack)tile).getInvSize(); ++i) {
            ItemStack stack = ((TileModenRack)tile).getInputItem(i);
            if (stack.m_41619_()) continue;
            pose.m_85836_();
            pose.m_85845_(Vector3f.f_122225_.m_122240_(((TileAbstractSM)tile).getRot()));
            pose.m_85837_(0.5, 0.9, 0.25 + (double)i * 0.175);
            switch (((TileAbstractSM)tile).getFace()) {
                case SOUTH: {
                    pose.m_85837_(-1.0, 0.0, -1.0);
                    break;
                }
                case WEST: {
                    pose.m_85837_(-1.0, 0.0, 0.0);
                    break;
                }
                case EAST: {
                    pose.m_85837_(0.0, 0.0, -1.0);
                }
            }
            pose.m_85845_(Vector3f.f_122227_.m_122240_(-225.0f));
            pose.m_85841_(4.0f, 4.0f, 4.0f);
            pose.m_85841_(0.375f, 0.375f, 0.375f);
            info.render().m_174269_(stack, ItemTransforms.TransformType.FIXED, info.light(), info.overlay(), pose, info.buf(), 0);
            pose.m_85849_();
        }
    }

    public void renderBoxShelf(T tile, RenderUtil.RenderInfo info) {
        for (int i = 0; i < ((TileModenRack)tile).getInvSize(); ++i) {
            boolean bl;
            ItemStack stack = ((TileModenRack)tile).getInputItem(i);
            if (stack.m_41619_()) continue;
            Item item = stack.m_41720_();
            if (item instanceof BlockItem) {
                BlockItem block = (BlockItem)item;
                bl = true;
            } else {
                bl = false;
            }
            boolean isBlock = bl;
            double x = isBlock ? 1.875 - 0.55 * (double)i : 2.05 - 0.7 * (double)i;
            double y = 0.5;
            double z = (isBlock ? 1.8 : 1.6) + (double)(i / 3) * 0.815;
            RenderUtil.renderItem(info, tile, stack, x, y, z);
        }
    }
}

