/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.render.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import java.util.Objects;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import sweetmagic.init.BlockInit;
import sweetmagic.init.render.block.RenderAbstractTile;
import sweetmagic.init.tile.sm.TileAbstractSM;
import sweetmagic.init.tile.sm.TileReplicaAltar;
import sweetmagic.util.RenderUtil;

public class RenderReplicaAltar<T extends TileReplicaAltar>
extends RenderAbstractTile<T> {
    private static final Block SQUARE_BLANK = BlockInit.magic_square_l_blank;

    public RenderReplicaAltar(BlockEntityRendererProvider.Context con) {
        super(con);
    }

    @Override
    public void render(T tile, float parTick, RenderUtil.RenderInfo info) {
        ItemStack stack;
        int gameTime = ((TileAbstractSM)tile).getClientTime();
        boolean isCraft = ((TileReplicaAltar)tile).isCraft;
        ItemStack itemStack = stack = !isCraft ? ((TileReplicaAltar)tile).getInputItem() : ((TileReplicaAltar)tile).copyMagic;
        if (stack.m_41619_() && !isCraft) {
            stack = ((TileReplicaAltar)tile).getOutItem();
        }
        this.renderStack(tile, info, stack, gameTime, 0.5f, 0.0, -0.1, 0.0);
        if (isCraft) {
            int nowTick = ((TileReplicaAltar)tile).nowTick;
            float progress = Math.min(1.0f, (float)nowTick * 1.25f / ((float)((TileReplicaAltar)tile).maxCraftTime * 20.0f));
            float f = (float)gameTime / -20.0f;
            Objects.requireNonNull(this);
            float angle = f * 57.295776f;
            float size = Math.min(1.0f, 0.5f + 0.9f * progress);
            float rotY = ((float)gameTime + parTick) / 90.0f;
            int count = ((TileReplicaAltar)tile).stackList.size();
            int maxCount = (int)((float)count * Math.min(1.0f, 1.15f - progress));
            PoseStack pose = info.pose();
            pose.m_85836_();
            pose.m_85837_(0.5, 0.9, 0.5);
            pose.m_85841_(size, size, size);
            pose.m_85845_(Vector3f.f_122225_.m_122240_(-angle));
            pose.m_85837_(-0.5, 0.0, -0.5);
            RenderUtil.renderBlock(info, new RenderUtil.RenderColor(0.28235295f, 1.0f, 1.0f, info.light(), info.overlay()), SQUARE_BLANK);
            pose.m_85849_();
            for (int i = 0; i < maxCount; ++i) {
                ItemStack result = ((TileReplicaAltar)tile).stackList.get(i);
                if (result.m_41619_()) continue;
                pose.m_85836_();
                pose.m_85837_(0.5, (double)1.3f + Math.sin((float)gameTime / 10.0f) * (double)0.05f, 0.5);
                Objects.requireNonNull(this);
                pose.m_85845_(Vector3f.f_122225_.m_122240_(rotY * 57.295776f + (float)(i * (360 / count)) + (float)nowTick * 4.0f));
                pose.m_85841_(0.35f, 0.35f, 0.35f);
                pose.m_85837_(2.0, 0.0, 0.0);
                info.itemRenderNo(result);
                pose.m_85849_();
            }
        }
    }

    public void renderStack(T tile, RenderUtil.RenderInfo info, ItemStack stack, int gameTime, float scale, double x, double y, double z) {
        if (stack.m_41619_()) {
            return;
        }
        PoseStack pose = info.pose();
        pose.m_85836_();
        pose.m_85837_(0.5 + x, 1.4 + y + Math.sin((double)gameTime * 0.1) * 0.05, 0.5 + z);
        float rotY = (float)gameTime * 0.06f;
        Objects.requireNonNull(this);
        pose.m_85845_(Vector3f.f_122225_.m_122240_(rotY * 57.295776f));
        pose.m_85841_(scale, scale, scale);
        info.itemRenderNo(stack);
        pose.m_85849_();
    }
}

