/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.render.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import sweetmagic.SweetMagicCore;
import sweetmagic.init.BlockInit;
import sweetmagic.init.block.magic.SturdustCrystal;
import sweetmagic.init.render.block.RenderAbstractTile;
import sweetmagic.init.tile.sm.TileAbstractSM;
import sweetmagic.init.tile.sm.TileSturdustCrystal;
import sweetmagic.util.RenderUtil;

public class RenderSturdustCrystal<T extends TileSturdustCrystal>
extends RenderAbstractTile<T> {
    private static final ResourceLocation CRYSTAL = SweetMagicCore.getSRC("textures/entity/stardust_crystal.png");
    private static final Block SQUARE = BlockInit.magic_square_h;
    private static final RenderType RENDER_TYPE = RenderType.m_110458_((ResourceLocation)CRYSTAL);
    private static final float SIN_45 = (float)Math.sin(0.7853981633974483);
    private final ModelPart cube;
    private final ModelPart glass;

    public RenderSturdustCrystal(BlockEntityRendererProvider.Context con) {
        super(con);
        ModelPart model = con.m_173582_(ModelLayers.f_171145_);
        this.glass = model.m_171324_("glass");
        this.cube = model.m_171324_("cube");
    }

    @Override
    public void render(T tile, float parTick, RenderUtil.RenderInfo info) {
        this.renderCrystal(tile, parTick, info);
        this.renderSquare(tile, parTick, info);
        this.renderGate(tile, parTick, info);
    }

    public void renderCrystal(T tile, float parTick, RenderUtil.RenderInfo info) {
        PoseStack pose = info.pose();
        pose.m_85836_();
        int gameTime = ((TileAbstractSM)tile).getClientTime();
        float f1 = ((float)gameTime + parTick) * 3.0f;
        VertexConsumer vert = info.buf().m_6299_(RENDER_TYPE).m_85950_(0.0f, 0.0f, 0.0f, 1.0f);
        pose.m_85841_(1.0f, 1.0f, 1.0f);
        pose.m_85837_(0.5, 1.0, 0.5);
        int overray = OverlayTexture.f_118083_;
        pose.m_85845_(Vector3f.f_122225_.m_122240_(f1));
        pose.m_85837_(0.0, Math.sin(((float)gameTime + parTick) / 7.5f) * 0.25, 0.0);
        pose.m_85845_(new Quaternion(new Vector3f(SIN_45, 0.0f, SIN_45), 60.0f, true));
        this.glass.m_104301_(pose, vert, info.light(), overray);
        pose.m_85841_(0.875f, 0.875f, 0.875f);
        pose.m_85845_(new Quaternion(new Vector3f(SIN_45, 0.0f, SIN_45), 60.0f, true));
        pose.m_85845_(Vector3f.f_122225_.m_122240_(f1));
        this.glass.m_104301_(pose, vert, info.light(), overray);
        pose.m_85841_(0.875f, 0.875f, 0.875f);
        pose.m_85845_(new Quaternion(new Vector3f(SIN_45, 0.0f, SIN_45), 60.0f, true));
        pose.m_85845_(Vector3f.f_122225_.m_122240_(f1));
        this.cube.m_104301_(pose, vert, info.light(), overray);
        pose.m_85849_();
    }

    public void renderSquare(T tile, float parTick, RenderUtil.RenderInfo info) {
        PoseStack pose = info.pose();
        pose.m_85836_();
        pose.m_85837_(0.5, 0.65, 0.5);
        int gameTime = ((TileAbstractSM)tile).getClientTime();
        pose.m_85837_(0.0, Math.sin(((float)gameTime + parTick) / 15.0f) * 0.02, 0.0);
        pose.m_85841_(2.0f, 2.0f, 2.0f);
        float f = ((float)gameTime + parTick) / 20.0f;
        Objects.requireNonNull(this);
        float angle = f * 57.295776f;
        pose.m_85845_(Vector3f.f_122225_.m_122240_(angle));
        pose.m_85837_(-0.25, -0.25, -0.25);
        pose.m_85841_(0.5f, 0.5f, 0.5f);
        RenderUtil.renderBlock(info, RenderUtil.RenderColor.create(info), SQUARE);
        pose.m_85849_();
    }

    public void renderGate(T tile, float parTick, RenderUtil.RenderInfo info) {
        if (!((TileSturdustCrystal)tile).isRender) {
            return;
        }
        BlockPos pos = tile.m_58899_();
        int x = pos.m_123341_();
        int y = pos.m_123342_();
        int z = pos.m_123343_();
        Direction face = ((TileAbstractSM)tile).getFace();
        boolean isZ = face == Direction.NORTH || face == Direction.SOUTH;
        Map<BlockPos, BlockState> posMap = isZ ? SturdustCrystal.getZPosMap(pos) : SturdustCrystal.getXPosMap(pos);
        RenderUtil.RenderColor color = RenderUtil.RenderColor.create(info);
        PoseStack pose = info.pose();
        for (Map.Entry<BlockPos, BlockState> map : posMap.entrySet()) {
            pose.m_85836_();
            BlockPos p = map.getKey();
            pose.m_85837_((double)(p.m_123341_() - x), (double)(p.m_123342_() - y) + 0.01, (double)(p.m_123343_() - z));
            RenderUtil.renderTransBlock(pose, info.buf(), color, map.getValue().m_60734_().m_49966_(), 0.75f);
            pose.m_85849_();
        }
    }

    @Override
    public int m_142163_() {
        return 48;
    }
}

