/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.render.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import java.util.Objects;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import sweetmagic.init.BlockInit;
import sweetmagic.init.render.block.RenderAbstractTile;
import sweetmagic.init.tile.sm.TileAbstractSM;
import sweetmagic.init.tile.sm.TileTransferGateVertical;
import sweetmagic.util.RenderUtil;

public class RenderTransferGateVertical<T extends TileTransferGateVertical>
extends RenderAbstractTile<T> {
    private static final ItemStack GATE = new ItemStack((ItemLike)BlockInit.transfer_gate_vertical);
    private static final ItemStack TOP = new ItemStack((ItemLike)BlockInit.transfer_gate_vertical_top);
    private static final Block SQUARE = BlockInit.magic_square_l_blank;

    public RenderTransferGateVertical(BlockEntityRendererProvider.Context con) {
        super(con);
    }

    @Override
    public void render(T tile, float parTick, RenderUtil.RenderInfo info) {
        this.renderModel(tile, parTick, info);
        this.renderSquare(tile, parTick, info);
    }

    public void renderModel(T tile, float parTick, RenderUtil.RenderInfo info) {
        PoseStack pose = info.pose();
        pose.m_85836_();
        pose.m_85837_(0.5, -0.5, 0.5);
        pose.m_85841_(2.0f, 2.0f, 2.0f);
        pose.m_85845_(Vector3f.f_122225_.m_122240_(((TileAbstractSM)tile).getRot()));
        info.itemRenderNo(GATE);
        pose.m_85849_();
        pose.m_85836_();
        pose.m_85837_(0.5, 0.0, 0.5);
        int gameTime = ((TileAbstractSM)tile).getClientTime();
        float f = ((float)gameTime + parTick) * 0.067f;
        Objects.requireNonNull(this);
        float angle = f * 57.295776f;
        pose.m_85845_(Vector3f.f_122225_.m_122240_(angle));
        pose.m_85841_(3.5f, 3.5f, 3.5f);
        pose.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
        pose.m_85837_(-0.0025, -0.1125, -0.2);
        info.itemRenderNo(TOP);
        pose.m_85849_();
    }

    public void renderSquare(T tile, float parTick, RenderUtil.RenderInfo info) {
        int gameTime = ((TileAbstractSM)tile).getClientTime();
        PoseStack pose = info.pose();
        pose.m_85836_();
        pose.m_85837_(0.5, 0.75, 0.5);
        pose.m_85841_(5.0f, 5.0f, 5.0f);
        float f = -((float)gameTime + parTick) * 0.1f;
        Objects.requireNonNull(this);
        float angle = f * 57.295776f;
        pose.m_85845_(Vector3f.f_122225_.m_122240_(angle));
        pose.m_85837_(-0.25, -0.25, -0.25);
        pose.m_85841_(0.5f, 0.5f, 0.5f);
        float rgb = (float)Math.sin(((float)gameTime + parTick) / 20.0f) * 40.0f;
        RenderUtil.RenderColor color = RenderUtil.RenderColor.create(76.0f + rgb, 165.0f + rgb, 215.0f + rgb, info);
        RenderUtil.renderBlock(info, color, SQUARE);
        pose.m_85849_();
    }

    @Override
    public int m_142163_() {
        return 96;
    }
}

