/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.render.entity.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import sweetmagic.init.entity.monster.boss.AbstractSMBoss;
import sweetmagic.util.RenderUtil;

public abstract class AbstractEntityLayer<T extends LivingEntity, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    protected EntityModel<T> model;
    protected final ItemInHandRenderer render;
    protected final float pi = 57.295776f;

    public AbstractEntityLayer(RenderLayerParent<T, M> layer, EntityRendererProvider.Context con) {
        super(layer);
        this.render = con.m_234598_();
    }

    public void render(PoseStack pose, MultiBufferSource buf, int light, T entity, float swing, float swingAmount, float parTick, float ageTick, float netHeadYaw, float headPitch) {
        this.render(pose, buf, light, entity);
    }

    public void render(PoseStack pose, MultiBufferSource buf, int light, T entity) {
    }

    protected void renderHead(T entity, ModelPart head, PoseStack pose, MultiBufferSource buf, int light, float scale, float x, float y, float z) {
        Item item;
        ItemStack stack = entity.m_6844_(EquipmentSlot.HEAD);
        if (stack.m_41619_() || !((item = stack.m_41720_()) instanceof BlockItem)) {
            return;
        }
        BlockItem bItem = (BlockItem)item;
        pose.m_85836_();
        head.m_104299_(pose);
        pose.m_85845_(Vector3f.f_122223_.m_122240_(180.0f));
        pose.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
        pose.m_85837_((double)x, (double)y, (double)z);
        pose.m_85841_(scale, scale, scale);
        RenderUtil.renderBlock(pose, buf, new RenderUtil.RenderColor(1.0f, 1.0f, 1.0f, light, OverlayTexture.f_118083_), bItem.m_40614_());
        pose.m_85849_();
    }

    public void renderShadow(AbstractSMBoss entity, PoseStack pose, MultiBufferSource buf, float swing, float swingAmount, float parTick, int light, float ageTick, float headYaw, float headPitch, float rgb, float addY, float scale) {
        if (!entity.getMagic()) {
            return;
        }
        pose.m_85836_();
        pose.m_85841_(scale, scale, scale);
        EntityModel model = this.m_117386_();
        model.m_6839_((Entity)entity, swing, swingAmount, parTick);
        this.m_117386_().m_102624_(model);
        VertexConsumer ver = buf.m_6299_(RenderType.m_110458_((ResourceLocation)this.getTex()));
        model.m_6973_((Entity)entity, swing, swingAmount, ageTick, headYaw, headPitch);
        model.m_7695_(pose, ver, light, OverlayTexture.f_118083_, rgb, rgb, rgb, 1.0f);
        pose.m_85849_();
    }

    public void renderItem(T entity, ItemStack stack, PoseStack pose, MultiBufferSource buf, int light) {
        this.render.m_109322_(entity, stack, ItemTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, false, pose, buf, light);
    }

    public void renderItemFix(T entity, ItemStack stack, PoseStack pose, MultiBufferSource buf, int light) {
        this.render.m_109322_(entity, stack, ItemTransforms.TransformType.FIXED, false, pose, buf, light);
    }

    protected float xOffset(float size) {
        return size * 0.01f;
    }

    protected ResourceLocation getTex() {
        return null;
    }

    protected EntityModel<T> getModel() {
        return this.model;
    }

    protected void setModel(EntityModel<T> model) {
        this.model = model;
    }

    protected ModelPart getModel(EntityRendererProvider.Context con, ModelLayerLocation layer) {
        return con.m_174027_().m_171103_(layer);
    }
}

