/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.render.entity.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import sweetmagic.SweetMagicCore;
import sweetmagic.init.ItemInit;
import sweetmagic.init.entity.monster.boss.AbstractSMBoss;
import sweetmagic.init.entity.monster.boss.Arlaune;
import sweetmagic.init.render.entity.layer.AbstractEntityLayer;
import sweetmagic.init.render.entity.model.ArlauneModel;

public class ArlauneLayer<T extends Arlaune, M extends ArlauneModel<T>>
extends AbstractEntityLayer<T, M> {
    private static final ItemStack HAIRPIN = new ItemStack((ItemLike)ItemInit.cherry_ornate_hairpin);
    private static final ItemStack UMBRELLA = new ItemStack((ItemLike)ItemInit.cosmic_arlaune_parasol);
    private static final ResourceLocation TEX = SweetMagicCore.getSRC("textures/entity/arlaune.png");

    public ArlauneLayer(RenderLayerParent<T, M> layer, EntityRendererProvider.Context con) {
        super(layer, con);
        this.setModel(new ArlauneModel(this.getModel(con, ArlauneModel.LAYER)));
    }

    @Override
    public void render(PoseStack pose, MultiBufferSource buf, int light, T entity, float swing, float swingAmount, float parTick, float ageTick, float netHeadYaw, float headPitch) {
        this.renderShadow((AbstractSMBoss)entity, pose, buf, swing, swingAmount, parTick, light, ageTick, netHeadYaw, headPitch, 0.5f, -1.0f, 1.0f);
        this.renderArmWithItem(entity, pose, buf, light);
    }

    protected void renderArmWithItem(T entity, PoseStack pose, MultiBufferSource buf, int light) {
        pose.m_85836_();
        ArlauneModel model = (ArlauneModel)this.m_117386_();
        model.translateAndRotate(model.head, pose);
        pose.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
        pose.m_85845_(Vector3f.f_122223_.m_122240_(180.0f));
        pose.m_85837_(0.0, -0.2, -0.5);
        pose.m_85837_(0.3, 0.4, 0.45);
        this.renderItem(entity, HAIRPIN, pose, buf, light);
        pose.m_85849_();
        pose.m_85836_();
        model.translateAndRotate(model.getArm(true), pose);
        pose.m_85845_(Vector3f.f_122225_.m_122240_(0.0f));
        pose.m_85845_(Vector3f.f_122223_.m_122240_(120.0f));
        pose.m_85837_(0.0, -0.1, -0.2);
        if (((AbstractSMBoss)entity).getMagic()) {
            pose.m_85837_(0.0, 0.2, 0.0);
        }
        pose.m_85837_(0.0, -0.4, -0.2875);
        this.renderItem(entity, UMBRELLA, pose, buf, light);
        pose.m_85849_();
    }

    @Override
    protected ResourceLocation getTex() {
        return TEX;
    }
}

