/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.render.entity.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import sweetmagic.SweetMagicCore;
import sweetmagic.init.BlockInit;
import sweetmagic.init.ItemInit;
import sweetmagic.init.entity.monster.boss.AbstractSMBoss;
import sweetmagic.init.entity.monster.boss.HolyAngel;
import sweetmagic.init.render.entity.layer.AbstractEntityLayer;
import sweetmagic.init.render.entity.model.HolyModel;
import sweetmagic.util.RenderUtil;

public class HolyAngelLayer<T extends HolyAngel, M extends EntityModel<T>>
extends AbstractEntityLayer<T, M> {
    private static final Block RING = BlockInit.kogen;
    private static final Block GLASS = BlockInit.yellow_glass;
    private static final ItemStack STACK = new ItemStack((ItemLike)ItemInit.angel_wing);
    private static final ResourceLocation TEX = SweetMagicCore.getSRC("textures/entity/holyshining.png");

    public HolyAngelLayer(RenderLayerParent<T, M> layer, EntityRendererProvider.Context con) {
        super(layer, con);
        this.setModel(new HolyModel(con.m_174027_().m_171103_(HolyModel.LAYER)));
    }

    @Override
    public void render(PoseStack pose, MultiBufferSource buf, int light, T entity, float swing, float swingAmount, float parTick, float ageTick, float netHeadYaw, float headPitch) {
        this.renderAngelWingBig(entity, pose, buf, light, false);
        this.renderAngelWingBig(entity, pose, buf, light, true);
        this.renderAngelWingSmall(entity, pose, buf, light, false);
        this.renderAngelWingSmall(entity, pose, buf, light, true);
        this.renderAngelRing(entity, pose, buf, light);
        this.renderORU(entity, pose, buf, parTick, light);
        this.renderShadow((AbstractSMBoss)entity, pose, buf, swing, swingAmount, parTick, light, ageTick, netHeadYaw, headPitch, 0.5f, 0.0f, 1.15f);
    }

    public void renderAngelWingBig(T entity, PoseStack pose, MultiBufferSource buf, int light, boolean isReverse) {
        float scale = ((HolyAngel)entity).getCharge() ? 2.5f : 1.35f;
        float reverseRate = isReverse ? -1.0f : 1.0f;
        pose.m_85836_();
        pose.m_85837_((double)(-0.15f * reverseRate), (double)-0.15f, (double)0.15f);
        pose.m_85845_(Vector3f.f_122224_.m_122240_((60.0f + 20.0f * Mth.m_14031_((float)((float)((HolyAngel)entity).f_19797_ * 0.1f))) * reverseRate));
        pose.m_85841_(scale, -scale, scale);
        this.renderItemFix(entity, STACK, pose, buf, light);
        pose.m_85849_();
    }

    public void renderAngelWingSmall(T entity, PoseStack pose, MultiBufferSource buf, int light, boolean isReverse) {
        float scale = ((HolyAngel)entity).getCharge() ? 1.5f : 1.15f;
        float reverseRate = isReverse ? -1.0f : 1.0f;
        pose.m_85836_();
        pose.m_85837_((double)(-0.25f * reverseRate), (double)0.35f, (double)0.175f);
        pose.m_85845_(Vector3f.f_122224_.m_122240_((60.0f - 20.0f * Mth.m_14031_((float)((float)((HolyAngel)entity).f_19797_ * 0.1f))) * reverseRate));
        pose.m_85845_(Vector3f.f_122223_.m_122240_(-50.0f));
        pose.m_85841_(scale, -scale, scale);
        this.renderItemFix(entity, STACK, pose, buf, light);
        pose.m_85849_();
    }

    public void renderAngelRing(T entity, PoseStack pose, MultiBufferSource buf, int light) {
        float scale = ((HolyAngel)entity).getCharge() ? 1.675f : 1.15f;
        pose.m_85836_();
        pose.m_85841_(scale, scale, scale);
        pose.m_85837_(-0.5, -0.5, -0.5);
        RenderUtil.renderBlock(pose, buf, new RenderUtil.RenderColor(1.0f, 1.0f, 1.0f, light, OverlayTexture.f_118083_), RING);
        pose.m_85849_();
    }

    public void renderORU(T entity, PoseStack pose, MultiBufferSource buf, float parTick, int light) {
        int oruSize = ((HolyAngel)entity).getORU();
        float scale = 0.25f;
        float pi = 57.295776f;
        float rotY = ((float)((HolyAngel)entity).f_19797_ + parTick) / 15.0f;
        float addY = 0.0f;
        float rot = rotY * pi;
        for (int i = 0; i < oruSize; ++i) {
            boolean isReverse;
            boolean bl = isReverse = i % 2 == 0;
            if (isReverse) {
                addY -= 0.3f;
                rot *= -1.0f;
            }
            pose.m_85836_();
            pose.m_85837_(0.0, (double)(1.35f + addY), 0.0);
            pose.m_85845_(Vector3f.f_122225_.m_122240_(rot + (isReverse ? 180.0f : 0.0f) + (float)(i / 2) * 30.0f));
            pose.m_85841_(scale, scale, scale);
            pose.m_85837_(4.0, 0.0, 0.0);
            RenderUtil.renderBlock(pose, buf, new RenderUtil.RenderColor(1.0f, 1.0f, 1.0f, light, OverlayTexture.f_118083_), GLASS);
            pose.m_85849_();
        }
    }

    @Override
    protected ResourceLocation getTex() {
        return TEX;
    }
}

