/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.render.entity.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.SkeletonModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import sweetmagic.SweetMagicCore;
import sweetmagic.init.entity.monster.SkullFrostRoyalGuard;
import sweetmagic.init.render.entity.layer.AbstractEntityLayer;

public class RoyalGuardLayer<T extends AbstractSkeleton, M extends SkeletonModel<T>>
extends AbstractEntityLayer<T, M> {
    private static final ResourceLocation TEX = SweetMagicCore.getSRC("textures/entity/skullflost_guard.png");
    private static final ItemStack SHIELD = new ItemStack((ItemLike)Items.f_42740_);

    public RoyalGuardLayer(RenderLayerParent<T, M> layer, EntityRendererProvider.Context con) {
        super(layer, con);
        this.setModel(new SkeletonModel(this.getModel(con, ModelLayers.f_171236_)));
    }

    @Override
    public void render(PoseStack pose, MultiBufferSource buf, int light, T entity, float swing, float swingAmount, float parTick, float ageTick, float netHeadYaw, float headPitch) {
        pose.m_85836_();
        this.renderArmWithItem(entity, pose, buf, light, swing, swingAmount, parTick, ageTick, netHeadYaw, headPitch);
        pose.m_85849_();
    }

    protected void renderArmWithItem(T entity, PoseStack pose, MultiBufferSource buf, int light, float swing, float swingAmount, float parTick, float ageTick, float netHeadYaw, float headPitch) {
        pose.m_85836_();
        SkeletonModel model = (SkeletonModel)this.m_117386_();
        model.m_6002_(HumanoidArm.LEFT, pose);
        pose.m_85845_(Vector3f.f_122223_.m_122240_(-90.0f));
        pose.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
        pose.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
        pose.m_85837_(0.1, 0.1, -1.75);
        this.render.m_109322_(entity, SHIELD, ItemTransforms.TransformType.THIRD_PERSON_LEFT_HAND, false, pose, buf, light);
        pose.m_85849_();
        if (!((SkullFrostRoyalGuard)entity).getGuard()) {
            return;
        }
        pose.m_85841_(1.05f, 1.05f, 1.05f);
        float f = (float)((AbstractSkeleton)entity).f_19797_ + parTick;
        model.m_6839_(entity, swing, swingAmount, parTick);
        model.m_102872_((HumanoidModel)model);
        VertexConsumer ver = buf.m_6299_(RenderType.m_110436_((ResourceLocation)this.getTex(), (float)(this.xOffset(f) % 1.0f), (float)(f * 0.01f % 1.0f)));
        model.m_6973_(entity, swing, swingAmount, ageTick, netHeadYaw, headPitch);
        model.m_7695_(pose, ver, light, OverlayTexture.f_118083_, 0.25f, 0.25f, 0.25f, 1.0f);
    }

    @Override
    protected ResourceLocation getTex() {
        return TEX;
    }
}

