/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.render.entity.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import sweetmagic.init.BlockInit;
import sweetmagic.init.ItemInit;
import sweetmagic.init.entity.animal.AbstractSummonMob;
import sweetmagic.init.entity.animal.StellaWizard;
import sweetmagic.init.render.entity.layer.AbstractEntityLayer;
import sweetmagic.init.render.entity.model.StellaWizardModel;
import sweetmagic.util.RenderUtil;

public class StellaLayer<T extends StellaWizard, M extends StellaWizardModel<T>>
extends AbstractEntityLayer<T, M> {
    private static final ItemStack RIBBON = new ItemStack((ItemLike)ItemInit.wizard_ribbon);
    private static final Block CRYSTAL = BlockInit.spawn_stone_m;

    public StellaLayer(RenderLayerParent<T, M> layer, EntityRendererProvider.Context con) {
        super(layer, con);
    }

    @Override
    public void render(PoseStack pose, MultiBufferSource buf, int light, T entity) {
        if (((StellaWizard)entity).getCrystal()) {
            this.renderCrystal(entity, pose, buf, light);
        } else {
            this.renderArmWithItem(entity, pose, buf, light);
        }
        this.renderHead(entity, ((StellaWizardModel)this.m_117386_()).getHead(), pose, buf, light, 0.67f, -0.33f, -0.1f, -0.33f);
    }

    protected void renderArmWithItem(T entity, PoseStack pose, MultiBufferSource buf, int light) {
        pose.m_85836_();
        StellaWizardModel model = (StellaWizardModel)this.m_117386_();
        model.translateAndRotate(model.head, pose);
        pose.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
        pose.m_85845_(Vector3f.f_122223_.m_122240_(180.0f));
        float scale = 0.45f;
        pose.m_85837_(0.0, 0.45, -0.2);
        pose.m_85841_(scale, scale, scale);
        this.renderItemFix(entity, RIBBON, pose, buf, light);
        pose.m_85849_();
        pose.m_85836_();
        boolean flag = true;
        ItemStack wand = ((StellaWizard)entity).getStack();
        if (((AbstractSummonMob)((Object)entity)).getShit()) {
            flag = false;
            pose.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
            pose.m_85837_(0.0, -0.75, 0.075);
        }
        if (flag) {
            model.translateAndRotate(model.getArm(false), pose);
            pose.m_85845_(Vector3f.f_122223_.m_122240_(225.0f));
            pose.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
            pose.m_85837_(0.0, -0.2, -0.5);
        }
        this.renderItem(entity, wand, pose, buf, light);
        pose.m_85849_();
    }

    protected void renderCrystal(T entity, PoseStack pose, MultiBufferSource buf, int light) {
        float scale = 0.75f + ((StellaWizard)entity).getCrystalHealth() / ((StellaWizard)entity).getMaxCrystalHealth() * 1.5f;
        pose.m_85836_();
        pose.m_85841_(scale, scale * 1.5f, scale);
        pose.m_85837_(-0.5, 0.5, 0.5);
        pose.m_85845_(Vector3f.f_122223_.m_122240_(180.0f));
        RenderUtil.renderBlock(pose, buf, new RenderUtil.RenderColor(1.0f, 1.0f, 1.0f, light, OverlayTexture.f_118083_), CRYSTAL);
        pose.m_85849_();
    }
}

