/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.render.entity.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import net.minecraft.client.model.BookModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import sweetmagic.SweetMagicCore;
import sweetmagic.init.entity.monster.boss.StellaWizardMaster;
import sweetmagic.init.render.entity.layer.AbstractEntityLayer;
import sweetmagic.init.render.entity.model.SMRobeModel;
import sweetmagic.init.render.entity.model.StellaWizardModel;

public class StellaMasterLayer<T extends StellaWizardMaster, M extends StellaWizardModel<T>>
extends AbstractEntityLayer<T, M> {
    private static final ResourceLocation MAGIC_BOOK = SweetMagicCore.getSRC("textures/entity/stardustbook.png");
    private static final RenderType RENDER_TYPE = RenderType.m_110458_((ResourceLocation)MAGIC_BOOK);
    private final BookModel bookModel;
    private final SMRobeModel<T> robeModel;

    public StellaMasterLayer(RenderLayerParent<T, M> layer, EntityRendererProvider.Context con) {
        super(layer, con);
        this.bookModel = new BookModel(con.m_174023_(ModelLayers.f_171271_));
        this.robeModel = new SMRobeModel(con.m_174023_(SMRobeModel.LAYER));
    }

    @Override
    public void render(PoseStack pose, MultiBufferSource buf, int light, T entity, float swing, float swingAmount, float parTick, float ageTick, float netHeadYaw, float headPitch) {
        this.renderArmWithItem(entity, pose, buf, light, parTick);
        this.renderArmor(entity, pose, buf, light, swing, swingAmount, parTick);
    }

    protected void renderArmWithItem(T entity, PoseStack pose, MultiBufferSource buf, int light, float parTick) {
        pose.m_85836_();
        float bookValue = 0.0f;
        StellaWizardModel model = (StellaWizardModel)this.m_117386_();
        model.translateAndRotate(model.getArm(false), pose);
        if (entity.isTarget()) {
            pose.m_85837_(0.0, 0.4, -0.3);
            bookValue = -200.0f;
        } else {
            pose.m_85837_(0.0, 0.6, -0.5);
        }
        pose.m_85845_(Vector3f.f_122223_.m_122240_(225.0f));
        pose.m_85845_(Vector3f.f_122225_.m_122240_(90.0f));
        this.bookModel.m_102292_(0.0f, Mth.m_14036_((float)0.0f, (float)0.0f, (float)1.0f), Mth.m_14036_((float)0.0f, (float)0.0f, (float)1.0f), bookValue);
        VertexConsumer vert = buf.m_6299_(RENDER_TYPE).m_85950_(0.0f, 0.0f, 0.0f, 1.0f);
        this.bookModel.m_102316_(pose, vert, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        pose.m_85849_();
    }

    protected void renderArmor(T entity, PoseStack pose, MultiBufferSource buf, int light, float swing, float swingAmount, float parTick) {
        if (((StellaWizardMaster)entity).getRobeType() == -1) {
            return;
        }
        pose.m_85836_();
        pose.m_85841_(1.05f, 1.05f, 1.05f);
        ((StellaWizardModel)this.m_117386_()).m_102624_((EntityModel)this.robeModel);
        VertexConsumer vert = ItemRenderer.m_115184_((MultiBufferSource)buf, (RenderType)RenderType.m_110431_((ResourceLocation)((StellaWizardMaster)entity).getTEX()), (boolean)false, (boolean)false);
        this.robeModel.armorView(entity, pose, swing, swingAmount);
        this.robeModel.m_7695_(pose, vert, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        pose.m_85849_();
    }
}

