/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.render.entity.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import sweetmagic.SweetMagicCore;
import sweetmagic.init.BlockInit;
import sweetmagic.init.entity.monster.BlazeTempestTornado;
import sweetmagic.init.render.entity.layer.AbstractEntityLayer;
import sweetmagic.init.render.entity.model.TempestModel;
import sweetmagic.util.RenderUtil;

public class TempestTornadoLayer<T extends BlazeTempestTornado, M extends EntityModel<T>>
extends AbstractEntityLayer<T, M> {
    private static final ItemStack CANDLE = new ItemStack((ItemLike)BlockInit.candle);
    private static final ItemStack CANDLE_EX = new ItemStack((ItemLike)BlockInit.candle_ex);
    private static final Block TORNADO = BlockInit.tornado;
    private static final ResourceLocation TEX = SweetMagicCore.getSRC("textures/entity/mob_armor.png");

    public TempestTornadoLayer(RenderLayerParent<T, M> layer, EntityRendererProvider.Context con) {
        super(layer, con);
        this.setModel(new TempestModel(this.getModel(con, TempestModel.LAYER)));
    }

    @Override
    public void render(PoseStack pose, MultiBufferSource buf, int light, T entity, float swing, float swingAmount, float parTick, float ageTick, float netHeadYaw, float headPitch) {
        float scale = 1.0f;
        int tickCount = ((BlazeTempestTornado)entity).f_19797_;
        float rotY = ((float)tickCount + parTick) * 100.0f / (float)Math.PI;
        pose.m_85836_();
        pose.m_85845_(Vector3f.f_122225_.m_122240_(rotY));
        pose.m_85837_(-0.5, (double)1.05f, -0.5);
        pose.m_85841_(scale, -scale, scale);
        RenderUtil.RenderColor color = new RenderUtil.RenderColor(0.0f, 0.0f, 0.0f, light, OverlayTexture.f_118083_);
        RenderUtil.renderBlock(pose, buf, color, TORNADO);
        pose.m_85849_();
        int count = ((BlazeTempestTornado)entity).getCandole();
        int size = 4;
        float pi = 57.295776f;
        rotY = ((float)tickCount + parTick) / 10.0f;
        scale = 0.75f;
        for (int i = 0; i < size; ++i) {
            pose.m_85836_();
            pose.m_85837_(0.0, (double)(-0.35f + Mth.m_14089_((float)(((float)(i * 2) + ageTick) * 0.1f)) * 0.1f), 0.0);
            pose.m_85845_(Vector3f.f_122225_.m_122240_(-rotY * pi + (float)(i * (360 / size))));
            pose.m_85841_(scale, -scale, scale);
            pose.m_85837_(0.6944999694824219, 0.0, 0.0);
            ItemStack stack = count > i ? CANDLE : CANDLE_EX;
            this.renderItemFix(entity, stack, pose, buf, light);
            pose.m_85849_();
        }
    }

    @Override
    protected ResourceLocation getTex() {
        return TEX;
    }
}

