/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.render.entity.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import sweetmagic.init.ItemInit;
import sweetmagic.init.entity.animal.WitchCat;
import sweetmagic.init.render.entity.layer.AbstractEntityLayer;
import sweetmagic.init.render.entity.model.WitchCatModel;

public class WitchCatLayer<T extends WitchCat, M extends WitchCatModel<T>>
extends AbstractEntityLayer<T, M> {
    private static final ItemStack STACK = new ItemStack((ItemLike)ItemInit.cat_wing);

    public WitchCatLayer(RenderLayerParent<T, M> layer, EntityRendererProvider.Context con) {
        super(layer, con);
    }

    @Override
    public void render(PoseStack pose, MultiBufferSource buf, int light, T entity) {
        this.renderAngelWingBig(entity, pose, buf, light, false);
        this.renderAngelWingBig(entity, pose, buf, light, true);
        this.renderArmWithItem(entity, pose, buf, light);
    }

    public void renderAngelWingBig(T entity, PoseStack pose, MultiBufferSource buf, int light, boolean isReverse) {
        float scale = 1.35f;
        float reverseRate = isReverse ? -1.0f : 1.0f;
        pose.m_85836_();
        pose.m_85837_((double)(-0.075f * reverseRate), (double)0.55f, (double)-0.05f);
        pose.m_85845_(Vector3f.f_122224_.m_122240_((60.0f + 45.0f * Mth.m_14031_((float)((float)((WitchCat)((Object)entity)).f_19797_ * 0.2f))) * reverseRate));
        pose.m_85841_(scale, -scale, scale);
        this.renderItemFix(entity, STACK, pose, buf, light);
        pose.m_85849_();
    }

    protected void renderArmWithItem(T entity, PoseStack pose, MultiBufferSource buf, int light) {
        ItemStack stack = entity.m_21205_();
        if (stack.m_41619_()) {
            return;
        }
        pose.m_85836_();
        ((WitchCatModel)this.m_117386_()).translateToHand(HumanoidArm.RIGHT, pose);
        pose.m_85845_(Vector3f.f_122223_.m_122240_(180.0f));
        pose.m_85837_(-0.075, -0.6, 0.4);
        this.renderItem(entity, stack, pose, buf, light);
        pose.m_85849_();
    }
}

