/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.render.entity.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import java.util.Objects;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import sweetmagic.SweetMagicCore;
import sweetmagic.init.BlockInit;
import sweetmagic.init.ItemInit;
import sweetmagic.init.entity.monster.boss.AbstractSMBoss;
import sweetmagic.init.entity.monster.boss.WindWitchMaster;
import sweetmagic.init.render.entity.layer.AbstractEntityLayer;
import sweetmagic.init.render.entity.model.WindWitchModel;
import sweetmagic.util.RenderUtil;

public class WitchMasterWandLayer<T extends WindWitchMaster, M extends WindWitchModel<T>>
extends AbstractEntityLayer<T, M> {
    private static final ItemStack WAND = new ItemStack((ItemLike)ItemInit.deuscrystal_wand_g);
    private static final Block SQUARE4 = BlockInit.magic_square_h;
    private static final ResourceLocation TEX = SweetMagicCore.getSRC("textures/entity/windwitch_master.png");

    public WitchMasterWandLayer(RenderLayerParent<T, M> layer, EntityRendererProvider.Context con) {
        super(layer, con);
        this.setModel(new WindWitchModel(this.getModel(con, WindWitchModel.LAYER)));
    }

    @Override
    public void render(PoseStack pose, MultiBufferSource buf, int light, T entity, float swing, float swingAmount, float parTick, float ageTick, float netHeadYaw, float headPitch) {
        if (((WindWitchMaster)entity).isCharge()) {
            this.renderCycleWand(entity, pose, buf, light, WAND);
        } else {
            this.renderArmWithItem(entity, pose, buf, light);
        }
        this.renderShadow((AbstractSMBoss)entity, pose, buf, swing, swingAmount, parTick, light, ageTick, netHeadYaw, headPitch, 0.5f, -0.65f, 1.15f);
    }

    protected void renderArmWithItem(T entity, PoseStack pose, MultiBufferSource buf, int light) {
        pose.m_85836_();
        T smMob = entity;
        if (!smMob.isTarget()) {
            pose.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
            pose.m_85845_(Vector3f.f_122227_.m_122240_(270.0f));
            pose.m_85845_(Vector3f.f_122222_.m_122240_(-10.0f));
            pose.m_85837_(-0.17, -0.275, -0.425);
        } else {
            WindWitchModel model = (WindWitchModel)this.m_117386_();
            model.translateAndRotate(model.getArm(false), pose);
            pose.m_85845_(Vector3f.f_122223_.m_122240_(225.0f));
            pose.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
            pose.m_85837_(0.0, -0.2, -0.55);
        }
        this.render.m_109322_(entity, WAND, ItemTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, false, pose, buf, light);
        pose.m_85849_();
    }

    protected void renderCycleWand(T entity, PoseStack pose, MultiBufferSource buf, int light, ItemStack stack) {
        int size = 6;
        float pi = 57.295776f;
        int tickCount = ((WindWitchMaster)entity).f_19797_;
        float rotY = (float)tickCount / 90.0f;
        float scale = 1.25f;
        for (int i = 0; i < size; ++i) {
            pose.m_85836_();
            pose.m_85837_(0.0, (double)0.65f, 0.0);
            pose.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
            pose.m_85845_(Vector3f.f_122225_.m_122240_(rotY * pi + (float)(i * (360 / size)) + (float)tickCount * 7.5f));
            pose.m_85841_(scale, scale + 0.25f, scale);
            pose.m_85837_((double)-1.3305f, 0.0, 0.0);
            pose.m_85845_(Vector3f.f_122227_.m_122240_(-45.0f));
            this.render.m_109322_(entity, stack, ItemTransforms.TransformType.FIXED, false, pose, buf, light);
            pose.m_85849_();
        }
        size = 3;
        pose.m_85836_();
        pose.m_85837_(0.0, 1.5, 0.0);
        pose.m_85841_((float)size, (float)size, (float)size);
        float f = (float)tickCount / 10.0f;
        Objects.requireNonNull(this);
        float angle = f * 57.295776f;
        pose.m_85845_(Vector3f.f_122225_.m_122240_(angle));
        pose.m_85837_(-0.5, 0.0, -0.5);
        float rgb = (float)Math.sin((float)tickCount / 10.0f) * 40.0f;
        Block square = SQUARE4;
        RenderUtil.renderBlock(pose, buf, new RenderUtil.RenderColor((72.0f + rgb) / 255.0f, (200.0f + rgb) / 255.0f, (200.0f + rgb) / 255.0f, light, OverlayTexture.f_118083_), square);
        pose.m_85849_();
    }

    @Override
    protected ResourceLocation getTex() {
        return TEX;
    }
}

