/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.render.entity.model;

import com.mojang.math.Vector3f;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import sweetmagic.init.entity.monster.boss.WhiteButler;
import sweetmagic.init.render.entity.model.SMBaseModel;

public class WhiteButlerModel<T extends WhiteButler>
extends SMBaseModel<T> {
    public static final ModelLayerLocation LAYER = WhiteButlerModel.getLayer("sm_butler");
    private final ModelPart legJacketLeft;
    private final ModelPart legJacketRight;
    private final ModelPart armJacketLeft;
    private final ModelPart armJacketRight;
    public final ModelPart head;
    public int tickTime = 0;

    public WhiteButlerModel(ModelPart root) {
        super(root);
        this.head = root.m_171324_("head");
        this.armJacketRight = root.m_171324_("armJacketRight");
        this.armJacketLeft = root.m_171324_("armJacketLeft");
        this.legJacketLeft = root.m_171324_("legJacketLeft");
        this.legJacketRight = root.m_171324_("legJacketRight");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition part = mesh.m_171576_();
        PartDefinition head = part.m_171599_("head", WhiteButlerModel.getCubeList(0, 0).m_171488_(-4.0f, -7.0f, -4.0f, 8.0f, 8.0f, 8.0f, WhiteButlerModel.getCube(-0.5f)), WhiteButlerModel.getPose(0.0f, 0.0f, 0.0f));
        part.m_171599_("body", WhiteButlerModel.getCubeList(16, 16).m_171488_(-3.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, WhiteButlerModel.getCube(0.0f)), WhiteButlerModel.getPose(-1.0f, 0.0f, 0.0f));
        part.m_171599_("jacket", WhiteButlerModel.getCubeList(32, 0).m_171488_(-3.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, WhiteButlerModel.getCube(0.35f)), WhiteButlerModel.getPose(-1.0f, 0.3f, -0.15f));
        part.m_171599_("armLeft", WhiteButlerModel.getCubeList(40, 32).m_171488_(-2.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, WhiteButlerModel.getCube(-0.2f)), WhiteButlerModel.getPose(-5.75f, 1.8f, 0.0f));
        part.m_171599_("armRight", WhiteButlerModel.getCubeList(40, 16).m_171488_(-2.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, WhiteButlerModel.getCube(-0.2f)), WhiteButlerModel.getPose(5.75f, 1.8f, 0.0f));
        part.m_171599_("armJacketLeft", WhiteButlerModel.getCubeList(40, 48).m_171488_(-2.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, WhiteButlerModel.getCube(0.0f)), WhiteButlerModel.getPose(-5.75f, 1.95f, 0.0f));
        part.m_171599_("armJacketRight", WhiteButlerModel.getCubeList(40, 48).m_171488_(-2.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, WhiteButlerModel.getCube(0.0f)), WhiteButlerModel.getPose(5.75f, 1.95f, 0.0f));
        part.m_171599_("legLeft", WhiteButlerModel.getCubeList(0, 32).m_171488_(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, WhiteButlerModel.getCube(-0.075f)), WhiteButlerModel.getPose(1.0f, 13.95f, 0.0f));
        part.m_171599_("legRight", WhiteButlerModel.getCubeList(0, 16).m_171488_(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, WhiteButlerModel.getCube(-0.075f)), WhiteButlerModel.getPose(-3.0f, 13.95f, 0.0f));
        part.m_171599_("legJacketLeft", WhiteButlerModel.getCubeList(24, 48).m_171488_(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, WhiteButlerModel.getCube(0.1f)), WhiteButlerModel.getPose(1.0f, 14.0f, 0.0f));
        part.m_171599_("legJacketRight", WhiteButlerModel.getCubeList(24, 48).m_171488_(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, WhiteButlerModel.getCube(0.1f)), WhiteButlerModel.getPose(-3.0f, 14.0f, 0.0f));
        part.m_171599_("skirt", WhiteButlerModel.getCubeList(16, 32).m_171488_(-3.0f, 0.0f, -2.0f, 8.0f, 8.0f, 4.0f, WhiteButlerModel.getCube(0.35f)), WhiteButlerModel.getPose(-1.0f, 13.0f, -0.15f));
        head.m_171599_("headdress", WhiteButlerModel.getCubeList(0, 48).m_171488_(-3.0f, 0.0f, 0.0f, 10.0f, 3.0f, 0.0f, WhiteButlerModel.getCube(0.0f)), WhiteButlerModel.getPose(-2.0f, -8.5f, -3.0f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)64, (int)64);
    }

    @Override
    public void setupAnim(T entity, float swing, float swingAmount, float ageTick, float headYaw, float headPitch) {
        this.animHead(headYaw, headPitch);
        Vector3f vec = new Vector3f(Mth.m_14089_((float)(swing * 0.662f * 0.85f / entity.m_6134_())) * swingAmount, 0.0f, 0.0f);
        this.swingArms(entity, vec);
        this.swingLegs(vec);
        this.swingBody(vec);
    }

    @Override
    public void swingLegs(Vector3f vec) {
        super.swingLegs(vec);
        Vector3f base = vec.m_122281_();
        base.m_122261_(1.134464f);
        Vector3f mirror = base.m_122281_();
        mirror.m_122261_(-1.0f);
        this.legJacketRight.m_233569_();
        this.legJacketLeft.m_233569_();
        this.legJacketRight.m_233567_(base);
        this.legJacketLeft.m_233567_(mirror);
    }

    public void swingArms(T entity, Vector3f vec) {
        super.swingArms(vec);
        this.armLeft.f_233553_ *= 0.8f;
        this.armLeft.f_233555_ *= 0.8f;
        this.armLeft.f_104200_ = -5.5f;
        this.armJacketLeft.f_233553_ *= 0.8f;
        this.armJacketLeft.f_233555_ *= 0.8f;
        this.armJacketLeft.f_104200_ = -5.5f;
        this.armRight.f_233553_ *= 0.8f;
        this.armRight.f_233555_ *= 0.8f;
        this.armRight.f_104200_ = 5.5f;
        this.armJacketRight.f_233553_ *= 0.8f;
        this.armJacketRight.f_233555_ *= 0.8f;
        this.armJacketRight.f_104200_ = 5.5f;
        if (((WhiteButler)entity).getRifle()) {
            this.armRight.f_104203_ = -1.55f;
            this.armJacketRight.f_104203_ = -1.55f;
            this.armRight.f_104204_ = 0.15f;
            this.armJacketRight.f_104204_ = 0.15f;
            this.armLeft.f_104203_ = -1.55f;
            this.armJacketLeft.f_104203_ = -1.55f;
            this.armLeft.f_104200_ = -3.5f;
            this.armJacketLeft.f_104200_ = -3.5f;
            this.armLeft.f_104202_ = -2.0f;
            this.armJacketLeft.f_104202_ = -2.0f;
            this.armLeft.f_104204_ = -0.65f;
            this.armJacketLeft.f_104204_ = -0.65f;
            this.head.f_104204_ = -0.2f;
            this.head.f_104205_ = 0.075f;
            this.head.f_104200_ = -0.5f;
            this.head.f_104201_ = -0.5f;
        }
    }
}

