/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.render.entity.model;

import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import sweetmagic.SweetMagicCore;
import sweetmagic.api.ientity.IGolem;
import sweetmagic.init.render.entity.model.SMBaseModel;

public class WitchGolemModel<T extends LivingEntity>
extends HierarchicalModel<T> {
    public static final ModelLayerLocation LAYER = WitchGolemModel.getLayer("witchgolem");
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart rightArm;
    private final ModelPart leftArm;
    private final ModelPart rightLeg;
    private final ModelPart leftLeg;

    public WitchGolemModel(ModelPart part) {
        this.root = part;
        this.head = part.m_171324_("head");
        this.rightArm = part.m_171324_("right_arm");
        this.leftArm = part.m_171324_("left_arm");
        this.rightLeg = part.m_171324_("right_leg");
        this.leftLeg = part.m_171324_("left_leg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition part = mesh.m_171576_();
        part.m_171599_("head", SMBaseModel.getCubeList(0, 0).m_171481_(-4.0f, -12.0f, -5.5f, 8.0f, 10.0f, 8.0f).m_171514_(24, 0).m_171481_(-1.0f, -5.0f, -7.5f, 2.0f, 4.0f, 2.0f), PartPose.m_171419_((float)0.0f, (float)-7.0f, (float)-2.0f));
        part.m_171599_("body", SMBaseModel.getCubeList(0, 40).m_171481_(-9.0f, -2.0f, -6.0f, 18.0f, 12.0f, 11.0f).m_171514_(0, 70).m_171488_(-4.5f, 10.0f, -3.0f, 9.0f, 5.0f, 6.0f, new CubeDeformation(0.5f)), PartPose.m_171419_((float)0.0f, (float)-7.0f, (float)0.0f));
        part.m_171599_("right_arm", SMBaseModel.getCubeList(60, 21).m_171481_(-13.0f, -2.5f, -3.0f, 4.0f, 30.0f, 6.0f), PartPose.m_171419_((float)0.0f, (float)-7.0f, (float)0.0f));
        part.m_171599_("left_arm", SMBaseModel.getCubeList(60, 58).m_171481_(9.0f, -2.5f, -3.0f, 4.0f, 30.0f, 6.0f), PartPose.m_171419_((float)0.0f, (float)-7.0f, (float)0.0f));
        part.m_171599_("right_leg", SMBaseModel.getCubeList(37, 0).m_171481_(-3.5f, -3.0f, -3.0f, 6.0f, 16.0f, 5.0f), PartPose.m_171419_((float)-4.0f, (float)11.0f, (float)0.0f));
        part.m_171599_("left_leg", SMBaseModel.getCubeList(60, 0).m_171480_().m_171481_(-3.5f, -3.0f, -3.0f, 6.0f, 16.0f, 5.0f), PartPose.m_171419_((float)5.0f, (float)11.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)128, (int)128);
    }

    public ModelPart m_142109_() {
        return this.root;
    }

    public void setupAnim(T entity, float swing, float swingAmount, float ageTick, float headYaw, float headPitch) {
        this.head.f_104204_ = ((IGolem)entity).getShit() ? 0.0f : headYaw * ((float)Math.PI / 180);
        this.head.f_104203_ = ((IGolem)entity).getShit() ? -5.5f : headPitch * ((float)Math.PI / 180);
        this.rightLeg.f_104203_ = -1.5f * Mth.m_14156_((float)swing, (float)13.0f) * swingAmount;
        this.leftLeg.f_104203_ = 1.5f * Mth.m_14156_((float)swing, (float)13.0f) * swingAmount;
        this.rightLeg.f_104204_ = 0.0f;
        this.leftLeg.f_104204_ = 0.0f;
    }

    public void prepareMobModel(T entity, float par1, float par2, float par3) {
        int i = ((IGolem)entity).getAttackTick();
        if (i > 0) {
            this.rightArm.f_104203_ = -2.0f + 1.5f * Mth.m_14156_((float)((float)i - par3), (float)10.0f);
            this.leftArm.f_104203_ = -2.0f + 1.5f * Mth.m_14156_((float)((float)i - par3), (float)10.0f);
        } else {
            this.rightArm.f_104203_ = (-0.2f + 1.5f * Mth.m_14156_((float)par1, (float)13.0f)) * par2;
            this.leftArm.f_104203_ = (-0.2f - 1.5f * Mth.m_14156_((float)par1, (float)13.0f)) * par2;
        }
    }

    public ModelPart getFlowerHoldingArm() {
        return this.rightArm;
    }

    public static ModelLayerLocation getLayer(String name) {
        return new ModelLayerLocation(SweetMagicCore.getSRC(name), "main");
    }
}

