/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.render.entity.projectile;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import sweetmagic.SweetMagicCore;
import sweetmagic.init.entity.projectile.ShootingStar;

public class RenderShootingStar<T extends ShootingStar>
extends EntityRenderer<T> {
    private static final ResourceLocation CRYSTAL = SweetMagicCore.getSRC("textures/entity/shooting_star.png");
    private static final RenderType RENDER_TYPE = RenderType.m_110458_((ResourceLocation)CRYSTAL);
    private static final float SIN_45 = (float)Math.sin(0.7853981633974483);
    private final ModelPart cube;
    private final ModelPart glass;
    private static final ResourceLocation TEX = SweetMagicCore.getSRC("textures/block/empty.png");

    public RenderShootingStar(EntityRendererProvider.Context con) {
        super(con);
        ModelPart model = con.m_174023_(ModelLayers.f_171145_);
        this.glass = model.m_171324_("glass");
        this.cube = model.m_171324_("cube");
    }

    public void render(T entity, float yaw, float part, PoseStack pose, MultiBufferSource buf, int light) {
        pose.m_85836_();
        int tickCount = ((ShootingStar)((Object)entity)).f_19797_;
        float size = 1.5f + Math.min(1.0f, 0.01f * (float)tickCount);
        int overray = OverlayTexture.f_118083_;
        pose.m_85841_(size, size, size);
        pose.m_85837_(0.0, 0.75, 0.0);
        float f1 = (float)tickCount * 3.0f;
        VertexConsumer vert = buf.m_6299_(RENDER_TYPE).m_85950_(0.0f, 0.0f, 0.0f, 1.0f);
        pose.m_85845_(Vector3f.f_122225_.m_122240_(f1));
        pose.m_85837_(0.0, Math.sin((float)tickCount / 20.0f) * 0.2, 0.0);
        pose.m_85845_(new Quaternion(new Vector3f(SIN_45, 0.0f, SIN_45), 60.0f, true));
        this.glass.m_104301_(pose, vert, light, overray);
        pose.m_85841_(0.875f, 0.875f, 0.875f);
        pose.m_85845_(new Quaternion(new Vector3f(SIN_45, 0.0f, SIN_45), 60.0f, true));
        pose.m_85845_(Vector3f.f_122225_.m_122240_(f1));
        this.glass.m_104301_(pose, vert, light, overray);
        pose.m_85841_(0.875f, 0.875f, 0.875f);
        pose.m_85845_(new Quaternion(new Vector3f(SIN_45, 0.0f, SIN_45), 60.0f, true));
        pose.m_85845_(Vector3f.f_122225_.m_122240_(f1));
        pose.m_85841_(0.875f, 0.875f, 0.875f);
        pose.m_85845_(new Quaternion(new Vector3f(SIN_45, 0.0f, SIN_45), 60.0f, true));
        pose.m_85845_(Vector3f.f_122225_.m_122240_(f1));
        this.cube.m_104301_(pose, vert, light, overray);
        pose.m_85849_();
    }

    public ResourceLocation getTextureLocation(T entity) {
        return TEX;
    }
}

