/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.render.entity.projectile;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import sweetmagic.SweetMagicCore;
import sweetmagic.init.ItemInit;
import sweetmagic.init.entity.monster.WitchCrystal;

public class RenderWitchCrystal<T extends WitchCrystal>
extends EntityRenderer<T> {
    private static final ResourceLocation CRYSTAL = SweetMagicCore.getSRC("textures/entity/witch_crystal.png");
    private static final ItemStack STACK = new ItemStack((ItemLike)ItemInit.witch_tears);
    private static final RenderType RENDER_TYPE = RenderType.m_110458_((ResourceLocation)CRYSTAL);
    private static final float SIN_45 = (float)Math.sin(0.7853981633974483);
    private final ModelPart glass;
    private final ItemRenderer render;

    public RenderWitchCrystal(EntityRendererProvider.Context con) {
        super(con);
        this.render = con.m_174025_();
        ModelPart model = con.m_174023_(ModelLayers.f_171145_);
        this.glass = model.m_171324_("glass");
    }

    public ResourceLocation getTextureLocation(T entity) {
        return TextureAtlas.f_118259_;
    }

    public void render(T entity, float parTick, float par2, PoseStack pose, MultiBufferSource buf, int light) {
        int overray = OverlayTexture.f_118083_;
        int tickCount = ((WitchCrystal)entity).f_19797_;
        pose.m_85836_();
        float size = 0.65f;
        pose.m_85837_(0.0, 1.15, 0.0);
        pose.m_85837_(0.0, Math.sin((float)tickCount / 20.0f) * 0.4, 0.0);
        float angle = (float)tickCount / 20.0f * 180.0f / (float)Math.PI;
        pose.m_85845_(Vector3f.f_122225_.m_122240_(angle));
        pose.m_85841_(size, size, size);
        this.render.m_174269_(STACK, ItemTransforms.TransformType.FIXED, light, overray, pose, buf, 0);
        pose.m_85849_();
        pose.m_85836_();
        size = 1.5f;
        pose.m_85841_(size, size, size);
        pose.m_85837_(0.0, 0.75, 0.0);
        float f1 = (float)tickCount * 3.0f;
        VertexConsumer vert = buf.m_6299_(RENDER_TYPE).m_85950_(0.0f, 0.0f, 0.0f, 1.0f);
        pose.m_85845_(Vector3f.f_122225_.m_122240_(f1));
        pose.m_85837_(0.0, Math.sin((float)tickCount / 20.0f) * 0.2, 0.0);
        pose.m_85845_(new Quaternion(new Vector3f(SIN_45, 0.0f, SIN_45), 60.0f, true));
        this.glass.m_104301_(pose, vert, light, overray);
        pose.m_85841_(0.875f, 0.875f, 0.875f);
        pose.m_85845_(new Quaternion(new Vector3f(SIN_45, 0.0f, SIN_45), 60.0f, true));
        pose.m_85845_(Vector3f.f_122225_.m_122240_(f1));
        this.glass.m_104301_(pose, vert, light, overray);
        pose.m_85841_(0.875f, 0.875f, 0.875f);
        pose.m_85845_(new Quaternion(new Vector3f(SIN_45, 0.0f, SIN_45), 60.0f, true));
        pose.m_85845_(Vector3f.f_122225_.m_122240_(f1));
        pose.m_85849_();
    }
}

