/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.tile.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Arrays;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import sweetmagic.SweetMagicCore;
import sweetmagic.init.ItemInit;
import sweetmagic.init.TagInit;
import sweetmagic.init.tile.gui.GuiSMBase;
import sweetmagic.init.tile.gui.util.SMButton;
import sweetmagic.init.tile.gui.util.SMRenderTex;
import sweetmagic.init.tile.menu.AetherHopperMenu;
import sweetmagic.init.tile.sm.TileAetherHopper;

public class GuiAetherHopper
extends GuiSMBase<AetherHopperMenu> {
    private static final ResourceLocation TEX = SweetMagicCore.getSRC("textures/gui/gui_aether_hopper.png");
    private static final ItemStack WAND = new ItemStack((ItemLike)ItemInit.mf_stuff);
    private final TileAetherHopper tile;

    public GuiAetherHopper(AetherHopperMenu menu, Inventory pInv, Component title) {
        super(menu, pInv, title);
        this.setGuiSize(176, 175);
        this.tile = menu.tile;
        this.addButtonMap(0, new SMButton(MISC, 160, -11, 114, 0, 10, 9, new SMButton.SMButtonTip("sort", -18, 14)));
        this.addButtonMap(1, new SMButton(MISC, 148, -11, 137, 0, 11, 9, new SMButton.SMButtonTip("quick_stack", -18, 14)));
        this.addButtonMap(2, new SMButton(MISC, 136, -11, 161, 0, 11, 9, new SMButton.SMButtonTip("restock", -18, 14)));
        this.addRenderTexList(new SMRenderTex(TEX, 7, 10, 0, 0, 11, 77, new SMRenderTex.MFRenderGage(this.tile, true)));
    }

    @Override
    protected void m_7286_(PoseStack pose, float parTick, int mouseX, int mouseY) {
        super.m_7286_(pose, parTick, mouseX, mouseY);
        this.renderStock(this.tile.getInputList(), pose, 1, 2, 0, 0);
        this.renderSlotItem(((AetherHopperMenu)this.menu).wandSlot, WAND, pose, 0);
        ItemStack stack = this.tile.getWandItem();
        CompoundTag tag = stack.m_41783_();
        if (tag == null || !tag.m_128441_("X")) {
            return;
        }
        int x = tag.m_128451_("X");
        int y = tag.m_128451_("Y");
        int z = tag.m_128451_("Z");
        String pos = ": " + x + ", " + y + ", " + z;
        boolean isHopper = this.tile.getState(new BlockPos(x, y, z)).m_204336_(TagInit.AETHER_HOPPER);
        ChatFormatting color = isHopper ? GREEN : RED;
        int tipX = this.getWidth() + 50;
        int tipY = this.getHeight() + 74;
        this.drawFont(pose, (Component)this.getTipArray(new Object[]{this.getText("regi_pos"), pos}).m_130940_(color), 116.0f, tipX, tipY, 2868292, true);
    }

    @Override
    protected void m_7027_(PoseStack pose, int mouseX, int mouseY) {
        super.m_7027_(pose, mouseX, mouseY);
        this.renderItemLabel(((AetherHopperMenu)this.menu).wandSlot, WAND, pose, mouseX, mouseY, Arrays.asList(this.getText("send_stuff_0").m_130940_(GOLD), this.getText("send_stuff_1").m_130940_(GOLD), this.empty(), this.getText("can_stuff").m_130940_(GREEN), WAND.m_41611_()));
    }

    @Override
    public List<Integer> getInvRenderArray() {
        return List.of(Integer.valueOf(7), Integer.valueOf(92), Integer.valueOf(25), Integer.valueOf(10));
    }

    @Override
    public int getInvY() {
        return 3;
    }

    @Override
    public int getInvX() {
        return 8;
    }

    @Override
    protected ResourceLocation getTEX() {
        return TEX;
    }
}

