/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.tile.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import sweetmagic.SweetMagicCore;
import sweetmagic.handler.PacketHandler;
import sweetmagic.init.tile.gui.GuiSMBase;
import sweetmagic.init.tile.gui.util.SMButton;
import sweetmagic.init.tile.gui.util.SMRenderTex;
import sweetmagic.init.tile.menu.AetherLamplightMenu;
import sweetmagic.init.tile.sm.TileAetherLamplight;
import sweetmagic.packet.AetherLampLightPKT;

public class GuiAetherLamplight
extends GuiSMBase<AetherLamplightMenu> {
    private static final ResourceLocation TEX = SweetMagicCore.getSRC("textures/gui/gui_aether_lamp_light.png");
    private final TileAetherLamplight tile;
    private float scrollOffset = 0.0f;
    private int startIndex = 0;
    private boolean scrolling = false;
    private boolean[] enchaView = new boolean[4];
    private int selectId = -1;
    private List<Block> blockList = new ArrayList<Block>();
    private Set<Block> blockSet = new HashSet<Block>();

    public GuiAetherLamplight(AetherLamplightMenu menu, Inventory pInv, Component title) {
        super(menu, pInv, title);
        this.tile = menu.tile;
        this.setGuiSize(183, 174);
        this.addButtonMap(0, new SMButton(TEX, 26, 7, 196, 224, 11, 9));
        this.addButtonMap(1, new SMButton(TEX, 39, 7, 196, 233, 15, 9));
        this.addButtonMap(2, new SMButton(TEX, 26, 19, 226, 224, 11, 9));
        this.addButtonMap(3, new SMButton(TEX, 39, 19, 226, 233, 15, 9));
        this.addButtonMap(4, new SMButton(TEX, 18, 55, 196, 224, 11, 9));
        this.addButtonMap(5, new SMButton(TEX, 51, 55, 226, 224, 11, 9));
        this.addButtonMap(6, new SMButton(TEX, 18, 70, 196, 210, 14, 14));
        this.addButtonMap(7, new SMButton(TEX, 34, 70, 196, 242, 28, 14));
        this.addRenderTexList(new SMRenderTex(TEX, 5, 7, 0, 0, 11, 77, new SMRenderTex.MFRenderGage(menu.tile, true)));
        this.blockSet = this.tile.getRangeBlockSet();
        this.blockList = this.tile.getRangeBlockList();
    }

    @Override
    protected void m_7286_(PoseStack pose, float parTick, int mouseX, int mouseY) {
        super.m_7286_(pose, parTick, mouseX, mouseY);
        int x = this.getWidth();
        int y = this.getHeight();
        if (!this.blockSet.isEmpty()) {
            int i;
            int id;
            int size = this.blockSet.size();
            int maxItemList = Math.min(4, size);
            List blockSetList = this.blockSet.stream().toList();
            TileAetherLamplight.BlockOrder order = this.tile.blockOrder;
            int h = (int)(60.0f * this.scrollOffset);
            boolean isActive = this.scrollbarActive();
            RenderSystem.m_157456_((int)0, (ResourceLocation)MISC);
            this.m_93228_(pose, x + 167, y + 9 + h, 83 + (isActive ? 0 : 8), 93, 8, 15);
            for (id = 0; id < 4; ++id) {
                this.m_93228_(pose, x + 64, y + 7 + id * 20, 99, 93, 101, 20);
            }
            for (i = 0; i < maxItemList; ++i) {
                this.m_93228_(pose, x + 64, y + 7 + i * 20, 99, 113 + (this.enchaView[i] ? 20 : 0), 101, 20);
            }
            for (i = 0; i < maxItemList && i + this.startIndex < size; ++i) {
                if (i + this.startIndex != this.selectId) continue;
                this.m_93228_(pose, x + 64, y + 7 + i * 20, 99, 153, 101, 20);
            }
            for (id = 0; id < maxItemList && id + this.startIndex < size; ++id) {
                pose.m_85836_();
                Block block = (Block)blockSetList.get(id + this.startIndex);
                ItemStack stack = new ItemStack((ItemLike)block);
                this.f_96542_.m_115218_(stack, x + 67, y + 8 + id * 20);
                MutableComponent tip = this.getLabel("\u00d7" + Collections.frequency(this.blockList, block));
                int orderNumber = order.getBlockOrder(block);
                ChatFormatting color = orderNumber == -1 ? RED : WHITE;
                this.f_96547_.m_92763_(pose, (Component)this.getTipArray(new Object[]{this.getText("order"), this.getLabel(" " + orderNumber, color)}).m_130940_(GOLD), (float)(x + 100), (float)(y + 13 + id * 20), 0xEEEEEE);
                pose.m_85837_(0.0, 0.0, 200.0);
                this.f_96547_.m_92763_(pose, (Component)tip, (float)(x + 80), (float)(y + 16 + id * 20), 0xEEEEEE);
                pose.m_85849_();
            }
        }
        this.f_96547_.m_92763_(pose, (Component)this.getLabel(this.tile.range), (float)(x + 35), (float)(y + 34), 2868292);
        if (this.selectId != -1 && !this.blockSet.isEmpty()) {
            this.f_96547_.m_92763_(pose, (Component)this.getLabel(this.tile.order), (float)(x + 35), (float)(y + 56), 2868292);
            this.f_96547_.m_92763_(pose, (Component)this.getText("decision"), (float)(x + 39), (float)(y + 73), 2868292);
        }
    }

    @Override
    protected void m_7027_(PoseStack pose, int mouseX, int mouseY) {
        super.m_7027_(pose, mouseX, mouseY);
        int tipX = this.getWidth() + 18;
        int tipY = this.getHeight() + 62;
        if (this.isRender(tipX, tipY, mouseX, mouseY, 14, 14)) {
            int xAxis = mouseX - this.getWidth();
            int yAxis = mouseY - this.getHeight();
            this.m_96602_(pose, (Component)this.getTipArray(new Object[]{this.getText("isrange"), this.getLabel(this.tile.isRangeView), GOLD}), xAxis, yAxis);
        }
        if (this.blockSet.isEmpty()) {
            return;
        }
        tipX = this.getWidth() + 64;
        tipY = this.getHeight() + 6;
        int size = this.blockSet.size();
        int maxItemList = Math.min(4, size);
        List blockSetList = this.blockSet.stream().toList();
        for (int id = 0; id < maxItemList && id + this.startIndex < size; ++id) {
            this.enchaView[id] = false;
            if (this.isRender(tipX, tipY, mouseX, mouseY, 98, 19)) {
                int xAxis = mouseX - this.getWidth();
                int yAxis = mouseY - this.getHeight();
                this.m_6057_(pose, new ItemStack((ItemLike)blockSetList.get(id + this.startIndex)), xAxis, yAxis);
                this.enchaView[id] = true;
            }
            tipY += 20;
        }
    }

    @Override
    public void clickSMButton(int id) {
        super.clickSMButton(id);
        if (id == 7) {
            this.blockSet = this.tile.getRangeBlockSet();
            this.blockList = this.tile.getRangeBlockList();
            this.selectId = -1;
            PacketHandler.sendToServer(new AetherLampLightPKT(this.selectId, this.tile.m_58899_(), false));
        }
    }

    @Override
    public boolean m_6375_(double guiX, double guiY, int mouseButton) {
        this.scrolling = false;
        int x = this.getWidth();
        int y = this.getHeight();
        double dX = guiX - (double)x - 64.0;
        int maxItemList = Math.min(4, this.blockSet.size());
        for (int id = 0; id < maxItemList; ++id) {
            double dY = guiY - (double)y - 6.0 - (double)(id * 20);
            if (!(dX >= 0.0) || !(dX <= 98.0) || !(dY >= 0.0) || !(dY < 20.0)) continue;
            this.selectId = this.selectId == id + this.startIndex ? -1 : id + this.startIndex;
            PacketHandler.sendToServer(new AetherLampLightPKT(this.selectId, this.tile.m_58899_(), true));
        }
        dX = guiX - (double)x - 23.0;
        int w = 8;
        int h = 14;
        int aX = this.f_97735_ + 167;
        int aY = (int)((float)(this.f_97736_ + 9) + this.scrollOffset * 60.0f);
        if (guiX >= (double)aX && guiX < (double)(aX + w) && guiY >= (double)aY && guiY < (double)(aY + h)) {
            this.scrolling = true;
        }
        return super.m_6375_(guiX, guiY, mouseButton);
    }

    public boolean m_7979_(double mouseX, double mouseY, int mouseButton, double dragX, double dragY) {
        int size = this.blockSet.size();
        if (!this.scrolling || !this.scrollbarActive()) {
            return super.m_7979_(mouseX, mouseY, mouseButton, dragX, dragY);
        }
        int i = this.f_97736_ + 16;
        int j = i + 73;
        int offscreenRows = size - 4;
        this.scrollOffset = ((float)mouseY - (float)i + 5.0f) / ((float)(j - i) - 15.0f);
        this.scrollOffset = Mth.m_14036_((float)this.scrollOffset, (float)0.0f, (float)1.0f);
        this.startIndex = (int)((double)(this.scrollOffset * (float)offscreenRows) + 0.5);
        return true;
    }

    public boolean m_6050_(double mouseX, double mouseY, double scrollDelta) {
        if (!this.scrollbarActive()) {
            return super.m_6050_(mouseX, mouseY, scrollDelta);
        }
        int size = this.blockSet.size();
        int offscreenRows = size - 4;
        this.scrollOffset = (float)((double)this.scrollOffset - scrollDelta / (double)offscreenRows);
        this.scrollOffset = Mth.m_14036_((float)this.scrollOffset, (float)0.0f, (float)1.0f);
        this.startIndex = (int)((double)(this.scrollOffset * (float)offscreenRows) + 0.5);
        return true;
    }

    private boolean scrollbarActive() {
        return this.blockSet.size() > 4;
    }

    @Override
    protected ResourceLocation getTEX() {
        return TEX;
    }
}

