/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.tile.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Arrays;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import sweetmagic.SweetMagicCore;
import sweetmagic.init.tile.gui.GuiSMBase;
import sweetmagic.init.tile.gui.util.SMRenderTex;
import sweetmagic.init.tile.menu.AetherReverseMenu;
import sweetmagic.init.tile.sm.TileAetherReverse;

public class GuiAetherReverse
extends GuiSMBase<AetherReverseMenu> {
    private static final ResourceLocation TEX = SweetMagicCore.getSRC("textures/gui/gui_aether_reverse.png");
    public final TileAetherReverse tile;
    private boolean caraftView = false;

    public GuiAetherReverse(AetherReverseMenu menu, Inventory pInv, Component title) {
        super(menu, pInv, title);
        this.tile = menu.tile;
        this.setGuiSize(176, 230);
        this.addRenderTexList(new SMRenderTex(TEX, 7, 7, 0, 0, 11, 77, new SMRenderTex.MFRenderGage(this.tile, true)));
    }

    @Override
    protected void renderBGBase(PoseStack pose, float parTick, int mouseX, int mouseY) {
        super.renderBGBase(pose, parTick, mouseX, mouseY);
        RenderSystem.m_157456_((int)0, (ResourceLocation)MISC);
        this.m_93228_(pose, this.getWidth() + 29, this.getHeight() + 51, 20, 0, 32, 14);
    }

    @Override
    protected void m_7286_(PoseStack pose, float parTick, int mouseX, int mouseY) {
        List<ItemStack> stackList;
        super.m_7286_(pose, parTick, mouseX, mouseY);
        int x = this.getWidth();
        int y = this.getHeight();
        if (this.tile.isCraft) {
            int progress = this.tile.getCraftProgress(22);
            this.m_93228_(pose, x + 116, y + 64, 198, 62, 15, progress);
        }
        RenderSystem.m_157456_((int)0, (ResourceLocation)MISC);
        if (this.tile.canCraft) {
            this.m_93228_(pose, x + 29, y + 51, 20, 16 + (this.caraftView ? 16 : 0), 32, 14);
        }
        if ((stackList = this.tile.craftList).isEmpty()) {
            return;
        }
        for (int i = 0; i < stackList.size(); ++i) {
            this.renderSlotItem(((AetherReverseMenu)this.menu).craftSlot[i], stackList.get(i), pose, 0);
        }
    }

    @Override
    protected void m_7027_(PoseStack pose, int mouseX, int mouseY) {
        List<ItemStack> stackList;
        super.m_7027_(pose, mouseX, mouseY);
        int tipX = this.getWidth() + 29;
        int tipY = this.getHeight() + 51;
        this.caraftView = false;
        if (this.isRender(tipX, tipY, mouseX, mouseY, 31, 11)) {
            this.caraftView = true;
            int xAxis = mouseX - this.getWidth();
            int yAxis = mouseY - this.getHeight();
            if (!this.tile.craftList.isEmpty()) {
                List<Component> tipList = Arrays.asList(this.getText("reverse_start").m_130940_(GREEN), this.getTipArray(new Object[]{this.getText("needmf"), this.format(this.tile.getReverseCost())}).m_130940_(GOLD));
                this.m_96597_(pose, tipList, xAxis, yAxis);
            } else {
                this.m_96602_(pose, (Component)this.getText("no_reverse").m_130940_(GOLD), xAxis, yAxis);
            }
        }
        if ((stackList = this.tile.craftList).isEmpty()) {
            return;
        }
        for (int i = 0; i < stackList.size(); ++i) {
            this.renderItemLabel(((AetherReverseMenu)this.menu).craftSlot[i], stackList.get(i), pose, mouseX, mouseY, Arrays.asList(this.getText("reverse_craft").m_130940_(GREEN), stackList.get(i).m_41611_()));
        }
    }

    @Override
    public boolean m_6375_(double guiX, double guiY, int mouseButton) {
        double dX = guiX - (double)(this.getWidth() + 29);
        double dY = guiY - (double)(this.getHeight() + 51);
        if (dX >= 0.0 && dX <= 31.0 && dY >= 0.0 && dY < 11.0) {
            this.clickButton(0);
        }
        return super.m_6375_(guiX, guiY, mouseButton);
    }

    @Override
    protected ResourceLocation getTEX() {
        return TEX;
    }
}

