/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.tile.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Arrays;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import sweetmagic.SweetMagicCore;
import sweetmagic.init.tile.gui.GuiSMBase;
import sweetmagic.init.tile.gui.util.SMButton;
import sweetmagic.init.tile.menu.AlstroemeriaAquariumRecipeMenu;
import sweetmagic.init.tile.sm.TileAlstroemeriaAquarium;
import sweetmagic.recipe.alstrameria.AlstroemeriaRecipe;

public class GuiAlstroemeriaAquariumRecipe
extends GuiSMBase<AlstroemeriaAquariumRecipeMenu> {
    private static final ResourceLocation TEX = SweetMagicCore.getSRC("textures/gui/gui_dungeon_compas.png");
    private boolean[] lootView = new boolean[4];
    private float scrollOffset = 0.0f;
    private int startIndex = 0;
    private boolean scrolling = false;
    private int selectID = -1;
    private final TileAlstroemeriaAquarium tile;
    private final List<AlstroemeriaRecipe> alstroemeriaRecipeList;
    private int tickTime = 0;

    public GuiAlstroemeriaAquariumRecipe(AlstroemeriaAquariumRecipeMenu menu, Inventory pInv, Component title) {
        super(menu, pInv, title);
        this.setGuiSize(126, 111);
        this.tile = menu.tile;
        this.selectID = this.tile.selectId;
        this.alstroemeriaRecipeList = this.tile.getAlstroemeriaRecipeList();
        this.addButtonMap(0, new SMButton(TEX, 25, 91, 127, 20, 29, 12));
        this.addButtonMap(1, new SMButton(TEX, 58, 91, 127, 20, 29, 12));
    }

    @Override
    protected void m_7286_(PoseStack pose, float parTick, int mouseX, int mouseY) {
        int id;
        super.m_7286_(pose, parTick, mouseX, mouseY);
        int x = this.getWidth();
        int y = this.getHeight();
        RenderSystem.m_157456_((int)0, (ResourceLocation)MISC);
        int h = (int)(60.0f * this.scrollOffset);
        this.m_93228_(pose, x + 110, y + 9 + h, 83, 93, 8, 15);
        int size = this.alstroemeriaRecipeList.size();
        for (id = 0; id < 4; ++id) {
            this.m_93228_(pose, x + 7, y + 7 + id * 20, 99, 93, 101, 20);
            if (id + this.startIndex >= size) break;
            this.m_93228_(pose, x + 7, y + 7 + id * 20, 99, 113 + (this.lootView[id] ? 20 : 0), 101, 20);
            this.m_93228_(pose, x + 24, y + 12 + id * 20, 99, 175, 13, 11);
            if (id + this.startIndex != this.selectID) continue;
            this.m_93228_(pose, x + 7, y + 7 + id * 20, 99, 153, 101, 20);
        }
        this.f_96547_.m_92763_(pose, (Component)this.getText("decision"), (float)(x + 30), (float)(y + 93), 0xFFFFFF);
        this.f_96547_.m_92763_(pose, (Component)this.getText("cancel"), (float)(x + 63), (float)(y + 93), 0xFFFFFF);
        ++this.tickTime;
        for (id = 0; id < 4 && id + this.startIndex < size; ++id) {
            int pX = x + 8;
            int pY = y + 10 + id * 20;
            ItemStack stack = this.alstroemeriaRecipeList.get(id + this.startIndex).m_8043_();
            this.renderItem(pose, pX, pY, stack);
            AlstroemeriaRecipe recipe = this.alstroemeriaRecipeList.get(id + this.startIndex);
            List<Integer> countList = recipe.getCountList();
            List<Ingredient> ingList = recipe.getIngredList();
            int ingSize = Math.min(4, ingList.size());
            for (int i = 0; i < ingSize; ++i) {
                this.renderItem(pose, pX + 29 + i * 17, pY, ingList.get(i).m_43908_(), countList.get(i));
            }
        }
    }

    public void renderItem(PoseStack pose, int x, int y, ItemStack[] stackArray, int count) {
        ItemStack stack = stackArray[this.tickTime / 80 % stackArray.length].m_41777_();
        stack.m_41764_(count);
        this.renderItem(pose, x, y, stack);
    }

    public void renderItem(PoseStack pose, int x, int y, ItemStack stack) {
        this.f_96542_.m_115218_(stack, x, y);
        this.f_96542_.m_115174_(this.f_96547_, stack, x, y, null);
    }

    @Override
    protected void m_7027_(PoseStack pose, int mouseX, int mouseY) {
        super.m_7027_(pose, mouseX, mouseY);
        int tipX = this.getWidth() + 7;
        int tipY = this.getHeight() + 7;
        int xAxis = mouseX - this.getWidth();
        int yAxis = mouseY - this.getHeight();
        for (int id = 0; id < 4; ++id) {
            this.lootView[id] = false;
            if (this.isRender(tipX, tipY, mouseX, mouseY, 98, 19)) {
                if (id + this.startIndex >= this.alstroemeriaRecipeList.size()) break;
                AlstroemeriaRecipe recipe = this.alstroemeriaRecipeList.get(id + this.startIndex);
                List<Ingredient> ingList = recipe.getIngredList();
                List<Integer> countList = recipe.getCountList();
                MutableComponent tip0 = this.getLabel(recipe.m_8043_().m_41786_().getString(), WHITE);
                MutableComponent tip1 = this.getTipArray(new Object[]{this.getText("craft_item").m_130940_(GREEN), ": ", tip0});
                MutableComponent tip2 = this.getTipArray(new Object[]{this.getText("request_item").m_130940_(GOLD), ":"});
                List<Component> comList = Arrays.asList(tip1, tip2);
                this.m_96597_(pose, comList, xAxis, yAxis);
                this.lootView[id] = true;
                int spSize2 = this.f_96547_.m_92895_(tip2.getString());
                this.f_96542_.f_115093_ = (float)((double)this.f_96542_.f_115093_ + 400.0);
                int count = 0;
                for (int i = 0; i < ingList.size(); ++i) {
                    Ingredient ing = ingList.get(i);
                    ItemStack stack = ing.m_43908_()[this.tickTime / 80 % ing.m_43908_().length].m_41777_();
                    stack.m_41764_(countList.get(i).intValue());
                    this.renderItem(pose, xAxis + 13 + count++ * 17 + spSize2, yAxis - 4, stack);
                }
                this.f_96542_.f_115093_ = (float)((double)this.f_96542_.f_115093_ - 400.0);
            }
            tipY += 20;
        }
    }

    @Override
    public boolean m_6375_(double guiX, double guiY, int mouseButton) {
        int aX = this.f_97735_ + 110;
        int aY = (int)((float)(this.f_97736_ + 9) + this.scrollOffset * 60.0f);
        int w = 8;
        int h = 14;
        this.scrolling = guiX >= (double)aX && guiX < (double)(aX + w) && guiY >= (double)aY && guiY < (double)(aY + h);
        aX = this.f_97735_ + 25;
        aY = this.f_97736_ + 91;
        w = 29;
        h = 12;
        if (guiX >= (double)aX && guiX < (double)(aX + w) && guiY >= (double)aY && guiY < (double)(aY + h)) {
            this.clickButton(this.selectID == -1 ? -1 : 1 + this.selectID);
            return super.m_6375_(guiX, guiY, mouseButton);
        }
        aX = this.f_97735_ + 58;
        if (guiX >= (double)aX && guiX < (double)(aX + w) && guiY >= (double)aY && guiY < (double)(aY + h)) {
            this.clickButton(0);
            return super.m_6375_(guiX, guiY, mouseButton);
        }
        int x = this.getWidth();
        int y = this.getHeight();
        double dX = guiX - (double)(x + 7);
        for (int id = 0; id < 4; ++id) {
            double dY = guiY - (double)(y + 7 + 20 * id);
            if (!(dX >= 0.0) || !(dX <= 98.0) || !(dY >= 0.0) || !(dY < 20.0)) continue;
            int newSelectID = id + this.startIndex;
            this.selectID = newSelectID != this.selectID ? newSelectID : -1;
            this.player.f_19853_.m_5594_(null, this.player.m_20183_(), SoundEvents.f_12490_, SoundSource.PLAYERS, 0.25f, 1.0f);
        }
        return super.m_6375_(guiX, guiY, mouseButton);
    }

    public boolean m_7979_(double mouseX, double mouseY, int mouseButton, double dragX, double dragY) {
        int size = this.alstroemeriaRecipeList.size();
        if (!this.scrolling) {
            return super.m_7979_(mouseX, mouseY, mouseButton, dragX, dragY);
        }
        int i = this.f_97736_ + 20;
        int j = i + 73;
        int offscreenRows = size - 4;
        this.scrollOffset = ((float)mouseY - (float)i + 5.0f) / ((float)(j - i) - 15.0f);
        this.scrollOffset = Mth.m_14036_((float)this.scrollOffset, (float)0.0f, (float)1.0f);
        this.startIndex = (int)((double)(this.scrollOffset * (float)offscreenRows) + 0.5);
        return true;
    }

    public boolean m_6050_(double mouseX, double mouseY, double scrollDelta) {
        int size = this.alstroemeriaRecipeList.size();
        int offscreenRows = size - 4;
        this.scrollOffset = (float)((double)this.scrollOffset - scrollDelta / (double)offscreenRows);
        this.scrollOffset = Mth.m_14036_((float)this.scrollOffset, (float)0.0f, (float)1.0f);
        this.startIndex = (int)((double)(this.scrollOffset * (float)offscreenRows) + 0.5);
        return true;
    }

    @Override
    protected ResourceLocation getTEX() {
        return TEX;
    }
}

