/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.tile.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;
import sweetmagic.SweetMagicCore;
import sweetmagic.init.tile.gui.GuiSMBase;
import sweetmagic.init.tile.menu.AlternativeTankMenu;
import sweetmagic.init.tile.sm.TileAlternativeTank;

public class GuiAlternativeTank
extends GuiSMBase<AlternativeTankMenu> {
    private static final ResourceLocation TEX = SweetMagicCore.getSRC("textures/gui/gui_alternative_tank.png");
    private static final ResourceLocation SRC = SweetMagicCore.getSRC("block/water_still");
    private final TileAlternativeTank tile;

    public GuiAlternativeTank(AlternativeTankMenu menu, Inventory pInv, Component title) {
        super(menu, pInv, title);
        this.tile = menu.tile;
        this.setGuiSize(176, 178);
    }

    @Override
    protected void m_7286_(PoseStack pose, float parTick, int mouseX, int mouseY) {
        super.m_7286_(pose, parTick, mouseX, mouseY);
        int x = this.getWidth() + 13;
        int y = this.getHeight() + 14;
        int progress = (int)this.tile.getFluidProgressScaled(75.0f);
        if (progress > 0) {
            int height = 72;
            int width = 9;
            FluidStack fluid = this.tile.getContent();
            IClientFluidTypeExtensions ext = IClientFluidTypeExtensions.of((FluidType)fluid.getFluid().getFluidType());
            ResourceLocation src = ext.getStillTexture(fluid);
            TextureAtlasSprite tex = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(fluid.getFluid().m_6212_((Fluid)Fluids.f_76193_) ? SRC : src);
            int y1 = y + (height - progress);
            RenderSystem.m_157456_((int)0, (ResourceLocation)InventoryMenu.f_39692_);
            Matrix4f mat = pose.m_85850_().m_85861_();
            int hc = progress / 16;
            int hr = progress - hc * 16;
            if (hc > 0) {
                for (int h = 0; h < hc; ++h) {
                    int y2 = y1 + hr + h * 16;
                    this.drawFluid(mat, x, y2, width, 16, tex, 0);
                }
            }
            if (hr > 0) {
                this.drawFluid(mat, x, y1, width, hr, tex, 16 - hr);
            }
            RenderSystem.m_157427_(GameRenderer::m_172814_);
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.getTEX());
            this.m_93228_(pose, x - 1, y - 4, 179, 0, 11, 77);
        }
    }

    @Override
    protected void m_7027_(PoseStack pose, int mouseX, int mouseY) {
        super.m_7027_(pose, mouseX, mouseY);
        int tipX = this.getWidth() + 13;
        int tipY = this.getHeight() + 10;
        if (this.isRender(tipX, tipY, mouseX, mouseY, 11, 76)) {
            float fluid = (float)this.tile.getFluidValue() * 0.001f;
            float maxFluid = (float)this.tile.getMaxFuildValue() * 0.001f;
            String par = " (" + this.tile.getFluidPercent() + ")";
            int xAxis = mouseX - this.getWidth();
            int yAxis = mouseY - this.getHeight();
            String tip = String.format("%,.1f", Float.valueOf(fluid)) + "B / " + String.format("%,.1f", Float.valueOf(maxFluid)) + "B" + par;
            this.m_96602_(pose, (Component)this.getLabel(tip), xAxis, yAxis);
        }
    }

    @Override
    protected ResourceLocation getTEX() {
        return TEX;
    }
}

