/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.tile.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import sweetmagic.SweetMagicCore;
import sweetmagic.init.BlockInit;
import sweetmagic.init.tile.gui.GuiSMBase;
import sweetmagic.init.tile.menu.CardboardStorageMenu;
import sweetmagic.init.tile.slot.MagiaSlot;
import sweetmagic.init.tile.sm.TileCardboardStorage;

public class GuiCardboardStorage
extends GuiSMBase<CardboardStorageMenu> {
    private static final ResourceLocation TEX = SweetMagicCore.getSRC("textures/gui/gui_moden_rack.png");
    public final TileCardboardStorage tile;
    private static final ItemStack STORAGE = new ItemStack((ItemLike)BlockInit.cardboard_storage);

    public GuiCardboardStorage(CardboardStorageMenu menu, Inventory pInv, Component title) {
        super(menu, pInv, title);
        this.setGuiSize(173, 132);
        this.tile = menu.tile;
    }

    @Override
    protected void m_7286_(PoseStack pose, float parTick, int mouseX, int mouseY) {
        super.m_7286_(pose, parTick, mouseX, mouseY);
        this.m_93228_(pose, this.getWidth() + 78, this.getHeight() + 9, 173, 0, 18, 18);
        this.m_93228_(pose, this.getWidth() + 148, this.getHeight() + 29, 173, 0, 18, 18);
        this.renderSlotItem(((CardboardStorageMenu)this.menu).storageSlot, STORAGE, pose, 0);
    }

    @Override
    protected void m_7027_(PoseStack pose, int mouseX, int mouseY) {
        super.m_7027_(pose, mouseX, mouseY);
        this.renderItemLabel(((CardboardStorageMenu)this.menu).storageSlot, STORAGE, pose, mouseX, mouseY);
    }

    @Override
    public void m_6305_(PoseStack pose, int mouseX, int mouseY, float parTick) {
        this.renderMagiaStack(pose, mouseX, mouseY, parTick, ((CardboardStorageMenu)this.menu).slotList, (NonNullList<Slot>)((CardboardStorageMenu)this.menu).f_38839_);
    }

    protected void m_6057_(PoseStack pose, ItemStack stack, int x, int y) {
        this.renderMagiaStackTooltip(pose, stack, x, y, ((CardboardStorageMenu)this.menu).slotList);
    }

    @Override
    protected void renderMagiaStackTooltip(PoseStack pose, ItemStack stack, int x, int y, NonNullList<Slot> slotList) {
        List tipList = this.m_96555_(stack);
        Slot slot = this.f_97734_;
        if (slot instanceof MagiaSlot) {
            MagiaSlot slot2 = (MagiaSlot)slot;
            int vCount = (Integer)this.stackCountMap.get((Object)slot2);
            if (vCount <= 0) {
                return;
            }
            int vMax = this.tile.getMaxStackSize((Integer)this.stackCountMap.get(slotList.get(1)));
            String count = this.format(vCount) + "/";
            String max = this.format(vMax);
            String par = " (" + this.format((float)vCount / (float)vMax * 100.0f) + "%)";
            tipList.add(this.getLabel(count + max + par, GOLD));
        }
        this.m_169388_(pose, tipList, stack.m_150921_(), x, y);
    }

    @Override
    public void setTip(List<Component> tipList, ItemStack stack) {
        tipList.addAll(Arrays.asList(this.getText("slot_need").m_130940_(GREEN), stack.m_41611_()));
        tipList.add((Component)this.getText("max_stackup").m_130940_(GOLD));
    }

    @Override
    protected ResourceLocation getTEX() {
        return TEX;
    }
}

