/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.tile.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import sweetmagic.SweetMagicCore;
import sweetmagic.handler.PacketHandler;
import sweetmagic.init.StructureInit;
import sweetmagic.init.tile.gui.GuiSMBase;
import sweetmagic.init.tile.gui.util.SMButton;
import sweetmagic.init.tile.menu.CompasMenu;
import sweetmagic.packet.CompasPKT;

public class GuiCompas
extends GuiSMBase<CompasMenu> {
    private static final ResourceLocation TEX = SweetMagicCore.getSRC("textures/gui/gui_dungeon_compas.png");
    private boolean[] lootView = new boolean[4];
    private float scrollOffset = 0.0f;
    private int startIndex = 0;
    private boolean scrolling = false;
    private int selectID = -1;

    public GuiCompas(CompasMenu menu, Inventory pInv, Component title) {
        super(menu, pInv, title);
        this.setGuiSize(126, 111);
        CompoundTag tags = this.player.m_21205_().m_41784_();
        if (tags.m_128441_("selectId")) {
            this.selectID = tags.m_128451_("selectId");
        }
        int size = StructureInit.strucMap.size();
        int offscreenRows = size - 4;
        this.scrollOffset = (float)Math.min(this.selectID + 2, size) / (float)size;
        this.scrollOffset = (float)Math.min(this.selectID + (int)(this.scrollOffset * 3.0f), size) / (float)size;
        this.startIndex = (int)((double)(this.scrollOffset * (float)offscreenRows) + 0.5);
        this.addButtonMap(0, new SMButton(TEX, 25, 91, 127, 20, 29, 12));
        this.addButtonMap(1, new SMButton(TEX, 58, 91, 127, 20, 29, 12));
    }

    @Override
    protected void m_7286_(PoseStack pose, float parTick, int mouseX, int mouseY) {
        int id;
        super.m_7286_(pose, parTick, mouseX, mouseY);
        int x = this.getWidth();
        int y = this.getHeight();
        RenderSystem.m_157456_((int)0, (ResourceLocation)MISC);
        int h = (int)(60.0f * this.scrollOffset);
        this.m_93228_(pose, x + 110, y + 9 + h, 83, 93, 8, 15);
        int size = StructureInit.strucMap.size();
        for (id = 0; id < 4; ++id) {
            this.m_93228_(pose, x + 7, y + 7 + id * 20, 99, 93, 101, 20);
            if (id + this.startIndex >= size) break;
            this.m_93228_(pose, x + 7, y + 7 + id * 20, 99, 113 + (this.lootView[id] ? 20 : 0), 101, 20);
            if (id + this.startIndex != this.selectID) continue;
            this.m_93228_(pose, x + 7, y + 7 + id * 20, 99, 153, 101, 20);
        }
        this.f_96547_.m_92763_(pose, (Component)this.getText("decision"), (float)(x + 30), (float)(y + 93), 0xFFFFFF);
        this.f_96547_.m_92763_(pose, (Component)this.getText("cancel"), (float)(x + 63), (float)(y + 93), 0xFFFFFF);
        for (id = 0; id < 4 && id + this.startIndex < size; ++id) {
            String name = StructureInit.strucMap.get(id + this.startIndex).name();
            this.f_96547_.m_92763_(pose, (Component)this.getTip("structure.sweetmagic." + name), (float)(x + 17), (float)(y + 12 + id * 20), 2868292);
        }
    }

    @Override
    protected void m_7027_(PoseStack pose, int mouseX, int mouseY) {
        super.m_7027_(pose, mouseX, mouseY);
        int tipX = this.getWidth() + 7;
        int tipY = this.getHeight() + 7;
        int xAxis = mouseX - this.getWidth();
        int yAxis = mouseY - this.getHeight();
        Map<Integer, StructureInit.StructureInfo> strucMap = StructureInit.strucMap;
        for (int id = 0; id < 4; ++id) {
            this.lootView[id] = false;
            if (this.isRender(tipX, tipY, mouseX, mouseY, 98, 19)) {
                if (id + this.startIndex >= strucMap.size()) break;
                StructureInit.StructureInfo info = strucMap.get(id + this.startIndex);
                MutableComponent struc = this.getTip("structure.sweetmagic." + info.name()).m_130940_(GOLD);
                MutableComponent dim = this.getTipArray(new Object[]{this.getText("dimension"), ": ", this.getText(info.getDim())}).m_130940_(GREEN);
                MutableComponent dif = this.getTipArray(new Object[]{this.getText("difficulty"), ": \u2605", info.level()}).m_130940_(GREEN);
                List<Component> comList = Arrays.asList(struc, dim, dif);
                this.m_96597_(pose, comList, xAxis + 0, yAxis - 20);
                this.lootView[id] = true;
            }
            tipY += 20;
        }
    }

    @Override
    public boolean m_6375_(double guiX, double guiY, int mouseButton) {
        int aX = this.f_97735_ + 110;
        int aY = (int)((float)(this.f_97736_ + 9) + this.scrollOffset * 60.0f);
        int w = 8;
        int h = 14;
        this.scrolling = guiX >= (double)aX && guiX < (double)(aX + w) && guiY >= (double)aY && guiY < (double)(aY + h);
        aX = this.f_97735_ + 25;
        aY = this.f_97736_ + 91;
        w = 29;
        h = 12;
        if (guiX >= (double)aX && guiX < (double)(aX + w) && guiY >= (double)aY && guiY < (double)(aY + h)) {
            PacketHandler.sendToServer(new CompasPKT(this.selectID));
            this.f_96541_.f_91074_.m_6915_();
            return super.m_6375_(guiX, guiY, mouseButton);
        }
        aX = this.f_97735_ + 58;
        if (guiX >= (double)aX && guiX < (double)(aX + w) && guiY >= (double)aY && guiY < (double)(aY + h)) {
            this.player.m_9236_().m_5594_(null, this.player.m_20183_(), SoundEvents.f_12490_, SoundSource.PLAYERS, 0.25f, 1.0f);
            this.f_96541_.f_91074_.m_6915_();
            return super.m_6375_(guiX, guiY, mouseButton);
        }
        int x = this.getWidth();
        int y = this.getHeight();
        double dX = guiX - (double)(x + 7);
        for (int id = 0; id < 4; ++id) {
            double dY = guiY - (double)(y + 7 + 20 * id);
            if (!(dX >= 0.0) || !(dX <= 98.0) || !(dY >= 0.0) || !(dY < 20.0)) continue;
            int newSelectID = id + this.startIndex;
            this.selectID = newSelectID != this.selectID ? newSelectID : -1;
            this.player.m_9236_().m_5594_(null, this.player.m_20183_(), SoundEvents.f_12490_, SoundSource.PLAYERS, 0.25f, 1.0f);
        }
        return super.m_6375_(guiX, guiY, mouseButton);
    }

    public boolean m_7979_(double mouseX, double mouseY, int mouseButton, double dragX, double dragY) {
        int size = StructureInit.strucMap.size();
        if (!this.scrolling) {
            return super.m_7979_(mouseX, mouseY, mouseButton, dragX, dragY);
        }
        int i = this.f_97736_ + 20;
        int j = i + 73;
        int offscreenRows = size - 4;
        this.scrollOffset = ((float)mouseY - (float)i + 5.0f) / ((float)(j - i) - 15.0f);
        this.scrollOffset = Mth.m_14036_((float)this.scrollOffset, (float)0.0f, (float)1.0f);
        this.startIndex = (int)((double)(this.scrollOffset * (float)offscreenRows) + 0.5);
        return true;
    }

    public boolean m_6050_(double mouseX, double mouseY, double scrollDelta) {
        int size = StructureInit.strucMap.size();
        int offscreenRows = size - 4;
        this.scrollOffset = (float)((double)this.scrollOffset - scrollDelta / (double)offscreenRows);
        this.scrollOffset = Mth.m_14036_((float)this.scrollOffset, (float)0.0f, (float)1.0f);
        this.startIndex = (int)((double)(this.scrollOffset * (float)offscreenRows) + 0.5);
        return true;
    }

    @Override
    protected ResourceLocation getTEX() {
        return TEX;
    }
}

