/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.tile.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import sweetmagic.SweetMagicCore;
import sweetmagic.init.ItemInit;
import sweetmagic.init.TagInit;
import sweetmagic.init.item.sm.SMBook;
import sweetmagic.init.tile.gui.GuiSMBase;
import sweetmagic.init.tile.gui.util.SMButton;
import sweetmagic.init.tile.gui.util.SMRenderTex;
import sweetmagic.init.tile.menu.EnchantEduceMenu;
import sweetmagic.init.tile.sm.TileEnchantEduce;

public class GuiEnchantEduce
extends GuiSMBase<EnchantEduceMenu> {
    private static final ResourceLocation TEX = SweetMagicCore.getSRC("textures/gui/gui_enchant_educe.png");
    private final TileEnchantEduce tile;
    private int tickTime = 0;
    private int counter = 0;
    private float scrollOffset = 0.0f;
    private int startIndex = 0;
    private boolean scrolling = false;
    private boolean[] enchaView = new boolean[4];
    private boolean addLevelView = false;
    private boolean subLevelView = false;
    private static final ItemStack BOOK = new ItemStack((ItemLike)Items.f_42517_);
    private static final ItemStack PAGE = new ItemStack((ItemLike)ItemInit.mysterious_page);
    private static final List<ItemStack> MAGICBOOK_LIST = GuiSMBase.getTagStack(TagInit.MAGIC_BOOK);

    public GuiEnchantEduce(EnchantEduceMenu menu, Inventory pInv, Component title) {
        super(menu, pInv, title);
        this.setGuiSize(217, 190);
        this.tile = menu.tile;
        this.scrolling = false;
        this.startIndex = 0;
        this.scrollOffset = 0.0f;
        this.addButtonMap(-1, new SMButton(MISC, 6, 7, 137, 47, 14, 14, new SMButton.SMButtonTip("change_output", 48, 26, "change_output_tip")));
        this.addRenderTexList(new SMRenderTex(MISC, 35, 29, 0, 0, 11, 77, new SMRenderTex.MFRenderGage(menu.tile, true)));
    }

    @Override
    protected void renderBGBase(PoseStack pose, float parTick, int mouseX, int mouseY) {
        RenderSystem.m_157427_(GameRenderer::m_172814_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.getTEX());
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.m_93228_(pose, this.f_97735_ + 24, this.f_97736_, 0, 0, this.f_97726_ - 24, this.f_97727_);
    }

    @Override
    protected void m_7286_(PoseStack pose, float parTick, int mouseX, int mouseY) {
        int id;
        int size;
        super.m_7286_(pose, parTick, mouseX, mouseY);
        int x = this.getWidth() + 24;
        int y = this.getHeight();
        RenderSystem.m_157456_((int)0, (ResourceLocation)MISC);
        this.m_93228_(pose, x - 24, y + 110, 70, 0, 24, 78);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEX);
        if (this.tickTime++ > 120) {
            this.tickTime = 0;
            if (this.counter++ >= MAGICBOOK_LIST.size() - 1) {
                this.counter = 0;
            }
        }
        if (this.tile.craftTime > 0) {
            int progress = this.tile.getCraftProgress(30);
            this.m_93228_(pose, x + 39, y + 45, 210, 45, 25, progress);
        }
        int h = (int)(60.0f * this.scrollOffset);
        boolean isActive = this.scrollbarActive();
        RenderSystem.m_157456_((int)0, (ResourceLocation)MISC);
        this.m_93228_(pose, x + 178, y + 30 + h, 83 + (isActive ? 0 : 8), 93, 8, 15);
        if (!isActive && !this.tile.isCraft) {
            this.startIndex = 0;
            this.scrollOffset = 0.0f;
        }
        for (int id2 = 0; id2 < 4; ++id2) {
            this.m_93228_(pose, x + 76, y + 26 + id2 * 21, 99, 93, 101, 20);
        }
        ItemStack stack = this.tile.getBookItem();
        List<Enchantment> enchaList = this.tile.getEnchaList();
        if (!(enchaList.isEmpty() || stack.m_41619_() || this.tile.isCraft)) {
            size = enchaList.size();
            for (id = 0; id < 4 && id + this.startIndex < size; ++id) {
                int cost;
                if (stack.m_41619_() || (cost = this.tile.getEnchantCost(id + this.startIndex, (SMBook)stack.m_41720_())) <= 0) continue;
                this.m_93228_(pose, x + 76, y + 26 + id * 21, 99, 113 + (this.enchaView[id] ? 20 : 0), 101, 20);
            }
        }
        if (!stack.m_41619_()) {
            int tier = this.tile.getPageCount(stack);
            int nowLevel = this.tile.getNowLevel();
            boolean canSub = nowLevel > this.tile.getMinLevel();
            boolean canAdd = this.tile.getMaxLevel(tier) > nowLevel;
            RenderSystem.m_157456_((int)0, (ResourceLocation)TEX);
            if (canSub) {
                this.m_93228_(pose, x + 182, y + 14, 210 + (this.subLevelView ? 7 : 0), 11, 7, 10);
            }
            if (canAdd) {
                this.m_93228_(pose, x + 182, y + 3, 210 + (this.addLevelView ? 7 : 0), 0, 7, 10);
            }
            this.f_96547_.m_92763_(pose, (Component)this.getTipArray(new Object[]{"Level: ", this.getLabel(nowLevel, WHITE)}), (float)(x + 112), (float)(y + 12), 2868292);
        }
        this.renderSlotItem(((EnchantEduceMenu)this.menu).pageSlot, PAGE, pose);
        this.renderSlotItem(((EnchantEduceMenu)this.menu).magicBookSlot, MAGICBOOK_LIST.get(this.counter), pose);
        if (enchaList.isEmpty() || stack.m_41619_() || this.tile.isCraft) {
            return;
        }
        size = enchaList.size();
        for (id = 0; id < 4 && id + this.startIndex < size; ++id) {
            MutableComponent name = this.getTip(enchaList.get(id + this.startIndex).m_44704_());
            int color = this.enchaView[id] ? 15685234 : 2868292;
            this.f_96547_.m_92763_(pose, (Component)name, (float)(x + 84), (float)(y + 32 + id * 21), color);
        }
    }

    @Override
    protected void m_7027_(PoseStack pose, int mouseX, int mouseY) {
        super.m_7027_(pose, mouseX, mouseY);
        this.renderItemLabel(((EnchantEduceMenu)this.menu).bookSlot, BOOK, pose, mouseX, mouseY);
        this.renderItemLabel(((EnchantEduceMenu)this.menu).pageSlot, PAGE, pose, mouseX, mouseY);
        this.renderItemLabel(((EnchantEduceMenu)this.menu).magicBookSlot, MAGICBOOK_LIST.get(this.counter), pose, mouseX, mouseY);
        int addX = 24;
        int tipX = this.getWidth() + 106 + addX;
        int tipY = this.getHeight() + 8;
        int xAxis = mouseX - this.getWidth();
        int yAxis = mouseY - this.getHeight();
        if (this.isRender(tipX, tipY, mouseX, mouseY, 65, 15)) {
            this.m_96602_(pose, (Component)this.getText("range_level").m_130940_(GOLD), xAxis, yAxis);
        }
        tipX = this.getWidth() + 11 + addX;
        tipY = this.getHeight() + 29;
        ItemStack magicBook = this.tile.getBookItem();
        if (this.tile.getInputItem().m_41619_() || magicBook.m_41619_() || this.tile.isCraft) {
            return;
        }
        tipX = this.getWidth() + 182 + addX;
        tipY = this.getHeight() + 3;
        this.addLevelView = false;
        this.subLevelView = false;
        if (this.isRender(tipX, tipY, mouseX, mouseY, 7, 10)) {
            this.addLevelView = true;
        }
        if (this.isRender(tipX, tipY += 11, mouseX, mouseY, 7, 10)) {
            this.subLevelView = true;
        }
        tipX = this.getWidth() + 76 + addX;
        tipY = this.getHeight() + 26;
        for (int id = 0; id < 4; ++id) {
            this.enchaView[id] = false;
            if (this.isRender(tipX, tipY, mouseX, mouseY, 98, 20)) {
                int cost = this.tile.getEnchantCost(id + this.startIndex, (SMBook)magicBook.m_41720_());
                if (cost <= 0) break;
                String tip = String.format("%,d", cost);
                this.m_96602_(pose, (Component)this.getTipArray(new Object[]{this.getText("needmf"), this.getLabel(tip, WHITE)}).m_130940_(GOLD), xAxis - 80, yAxis - 6);
                this.enchaView[id] = true;
            }
            tipY += 21;
        }
    }

    @Override
    public boolean m_6375_(double guiX, double guiY, int mouseButton) {
        this.scrolling = false;
        int addX = 24;
        int aX = this.f_97735_ + 178 + addX;
        int aY = (int)((float)(this.f_97736_ + 30) + this.scrollOffset * 60.0f);
        int w = 8;
        int h = 14;
        if (guiX >= (double)aX && guiX < (double)(aX + w) && guiY >= (double)aY && guiY < (double)(aY + h)) {
            this.scrolling = true;
        }
        int x = this.getWidth() + addX;
        int y = this.getHeight();
        double dX = guiX - (double)(x + 182);
        double dY = guiY - (double)(y + 3);
        if (dX >= 0.0 && dX <= 7.0 && dY >= 0.0 && dY < 10.0) {
            this.clickButton(0);
        } else if (dX >= 0.0 && dX <= 7.0 && dY >= 10.0 && dY < 20.0) {
            this.clickButton(1);
        }
        dX = guiX - (double)(x + 101) + (double)addX;
        for (int id = 0; id < 4; ++id) {
            dY = guiY - ((double)(y + 26) + 21.0 * (double)id);
            if (!(dX >= 0.0) || !(dX <= 95.0) || !(dY >= 0.0) || !(dY < 21.0)) continue;
            this.clickButton(id + this.startIndex + 2);
            break;
        }
        return super.m_6375_(guiX, guiY, mouseButton);
    }

    public boolean m_7979_(double mouseX, double mouseY, int mouseButton, double dragX, double dragY) {
        List<Enchantment> enchaList = ((EnchantEduceMenu)this.menu).tile.getEnchaList();
        int size = enchaList.size();
        if (!this.scrolling || !this.scrollbarActive()) {
            return super.m_7979_(mouseX, mouseY, mouseButton, dragX, dragY);
        }
        int i = this.f_97736_ + 44;
        int j = i + 73;
        int offscreenRows = size - 4;
        this.scrollOffset = ((float)mouseY - (float)i + 5.0f) / ((float)(j - i) - 15.0f);
        this.scrollOffset = Mth.m_14036_((float)this.scrollOffset, (float)0.0f, (float)1.0f);
        this.startIndex = (int)((double)(this.scrollOffset * (float)offscreenRows) + 0.5);
        return true;
    }

    public boolean m_6050_(double mouseX, double mouseY, double scrollDelta) {
        if (!this.scrollbarActive()) {
            return super.m_6050_(mouseX, mouseY, scrollDelta);
        }
        List<Enchantment> enchaList = ((EnchantEduceMenu)this.menu).tile.getEnchaList();
        int size = enchaList.size();
        int offscreenRows = size - 4;
        this.scrollOffset = (float)((double)this.scrollOffset - scrollDelta / (double)offscreenRows);
        this.scrollOffset = Mth.m_14036_((float)this.scrollOffset, (float)0.0f, (float)1.0f);
        this.startIndex = (int)((double)(this.scrollOffset * (float)offscreenRows) + 0.5);
        return true;
    }

    @Override
    public void setTip(List<Component> tipList, ItemStack stack) {
        if (stack.m_150930_(Items.f_42517_)) {
            tipList.add((Component)this.getText("can_encha").m_130940_(GREEN));
        } else {
            tipList = Arrays.asList(this.getText("slot_need").m_130940_(GREEN), stack.m_41611_());
        }
    }

    private boolean scrollbarActive() {
        return this.tile.getEnchaList().size() > 4 && !this.tile.isCraft && !this.tile.getBookItem().m_41619_();
    }

    @Override
    protected ResourceLocation getTEX() {
        return TEX;
    }
}

