/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.tile.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundRenameItemPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import sweetmagic.SweetMagicCore;
import sweetmagic.handler.PacketHandler;
import sweetmagic.init.tile.gui.GuiSMBase;
import sweetmagic.init.tile.gui.util.SMButton;
import sweetmagic.init.tile.menu.FurnitureCraftMenu;
import sweetmagic.init.tile.sm.TileFurnitureTable;
import sweetmagic.packet.FurnitureCraftPKT;

public class GuiFurnitureCraft
extends GuiSMBase<FurnitureCraftMenu> {
    private static final ResourceLocation TEX = SweetMagicCore.getSRC("textures/gui/gui_furniture_craft.png");
    private final TileFurnitureTable tile;
    private EditBox count;
    private int oldSetCount = 0;
    private boolean isInit = false;

    public GuiFurnitureCraft(FurnitureCraftMenu menu, Inventory pInv, Component title) {
        super(menu, pInv, title);
        this.tile = menu.tile;
        this.setGuiSize(80, 81);
        this.addButtonMap(0, new SMButton(TEX, 9, 9, 83, 9, 20, 11));
        this.addButtonMap(1, new SMButton(TEX, 9, 43, 83, 9, 20, 11));
        this.addButtonMap(2, new SMButton(TEX, 30, 9, 83, 9, 20, 11));
        this.addButtonMap(3, new SMButton(TEX, 30, 43, 83, 9, 20, 11));
        this.addButtonMap(4, new SMButton(TEX, 51, 9, 83, 9, 20, 11));
        this.addButtonMap(5, new SMButton(TEX, 51, 43, 83, 9, 20, 11));
        this.addButtonMap(6, new SMButton(TEX, 9, 59, 83, 23, 29, 12));
        this.addButtonMap(7, new SMButton(TEX, 42, 59, 83, 23, 29, 12));
    }

    @Override
    public void m_6305_(PoseStack pose, int mouseX, int mouseY, float parTick) {
        super.m_6305_(pose, mouseX, mouseY, parTick);
        this.count.m_6305_(pose, mouseX, mouseY, parTick);
    }

    @Override
    protected void m_7286_(PoseStack pose, float parTick, int mouseX, int mouseY) {
        super.m_7286_(pose, parTick, mouseX, mouseY);
        int x = this.getWidth();
        int y = this.getHeight();
        this.f_96547_.m_92763_(pose, (Component)this.getLabel("+1"), (float)(x + 14), (float)(y + 11), 0xEEEEEE);
        this.f_96547_.m_92763_(pose, (Component)this.getLabel("-1"), (float)(x + 14), (float)(y + 45), 0xEEEEEE);
        this.f_96547_.m_92763_(pose, (Component)this.getLabel("+10"), (float)(x + 31), (float)(y + 11), 0xEEEEEE);
        this.f_96547_.m_92763_(pose, (Component)this.getLabel("-10"), (float)(x + 31), (float)(y + 45), 0xEEEEEE);
        this.f_96547_.m_92763_(pose, (Component)this.getLabel("+64"), (float)(x + 52), (float)(y + 11), 0xEEEEEE);
        this.f_96547_.m_92763_(pose, (Component)this.getLabel("-64"), (float)(x + 52), (float)(y + 45), 0xEEEEEE);
        this.f_96547_.m_92763_(pose, (Component)this.getText("decision"), (float)(x + 14), (float)(y + 61), 0xEEEEEE);
        this.f_96547_.m_92763_(pose, (Component)this.getText("cancel"), (float)(x + 46), (float)(y + 61), 0xEEEEEE);
        this.renderSlotItem(((FurnitureCraftMenu)this.menu).resultSlot, this.tile.outStack, pose, 0);
    }

    @Override
    protected void m_7027_(PoseStack pose, int mouseX, int mouseY) {
        super.m_7027_(pose, mouseX, mouseY);
        if (!this.tile.outStack.m_41619_()) {
            this.renderItemLabel(((FurnitureCraftMenu)this.menu).resultSlot, this.tile.outStack, pose, mouseX, mouseY, Arrays.asList(this.getText("craft_item").m_130940_(GREEN), this.tile.outStack.m_41786_()));
        }
    }

    public void m_181908_() {
        super.m_181908_();
        this.count.m_94120_();
        if (this.oldSetCount != this.tile.setCount) {
            this.count.m_94144_("" + this.tile.setCount);
            this.oldSetCount = this.tile.setCount;
        }
    }

    protected void m_7856_() {
        super.m_7856_();
        this.subInit();
    }

    protected void subInit() {
        int x = this.getWidth();
        int y = this.getHeight();
        this.count = new EditBox(this.f_96547_, x + 12, y + 27, 116, 12, (Component)this.getTip("container.repair1"));
        this.count.m_94190_(false);
        this.count.m_94202_(-1);
        this.count.m_94205_(-1);
        this.count.m_94182_(false);
        this.count.m_94199_(40);
        this.count.m_94151_(this::onNameChanged);
        this.count.m_94144_("" + this.tile.setCount);
        this.m_7787_((GuiEventListener)this.count);
        this.m_94718_((GuiEventListener)this.count);
        this.m_7522_((GuiEventListener)this.count);
        this.isInit = true;
    }

    public void m_6574_(Minecraft mc, int x, int y) {
        String countString = this.count.m_94155_();
        this.m_6575_(mc, x, y);
        this.count.m_94144_(countString);
    }

    public boolean m_7933_(int id, int par1, int par2) {
        if (id == 256) {
            this.f_96541_.f_91074_.m_6915_();
        }
        return !this.count.m_7933_(id, par1, par2) ? super.m_7933_(id, par1, par2) : true;
    }

    private void onNameChanged(String name) {
        if (name.isEmpty()) {
            return;
        }
        String s = name;
        this.f_96541_.f_91074_.f_108617_.m_104955_((Packet)new ServerboundRenameItemPacket(s));
        if (!this.isInt(s) || !this.isInit) {
            return;
        }
        int value = Integer.valueOf(s);
        if (this.tile.setCount == value) {
            return;
        }
        PacketHandler.sendToServer(new FurnitureCraftPKT(this.getValue(s), this.tile.m_58899_()));
    }

    private boolean isInt(String str) {
        return str != null && str.matches("[0-9]+");
    }

    private Integer getValue(String str) {
        return Math.min(1024, Math.max(1, Integer.valueOf(str)));
    }

    @Override
    protected ResourceLocation getTEX() {
        return TEX;
    }
}

