/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.tile.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.Tags;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;
import sweetmagic.SweetMagicCore;
import sweetmagic.init.TagInit;
import sweetmagic.init.tile.gui.GuiSMBase;
import sweetmagic.init.tile.gui.util.SMRenderTex;
import sweetmagic.init.tile.menu.MFGeneraterMenu;
import sweetmagic.init.tile.sm.TileMFGenerater;

public class GuiMFGenerater
extends GuiSMBase<MFGeneraterMenu> {
    private static final ResourceLocation TEX = SweetMagicCore.getSRC("textures/gui/gui_mf_generator.png");
    private final TileMFGenerater tile;
    private int counter = 0;
    private int counter_lava = 0;
    private int tickTime = 0;
    private static final List<ItemStack> LAVA_LIST = GuiSMBase.getTagStack(TagInit.LAVA);
    private static final List<ItemStack> STONE_LIST = GuiSMBase.getTagStack((TagKey<Item>)Tags.Items.COBBLESTONE);

    public GuiMFGenerater(MFGeneraterMenu menu, Inventory pInv, Component title) {
        super(menu, pInv, title);
        this.setGuiSize(176, 172);
        this.tile = menu.tile;
        this.addRenderTexList(new SMRenderTex(TEX, 7, 7, 0, 0, 11, 77, new SMRenderTex.MFRenderGage(menu.tile, true)));
    }

    @Override
    protected void m_7286_(PoseStack pose, float parTick, int mouseX, int mouseY) {
        super.m_7286_(pose, parTick, mouseX, mouseY);
        int x = this.getWidth() + 159;
        int y = this.getHeight() + 11;
        int progress = (int)this.tile.getFluidProgressScaled(75.0f);
        if (progress > 0) {
            int height = 72;
            int width = 9;
            FluidStack fluid = this.tile.getContent();
            IClientFluidTypeExtensions ext = IClientFluidTypeExtensions.of((FluidType)fluid.getFluid().getFluidType());
            ResourceLocation src = ext.getStillTexture(fluid);
            TextureAtlasSprite tex = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(src);
            int y1 = y + (height - progress);
            RenderSystem.m_157456_((int)0, (ResourceLocation)InventoryMenu.f_39692_);
            Matrix4f mat = pose.m_85850_().m_85861_();
            int hc = progress / 16;
            int hr = progress - hc * 16;
            if (hc > 0) {
                for (int h = 0; h < hc; ++h) {
                    int y2 = y1 + hr + h * 16;
                    this.drawFluid(mat, x, y2, width, 16, tex, 0);
                }
            }
            if (hr > 0) {
                this.drawFluid(mat, x, y1, width, hr, tex, 16 - hr);
            }
            RenderSystem.m_157427_(GameRenderer::m_172814_);
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.getTEX());
        }
        this.m_93228_(pose, x - 1, y - 2, 194, 9, 11, 74);
        if (this.tickTime++ > 120) {
            this.tickTime = 0;
            if (this.counter++ >= STONE_LIST.size() - 1) {
                this.counter = 0;
            }
            if (this.counter_lava++ >= LAVA_LIST.size() - 1) {
                this.counter_lava = 0;
            }
        }
        this.renderSlotItem(((MFGeneraterMenu)this.menu).bucketSlot, LAVA_LIST.get(this.counter_lava), pose, 0);
        this.renderSlotItem(((MFGeneraterMenu)this.menu).stoneSlotList.get(0), STONE_LIST.get(this.counter), pose);
    }

    @Override
    protected void m_7027_(PoseStack pose, int mouseX, int mouseY) {
        super.m_7027_(pose, mouseX, mouseY);
        int tipX = this.getWidth() + 158;
        int tipY = this.getHeight() + 7;
        if (this.isRender(tipX, tipY, mouseX, mouseY, 11, 76)) {
            float fluid = (float)this.tile.getFluidValue() * 0.001f;
            float maxFluid = (float)this.tile.getMaxFuildValue() * 0.001f;
            String par = " (" + this.tile.getFluidPercent() + ")";
            int xAxis = mouseX - this.getWidth();
            int yAxis = mouseY - this.getHeight();
            String tip = String.format("%,.1f", Float.valueOf(fluid)) + "B / " + String.format("%,.1f", Float.valueOf(maxFluid)) + "B" + par;
            this.m_96602_(pose, (Component)this.getLabel(tip), xAxis, yAxis);
        }
        this.renderItemLabel(((MFGeneraterMenu)this.menu).bucketSlot, LAVA_LIST.get(this.counter_lava), pose, mouseX, mouseY);
        this.renderItemLabel(((MFGeneraterMenu)this.menu).stoneSlotList.get(0), STONE_LIST.get(this.counter), pose, mouseX, mouseY);
    }

    @Override
    public void setTip(List<Component> tipList, ItemStack stack) {
        if (LAVA_LIST.contains(stack)) {
            tipList.addAll(Arrays.asList(this.getText("fill_bucket").m_130940_(GREEN), stack.m_41611_()));
        } else {
            tipList.addAll(Arrays.asList(this.getText("slot_need").m_130940_(GREEN), stack.m_41611_()));
        }
    }

    @Override
    protected ResourceLocation getTEX() {
        return TEX;
    }
}

