/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.tile.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import sweetmagic.SweetMagicCore;
import sweetmagic.init.TagInit;
import sweetmagic.init.tile.gui.GuiSMBase;
import sweetmagic.init.tile.gui.util.SMButton;
import sweetmagic.init.tile.menu.ObMagiaMenu;
import sweetmagic.init.tile.sm.TileObMagia;

public class GuiObMagia
extends GuiSMBase<ObMagiaMenu> {
    private static final ResourceLocation TEX = SweetMagicCore.getSRC("textures/gui/gui_obmagia.png");
    private final TileObMagia tile;
    private int tickTime = 0;
    private int pageCounter = 0;
    private int baseCounter = 0;
    private static final List<ItemStack> PAGE = ForgeRegistries.ITEMS.tags().getTag(TagInit.SM_PAGE).stream().map(Item::m_7968_).collect(Collectors.toList());
    private static final List<ItemStack> BASE = ForgeRegistries.ITEMS.tags().getTag(TagInit.SM_BASE).stream().map(Item::m_7968_).collect(Collectors.toList());

    public GuiObMagia(ObMagiaMenu menu, Inventory pInv, Component title) {
        super(menu, pInv, title);
        this.setGuiSize(219, 189);
        this.tile = menu.tile;
        SMButton.SMButtonTip buttonTip = new SMButton.SMButtonTip("", 30, 0, this.tile){

            public boolean isFlagText(TileObMagia tile) {
                return tile.canCraft;
            }

            @Override
            public String getTip() {
                return this.isFlagText(GuiObMagia.this.tile) ? "caraft_start" : "no_recipe";
            }
        };
        SMButton button = new SMButton(MISC, 137, 81, 114, 15, 32, 12, buttonTip){

            @Override
            public boolean isButtonRender() {
                return GuiObMagia.this.tile.canCraft;
            }
        };
        this.addButtonMap(0, button);
    }

    @Override
    protected void renderBGBase(PoseStack pose, float parTick, int mouseX, int mouseY) {
        RenderSystem.m_157427_(GameRenderer::m_172814_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.getTEX());
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.m_93228_(pose, this.f_97735_ + 27, this.f_97736_, 0, 0, this.f_97726_ - 27, this.f_97727_);
    }

    @Override
    protected void m_7286_(PoseStack pose, float parTick, int mouseX, int mouseY) {
        super.m_7286_(pose, parTick, mouseX, mouseY);
        int x = this.getWidth();
        int y = this.getHeight();
        if (!this.tile.canCraft) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)MISC);
            this.m_93228_(pose, x + 137, y + 81, 20, 0, 32, 14);
        }
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.getTEX());
        this.m_93228_(pose, x, y + 8, 228, 17, 27, 182);
        if (this.tickTime++ > 120) {
            this.tickTime = 0;
            if (this.pageCounter++ >= PAGE.size() - 1) {
                this.pageCounter = 0;
            }
            if (this.baseCounter++ >= BASE.size() - 1) {
                this.baseCounter = 0;
            }
        }
        if (this.tile.craftTime > 0) {
            int progress = this.tile.getProgress(33);
            this.m_93228_(pose, x + 132, y + 49, 193, 1, progress, 14);
        }
        this.renderSlotItem(((ObMagiaMenu)this.menu).baseSlot, BASE.get(this.baseCounter), pose);
        this.renderSlotItem(((ObMagiaMenu)this.menu).pageSlot, PAGE.get(this.pageCounter), pose);
        if (!this.tile.isCraft && this.tile.canCraft) {
            this.renderSlotItem(((ObMagiaMenu)this.menu).outSlot, this.tile.viewStack, pose, 0);
        }
    }

    @Override
    protected void m_7027_(PoseStack pose, int mouseX, int mouseY) {
        super.m_7027_(pose, mouseX, mouseY);
        this.renderItemLabel(((ObMagiaMenu)this.menu).baseSlot, BASE.get(this.baseCounter), pose, mouseX, mouseY, this.createTipList(BASE.get(this.baseCounter), "slot_need"));
        this.renderItemLabel(((ObMagiaMenu)this.menu).pageSlot, PAGE.get(this.pageCounter), pose, mouseX, mouseY, this.createTipList(PAGE.get(this.pageCounter), "slot_need"));
        if (!this.tile.isCraft && this.tile.canCraft) {
            this.renderItemLabel(((ObMagiaMenu)this.menu).outSlot, this.tile.viewStack, pose, mouseX, mouseY, this.createTipList(this.tile.viewStack, "craft_out"));
        }
    }

    @Override
    protected ResourceLocation getTEX() {
        return TEX;
    }
}

