/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.tile.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import sweetmagic.SweetMagicCore;
import sweetmagic.init.tile.gui.GuiSMBase;
import sweetmagic.init.tile.gui.util.SMButton;
import sweetmagic.init.tile.menu.ParallelInterfereMenu;
import sweetmagic.init.tile.sm.TileParallelInterfere;

public class GuiParallelInterfere
extends GuiSMBase<ParallelInterfereMenu> {
    private static final ResourceLocation TEX = SweetMagicCore.getSRC("textures/gui/gui_parallel_book.png");
    private final TileParallelInterfere tile;
    private float scrollOffset = 0.0f;
    private int startIndex = 0;
    private boolean scrolling = false;
    private boolean scrollingView = false;
    private boolean upPageView = false;
    private boolean downPageView = false;

    public GuiParallelInterfere(ParallelInterfereMenu menu, Inventory pInv, Component title) {
        super(menu, pInv, title);
        this.setGuiSize(192, 202);
        this.tile = menu.tile;
        this.addButtonMap(0, new SMButton(MISC, 150, -11, 114, 0, 10, 9, new SMButton.SMButtonTip("sort", -18, 14)));
        this.addButtonMap(1, new SMButton(MISC, 137, -11, 137, 0, 11, 9, new SMButton.SMButtonTip("quick_stack", -18, 14)));
        this.addButtonMap(2, new SMButton(MISC, 124, -11, 161, 0, 11, 9, new SMButton.SMButtonTip("restock", -18, 14)));
        this.addButtonMap(-1, new SMButton(MISC, 163, -11, 114, 33, 9, 9, new SMButton.SMButtonTip("parallel_interfere_info", -18, 14)));
    }

    @Override
    protected void m_7286_(PoseStack pose, float parTick, int mouseX, int mouseY) {
        super.m_7286_(pose, parTick, mouseX, mouseY);
        this.scrollingView = false;
        int x = this.getWidth() + 174;
        int y = (int)((float)(this.getHeight() + 8) + 91.0f * this.scrollOffset);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.getTEX());
        if (this.isRender(x, y, mouseX, mouseY, 12, 15)) {
            this.scrollingView = true;
        }
        this.m_93228_(pose, x, y, 0 + (this.scrollingView ? 12 : 0), 202, 12, 15);
        x = this.getWidth();
        y = this.getHeight();
        RenderSystem.m_157456_((int)0, (ResourceLocation)MISC);
        this.m_93228_(pose, x + 111, y - 11, 137 + (this.upPageView ? 11 : 0), 33, 11, 9);
        this.m_93228_(pose, x + 98, y - 11, 161 + (this.downPageView ? 11 : 0), 33, 11, 9);
        this.renderStock(this.tile.getInvList(), pose, 1, 2, 0, 0);
    }

    @Override
    protected void m_7027_(PoseStack pose, int mouseX, int mouseY) {
        super.m_7027_(pose, mouseX, mouseY);
        this.upPageView = false;
        this.downPageView = false;
        int x = this.getWidth() + 111;
        int y = this.getHeight() - 11;
        int xAxis = mouseX - this.getWidth();
        int yAxis = mouseY - this.getHeight();
        if (this.isRender(x, y, mouseX, mouseY, 10, 9)) {
            this.upPageView = true;
            this.m_96602_(pose, (Component)this.getText("page_up"), xAxis - 72, yAxis + 12);
        }
        if (this.isRender(x = this.getWidth() + 98, y, mouseX, mouseY, 10, 9)) {
            this.downPageView = true;
            this.m_96602_(pose, (Component)this.getText("page_down"), xAxis - 72, yAxis + 12);
        }
    }

    @Override
    public List<Integer> getInvRenderArray() {
        return List.of(Integer.valueOf(7), Integer.valueOf(119), Integer.valueOf(7), Integer.valueOf(7));
    }

    @Override
    public int getInvY() {
        return 6;
    }

    @Override
    public int getInvX() {
        return 9;
    }

    @Override
    public boolean m_6375_(double guiX, double guiY, int mouseButton) {
        this.scrolling = false;
        int aX = this.f_97735_ + 178;
        int aY = (int)((float)(this.f_97736_ + 8) + 91.0f * this.scrollOffset);
        int w = 12;
        int h = 15;
        if (guiX >= (double)aX && guiX < (double)(aX + w) && guiY >= (double)aY && guiY < (double)(aY + h)) {
            this.scrolling = true;
        }
        aX = this.f_97735_ + 111;
        aY = this.f_97736_ - 11;
        w = 10;
        h = 9;
        if (guiX >= (double)aX && guiX < (double)(aX + w) && guiY >= (double)aY && guiY < (double)(aY + h)) {
            this.addPage(6.0);
            this.clickButton(3);
            return true;
        }
        aX = this.f_97735_ + 98;
        if (guiX >= (double)aX && guiX < (double)(aX + w) && guiY >= (double)aY && guiY < (double)(aY + h)) {
            this.addPage(-6.0);
            this.clickButton(3);
            return true;
        }
        return super.m_6375_(guiX, guiY, mouseButton);
    }

    public boolean m_7979_(double mouseX, double mouseY, int mouseButton, double dragX, double dragY) {
        if (!this.scrolling) {
            return super.m_7979_(mouseX, mouseY, mouseButton, dragX, dragY);
        }
        int i = this.f_97736_ + 23;
        int j = i + 105;
        int offscreenRows = this.tile.getInvSize() / 9 - 6;
        this.scrollOffset = ((float)mouseY - (float)i + 5.0f) / ((float)(j - i) - 15.0f);
        this.scrollOffset = Mth.m_14036_((float)this.scrollOffset, (float)0.0f, (float)1.0f);
        this.startIndex = (int)((double)(this.scrollOffset * (float)offscreenRows) + 0.5);
        ((ParallelInterfereMenu)this.menu).updateSlotPositions(this.startIndex);
        return true;
    }

    public boolean m_6050_(double mouseX, double mouseY, double scrollDelta) {
        int x = this.getWidth() + 174;
        int y = this.getHeight() + 8;
        if (Screen.m_96638_() || this.isRender(x, y, (int)mouseX, (int)mouseY, 12, 105)) {
            int offscreenRows = this.tile.getInvSize() / 9 - 6;
            this.scrollOffset = (float)((double)this.scrollOffset - scrollDelta / (double)offscreenRows);
            this.scrollOffset = Mth.m_14036_((float)this.scrollOffset, (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffset * (float)offscreenRows) + 0.5);
            ((ParallelInterfereMenu)this.menu).updateSlotPositions(this.startIndex);
            return true;
        }
        return super.m_6050_(mouseX, mouseY, scrollDelta);
    }

    public void addPage(double scrollDelta) {
        int offscreenRows = this.tile.getInvSize() / 9 - 6;
        this.scrollOffset = (float)((double)this.scrollOffset - scrollDelta / (double)offscreenRows);
        this.scrollOffset = Mth.m_14036_((float)this.scrollOffset, (float)0.0f, (float)1.0f);
        this.startIndex = (int)((double)(this.scrollOffset * (float)offscreenRows) + 0.5);
        ((ParallelInterfereMenu)this.menu).updateSlotPositions(this.startIndex);
    }

    @Override
    protected ResourceLocation getTEX() {
        return TEX;
    }
}

