/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.tile.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import sweetmagic.SweetMagicCore;
import sweetmagic.handler.PacketHandler;
import sweetmagic.init.ItemInit;
import sweetmagic.init.capability.icap.ICookingStatus;
import sweetmagic.init.tile.gui.GuiSMBase;
import sweetmagic.init.tile.gui.util.SMButton;
import sweetmagic.init.tile.menu.PhoneMenu;
import sweetmagic.init.tile.sm.TileNotePC;
import sweetmagic.packet.PhonePKT;

public class GuiPhone
extends GuiSMBase<PhoneMenu> {
    private static final ResourceLocation TEX = SweetMagicCore.getSRC("textures/gui/gui_phone.png");
    private static final ItemStack SUGAR = new ItemStack((ItemLike)ItemInit.sugarbell);
    private static final ItemStack AETHER = new ItemStack((ItemLike)ItemInit.aether_crystal);
    private static final ItemStack ICE = new ItemStack((ItemLike)ItemInit.unmeltable_ice);
    private static final String FORMAT_REGEX = "\u00a7.";
    private ICookingStatus cook;
    private List<PlayerInfo> infoList;
    private Map<UUID, Player> playerMap = new HashMap<UUID, Player>();
    private List<UUID> playerList = new ArrayList<UUID>();
    private int size = 0;
    private int maxSize = 0;
    private int tabId = 0;
    private boolean[] tabView = new boolean[5];
    private boolean[] lootView = new boolean[4];
    private float scrollOffset = 0.0f;
    private int startIndex = 0;
    private boolean scrolling = false;
    private int selectID = -1;
    private boolean click = false;

    public GuiPhone(PhoneMenu menu, Inventory pInv, Component title) {
        super(menu, pInv, title);
        this.setGuiSize(172, 190);
        this.cook = ((PhoneMenu)this.menu).cook;
        this.infoList = ((PhoneMenu)this.menu).infoList;
        this.maxSize = ((PhoneMenu)this.menu).isSingle ? ((PhoneMenu)this.menu).tradeList.get(0).size() : this.infoList.size();
        this.size = Math.min(4, this.maxSize);
        Player player = this.player;
        if (player instanceof LocalPlayer) {
            LocalPlayer local = (LocalPlayer)player;
            for (Entity entity : local.f_108545_.m_104735_()) {
                Player player2;
                if (!(entity instanceof Player) || (player2 = (Player)entity).m_20148_() == this.player.m_20148_()) continue;
                this.playerMap.put(player2.m_20148_(), player2);
                this.playerList.add(player2.m_20148_());
            }
        }
        this.addButtonMap(0, new SMButton(TEX, 83, 57, 176, 57, 22, 12));
        this.addButtonMap(1, new SMButton(TEX, 105, 57, 176, 69, 28, 12));
        this.addButtonMap(2, new SMButton(TEX, 133, 57, 176, 81, 33, 12));
        this.addButtonMap(3, new SMButton(TEX, 83, 69, 176, 57, 22, 12));
        this.addButtonMap(4, new SMButton(TEX, 105, 69, 176, 69, 28, 12));
        this.addButtonMap(5, new SMButton(TEX, 133, 69, 176, 81, 33, 12));
        this.addButtonMap(6, new SMButton(TEX, 141, 35, 176, 35, 26, 18));
    }

    @Override
    protected void m_7286_(PoseStack pose, float parTick, int mouseX, int mouseY) {
        MutableComponent tip;
        ItemStack stack;
        int i;
        super.m_7286_(pose, parTick, mouseX, mouseY);
        int x = this.getWidth();
        int y = this.getHeight();
        for (i = 0; i < this.size; ++i) {
            this.m_93228_(pose, x + 5, y + 13 + i * 17, 176, this.lootView[i] ? 0 : 225, 67, 17);
        }
        if (((PhoneMenu)this.menu).isSingle) {
            this.renderSingleBg(pose, parTick, x, y, mouseX, mouseY);
            return;
        }
        pose.m_85836_();
        pose.m_85841_(0.5f, 0.5f, 0.5f);
        for (i = 0; i < this.size; ++i) {
            PlayerInfo info = this.infoList.get(i + this.startIndex);
            RenderSystem.m_157456_((int)0, (ResourceLocation)info.m_105337_());
            this.m_93228_(pose, (x + 6) * 2, (y + 14 + i * 32) * 2, 32, 32, 32, 32);
            this.m_93228_(pose, (x + 6) * 2, (y + 14 + i * 32) * 2, 160, 32, 32, 32);
        }
        if (this.selectID != -1 && this.tabId != 2) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.infoList.get(this.selectID).m_105337_());
            this.m_93228_(pose, (x + 84) * 2, (y + 36) * 2, 32, 32, 32, 32);
            this.m_93228_(pose, (x + 84) * 2, (y + 36) * 2, 160, 32, 32, 32);
        }
        pose.m_85849_();
        pose.m_85836_();
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEX);
        if (this.tabId == 2 && !(stack = ((PhoneMenu)this.menu).inventory.getInv().getStackInSlot(0)).m_41619_()) {
            String sp = this.format(TileNotePC.getGlobalValue(1.0f, stack));
            this.f_96542_.m_115218_(stack, x + 84, y + 36);
            this.f_96547_.m_92889_(pose, (Component)this.getText("trade_sell").m_130940_(GREEN), (float)(x + 102), (float)(y + 35), 0x333333);
            tip = this.getLabel(sp + "sp", GREEN);
            this.drawFont(pose, (Component)tip, 38.0f, x + 102, y + 44, 0x333333, false);
        }
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEX);
        for (int i2 = 0; i2 < 3; ++i2) {
            int addX = i2 != this.tabId ? 18 : 0;
            this.m_93228_(pose, x + 59 + i2 * 18, y + 104, 176 + addX, 104, 18, 1);
            if (!this.tabView[i2]) continue;
            this.m_93228_(pose, x + 59 + i2 * 18, y + 87, 176, 113, 18, 17);
        }
        this.m_93228_(pose, x + 63, y + 89, 200, 114, 13, 14);
        this.m_93228_(pose, x + 81, y + 89, 200, 114, 13, 14);
        this.f_96542_.m_115218_(SUGAR, x + 97, y + 88);
        if (this.selectID != -1 && this.tabId != 2) {
            float maxSize = 38.0f;
            Player player = this.playerMap.get(this.infoList.get(this.selectID).m_105312_().getId());
            if (player == null) {
                return;
            }
            tip = this.getLabel(player.m_7755_().getString().replaceAll(FORMAT_REGEX, ""), WHITE);
            this.drawFont(pose, (Component)tip, maxSize, x + 102, y + 37, 0x333333, false);
            int sp = ((PhoneMenu)this.menu).sp;
            MutableComponent tip2 = this.getLabel(this.format(sp) + "sp", sp >= 0 ? GREEN : RED);
            this.drawFont(pose, (Component)tip2, maxSize, x + 102, y + 45, 0x333333, false);
        }
        for (int i3 = 0; i3 < this.size; ++i3) {
            String name = this.infoList.get(i3 + this.startIndex).m_105312_().getName().replaceAll(FORMAT_REGEX, "");
            this.drawFont(pose, (Component)this.getLabel(name, WHITE), 48.0f, x + 25, y + 20, 0xEEEEEE, true);
        }
        this.f_96547_.m_92889_(pose, (Component)this.getText("trade_level", new Object[]{this.format(this.cook.getTradeLevel())}), (float)(x + 85), (float)(y + 14), 0x333333);
        MutableComponent tip2 = this.getText("possess_sp", new Object[]{": " + this.format(this.cook.getTradeSP()) + "sp"});
        this.drawFont(pose, (Component)tip2, 80.0f, x + 85, y + 22, 0x333333, false);
        this.f_96547_.m_92763_(pose, (Component)this.getLabel("+10", WHITE), (float)(x + 85), (float)(y + 60), 0xEEEEEE);
        this.f_96547_.m_92763_(pose, (Component)this.getLabel("+100", WHITE), (float)(x + 107), (float)(y + 60), 0xEEEEEE);
        this.f_96547_.m_92763_(pose, (Component)this.getLabel("+1000", WHITE), (float)(x + 135), (float)(y + 60), 0xEEEEEE);
        this.f_96547_.m_92763_(pose, (Component)this.getLabel("-10", WHITE), (float)(x + 85), (float)(y + 72), 0xEEEEEE);
        this.f_96547_.m_92763_(pose, (Component)this.getLabel("-100", WHITE), (float)(x + 107), (float)(y + 72), 0xEEEEEE);
        this.f_96547_.m_92763_(pose, (Component)this.getLabel("-1000", WHITE), (float)(x + 135), (float)(y + 72), 0xEEEEEE);
        this.f_96547_.m_92889_(pose, (Component)this.getLabel("P"), (float)(x + 61), (float)(y + 97), 0xA8A8A8);
        this.f_96547_.m_92889_(pose, (Component)this.getLabel("I"), (float)(x + 80), (float)(y + 97), 0xA8A8A8);
        String send = this.tabId != 2 ? "phone_send" : "trade_sale";
        this.f_96547_.m_92763_(pose, (Component)this.getText(send), (float)(x + 145), (float)(y + 40), 0xEEEEEE);
        pose.m_85849_();
    }

    protected void renderSingleBg(PoseStack pose, float parTick, int x, int y, int mouseX, int mouseY) {
        for (int i = 0; i < 3; ++i) {
            int addX = i != this.tabId ? 18 : 0;
            this.m_93228_(pose, x + 59 + i * 18, y + 104, 176 + addX, 104, 18, 1);
            if (!this.tabView[i]) continue;
            this.m_93228_(pose, x + 59 + i * 18, y + 87, 176, 113, 18, 17);
        }
        if (this.tabId != 2) {
            MutableComponent tip;
            List<TileNotePC.TradeInfo> tradList = ((PhoneMenu)this.menu).tradeList.get(this.tabId);
            for (int i = 0; i < this.size; ++i) {
                TileNotePC.TradeInfo info = tradList.get(i + this.startIndex);
                tip = this.getLabel(this.format(info.price()) + "sp", GREEN);
                this.drawFont(pose, (Component)tip, 45.0f, x + 25, y + 20 + i * 17, 0xEEEEEE, false);
                this.f_96542_.m_115218_(info.stack(), x + 6, y + 14 + i * 17);
            }
            if (this.selectID != -1) {
                TileNotePC.TradeInfo info = tradList.get(this.selectID);
                boolean isOver = this.cook.getTradeSP() >= info.price();
                this.f_96542_.m_115218_(info.stack(), x + 84, y + 36);
                tip = this.getLabel(this.format(info.price() * ((PhoneMenu)this.menu).sp) + "sp", isOver ? GREEN : RED);
                this.drawFont(pose, (Component)tip, 38.0f, x + 102, y + 43, 0x333333, false);
                if (((PhoneMenu)this.menu).sp > 1) {
                    pose.m_85836_();
                    pose.m_85837_(0.0, 0.0, 200.0);
                    MutableComponent tip2 = this.getLabel(((PhoneMenu)this.menu).sp);
                    int nameSize = this.f_96547_.m_92852_((FormattedText)tip2);
                    this.f_96547_.m_92763_(pose, (Component)tip2, (float)(x + 101 - nameSize), (float)(y + 45), 0xEEEEEE);
                    pose.m_85849_();
                }
            }
        } else {
            ItemStack stack = ((PhoneMenu)this.menu).inventory.getInv().getStackInSlot(0);
            if (!stack.m_41619_()) {
                String sp = this.format(TileNotePC.getGlobalValue(1.0f, stack));
                this.f_96542_.m_115218_(stack, x + 84, y + 36);
                this.f_96547_.m_92889_(pose, (Component)this.getText("trade_sell").m_130940_(GREEN), (float)(x + 102), (float)(y + 35), 0x333333);
                MutableComponent tip = this.getLabel(sp + "sp", GREEN);
                this.drawFont(pose, (Component)tip, 38.0f, x + 102, y + 44, 0x333333, false);
            }
        }
        this.f_96542_.m_115218_(AETHER, x + 61, y + 88);
        this.f_96542_.m_115218_(ICE, x + 79, y + 88);
        this.f_96542_.m_115218_(SUGAR, x + 97, y + 88);
        this.f_96547_.m_92889_(pose, (Component)this.getText("trade_level", new Object[]{this.format(this.cook.getTradeLevel())}), (float)(x + 85), (float)(y + 14), 0x333333);
        pose.m_85836_();
        MutableComponent tip = this.getText("possess_sp", new Object[]{": " + this.format(this.cook.getTradeSP()) + "sp"});
        int spSize = this.f_96547_.m_92895_(tip.getString());
        pose.m_85841_((float)spSize < 80.0f ? 1.0f : 80.0f / (float)spSize, 1.0f, 1.0f);
        int addX = Math.max(0, spSize - 80);
        this.f_96547_.m_92889_(pose, (Component)tip, (float)(x + 85 + addX * 3), (float)(y + 22), 0x333333);
        pose.m_85849_();
        this.f_96547_.m_92763_(pose, (Component)this.getLabel("+1", WHITE), (float)(x + 85), (float)(y + 60), 0xEEEEEE);
        this.f_96547_.m_92763_(pose, (Component)this.getLabel("+10", WHITE), (float)(x + 107), (float)(y + 60), 0xEEEEEE);
        this.f_96547_.m_92763_(pose, (Component)this.getLabel("+64", WHITE), (float)(x + 135), (float)(y + 60), 0xEEEEEE);
        this.f_96547_.m_92763_(pose, (Component)this.getLabel("-1", WHITE), (float)(x + 85), (float)(y + 72), 0xEEEEEE);
        this.f_96547_.m_92763_(pose, (Component)this.getLabel("-10", WHITE), (float)(x + 107), (float)(y + 72), 0xEEEEEE);
        this.f_96547_.m_92763_(pose, (Component)this.getLabel("-64", WHITE), (float)(x + 135), (float)(y + 72), 0xEEEEEE);
        String send = this.tabId != 2 ? "trade_buy" : "trade_sale";
        this.f_96547_.m_92763_(pose, (Component)this.getText(send), (float)(x + 145), (float)(y + 40), 0xEEEEEE);
    }

    @Override
    protected void m_7027_(PoseStack pose, int mouseX, int mouseY) {
        super.m_7027_(pose, mouseX, mouseY);
        if (((PhoneMenu)this.menu).isSingle) {
            this.renderSingleLabels(pose, mouseX, mouseY);
            return;
        }
        int xAxis = mouseX - this.getWidth();
        int yAxis = mouseY - this.getHeight();
        int tipX = this.getWidth() + 5;
        int tipY = this.getHeight() + 13;
        for (int id = 0; id < this.size; ++id) {
            this.lootView[id] = false;
            if (this.isRender(tipX, tipY, mouseX, mouseY, 67, 16)) {
                this.lootView[id] = true;
            }
            tipY += 17;
        }
        tipX = this.getWidth() + 59;
        tipY = this.getHeight() + 87;
        for (int i = 0; i < 3; ++i) {
            this.tabView[i] = false;
            if (this.isRender(tipX, tipY, mouseX, mouseY, 18, 18)) {
                this.tabView[i] = true;
                this.m_96602_(pose, (Component)this.getText("phone_tab" + i), xAxis, yAxis);
            }
            tipX += 18;
        }
    }

    protected void renderSingleLabels(PoseStack pose, int mouseX, int mouseY) {
        int xAxis = mouseX - this.getWidth();
        int yAxis = mouseY - this.getHeight();
        int tipX = this.getWidth() + 5;
        int tipY = this.getHeight() + 13;
        if (this.tabId != 2) {
            List<TileNotePC.TradeInfo> tradList = ((PhoneMenu)this.menu).tradeList.get(this.tabId);
            for (int id = 0; id < this.size; ++id) {
                this.lootView[id] = false;
                if (this.isRender(tipX, tipY, mouseX, mouseY, 67, 16)) {
                    this.m_6057_(pose, tradList.get(id + this.startIndex).stack(), xAxis, yAxis);
                    this.lootView[id] = true;
                }
                tipY += 17;
            }
            tipX = this.getWidth() + 83;
            tipY = this.getHeight() + 35;
            if (this.selectID != -1 && this.isRender(tipX, tipY, mouseX, mouseY, 57, 18)) {
                TileNotePC.TradeInfo info = ((PhoneMenu)this.menu).tradeList.get(this.tabId).get(this.selectID);
                ItemStack stack = info.stack().m_41777_();
                this.m_6057_(pose, stack, xAxis, yAxis);
            }
        }
        tipX = this.getWidth() + 59;
        tipY = this.getHeight() + 87;
        for (int i = 0; i < 3; ++i) {
            this.tabView[i] = false;
            if (this.isRender(tipX, tipY, mouseX, mouseY, 18, 18)) {
                this.tabView[i] = true;
                String tip = "";
                switch (i) {
                    case 0: {
                        tip = "trade_magic";
                        break;
                    }
                    case 1: {
                        tip = "trade_drop";
                        break;
                    }
                    case 2: {
                        tip = "phone_tab2";
                    }
                }
                this.m_96602_(pose, (Component)this.getText(tip), xAxis, yAxis);
            }
            tipX += 18;
        }
    }

    @Override
    public void clickSMButton(int id) {
        if (id == 6) {
            id = this.selectID == -1 && this.tabId != 2 ? -1 : (id += this.tabId);
        }
        this.clickButton(id);
    }

    @Override
    public boolean m_6375_(double guiX, double guiY, int mouseButton) {
        int aX = this.f_97735_ + 73;
        int aY = (int)((float)(this.f_97736_ + 77) + this.scrollOffset * 60.0f);
        int w = 5;
        int h = 15;
        this.click = false;
        if (this.maxSize > 4 && guiX >= (double)aX && guiX < (double)(aX + w) && guiY >= (double)aY && guiY < (double)(aY + h)) {
            this.click = true;
        }
        aX = this.f_97735_ + 5;
        aY = this.f_97736_ + 13;
        w = 67;
        h = 16;
        for (int id = 0; id < this.size; ++id) {
            if (guiX >= (double)aX && guiX < (double)(aX + w) && guiY >= (double)aY && guiY < (double)(aY + h)) {
                if (this.selectID == id + this.startIndex) {
                    this.selectID = -1;
                    PacketHandler.sendToServer(new PhonePKT(this.player.m_20148_(), -1, false));
                } else {
                    this.selectID = id + this.startIndex;
                    if (((PhoneMenu)this.menu).isSingle) {
                        if (this.tabId != 2) {
                            int selectId = this.selectID + this.tabId * 8;
                            PacketHandler.sendToServer(new PhonePKT(this.player.m_20148_(), selectId, false));
                        }
                    } else {
                        if (this.playerList.size() <= this.selectID) {
                            return super.m_6375_(guiX, guiY, mouseButton);
                        }
                        PacketHandler.sendToServer(new PhonePKT(this.playerMap.get(this.playerList.get(this.selectID)).m_20148_(), -1, true));
                    }
                }
                this.clickButton(-1);
                break;
            }
            aY += 17;
        }
        aX = this.f_97735_ + 59;
        aY = this.f_97736_ + 89;
        w = 18;
        h = 18;
        for (int i = 0; i < 3; ++i) {
            if (guiX >= (double)aX && guiX < (double)(aX + w) && guiY >= (double)aY && guiY < (double)(aY + h)) {
                this.tabId = i;
                this.scrollOffset = 0.0f;
                this.startIndex = 0;
                this.clickButton(-1);
                if (!((PhoneMenu)this.menu).isSingle) break;
                this.selectID = -1;
                PacketHandler.sendToServer(new PhonePKT(this.player.m_20148_(), this.selectID, false));
                break;
            }
            aX += 19;
        }
        return super.m_6375_(guiX, guiY, mouseButton);
    }

    public boolean m_7979_(double mouseX, double mouseY, int mouseButton, double dragX, double dragY) {
        if (!this.scrolling && !this.click || this.maxSize <= 4) {
            return super.m_7979_(mouseX, mouseY, mouseButton, dragX, dragY);
        }
        int i = this.f_97736_ + 73;
        int j = i + 77;
        int offscreenRows = this.maxSize - 4;
        this.scrollOffset = ((float)mouseY - (float)i - 15.0f) / ((float)(j - i) - 15.0f);
        this.scrollOffset = Mth.m_14036_((float)this.scrollOffset, (float)0.0f, (float)1.0f);
        this.startIndex = (int)((double)(this.scrollOffset * (float)offscreenRows) + 0.5);
        return super.m_7979_(mouseX, mouseY, mouseButton, dragX, dragY);
    }

    public boolean m_6050_(double mouseX, double mouseY, double scrollDelta) {
        if (this.maxSize <= 4) {
            return super.m_6050_(mouseX, mouseY, scrollDelta);
        }
        int offscreenRows = this.maxSize - 4;
        this.scrollOffset = (float)((double)this.scrollOffset - scrollDelta / (double)offscreenRows);
        this.scrollOffset = Mth.m_14036_((float)this.scrollOffset, (float)0.0f, (float)1.0f);
        this.startIndex = (int)((double)(this.scrollOffset * (float)offscreenRows) + 0.5);
        return super.m_6050_(mouseX, mouseY, scrollDelta);
    }

    @Override
    protected ResourceLocation getTEX() {
        return TEX;
    }
}

