/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.tile.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import sweetmagic.SweetMagicCore;
import sweetmagic.api.iitem.IWand;
import sweetmagic.api.iitem.info.WandInfo;
import sweetmagic.init.tile.gui.GuiSMBase;
import sweetmagic.init.tile.gui.util.SMButton;
import sweetmagic.init.tile.gui.util.SMRenderTex;
import sweetmagic.init.tile.menu.ReplicaAltarMenu;
import sweetmagic.init.tile.sm.TileReplicaAltar;

public class GuiReplicaAltar
extends GuiSMBase<ReplicaAltarMenu> {
    private static final ResourceLocation TEX = SweetMagicCore.getSRC("textures/gui/gui_magia_table.png");
    private final TileReplicaAltar tile;
    private boolean[] enchaView = new boolean[4];

    public GuiReplicaAltar(ReplicaAltarMenu menu, Inventory pInv, Component title) {
        super(menu, pInv, title);
        this.setGuiSize(176, 191);
        this.tile = menu.tile;
        this.addRenderTexList(new SMRenderTex(MISC, 7, 6, 0, 0, 11, 77, new SMRenderTex.MFRenderGage(menu.tile, true)));
        SMButton.SMButtonTip buttonTip = new SMButton.SMButtonTip("", 30, 0, this.tile){

            public boolean isFlagText(TileReplicaAltar tile) {
                return tile.canCraft;
            }

            @Override
            public String getTip() {
                return this.isFlagText(GuiReplicaAltar.this.tile) ? "caraft_start" : "no_recipe";
            }
        };
        SMButton button = new SMButton(MISC, 22, 80, 114, 15, 32, 12, buttonTip){

            @Override
            public boolean isButtonRender() {
                return GuiReplicaAltar.this.tile.canCraft;
            }
        };
        this.addButtonMap(0, button);
    }

    @Override
    protected void m_7286_(PoseStack pose, float parTick, int mouseX, int mouseY) {
        ItemStack stack;
        super.m_7286_(pose, parTick, mouseX, mouseY);
        int x = this.getWidth();
        int y = this.getHeight();
        if (!this.tile.canCraft) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)MISC);
            this.m_93228_(pose, x + 22, y + 80, 20, 0, 32, 14);
        }
        if (this.tile.craftTime > 0) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.getTEX());
            int progress = this.tile.getCraftProgress(19);
            this.m_93228_(pose, x + 32, y + 27, 193, 27, 39, progress);
        }
        if (!(stack = this.tile.getInputItem()).m_41619_() && stack.m_41720_() instanceof IWand) {
            int i;
            List<ItemStack> stackList = this.tile.getRequestList(new WandInfo(stack), this.tile.hasOut());
            int count = Math.min(this.enchaView.length, stackList.size());
            for (i = 0; i < count; ++i) {
                this.m_93228_(pose, x + 98, y + 31 + i * 18, 97, 191 + (this.enchaView[i] ? 18 : 0), 53, 18);
            }
            for (i = 0; i < stackList.size(); ++i) {
                pose.m_85836_();
                ItemStack s = stackList.get(i);
                MutableComponent tip2 = this.getLabel("\u00d7" + s.m_41613_());
                this.f_96542_.m_115218_(s, x + 100, y + 32 + i * 18);
                pose.m_85837_(0.0, 0.0, 200.0);
                this.f_96547_.m_92763_(pose, (Component)tip2, (float)(x + 118), (float)(y + 39 + i * 18), 0xEEEEEE);
                pose.m_85849_();
            }
        }
    }

    @Override
    protected void m_7027_(PoseStack pose, int mouseX, int mouseY) {
        super.m_7027_(pose, mouseX, mouseY);
        int tipX = this.getWidth() + 98;
        int tipY = this.getHeight() + 31;
        ItemStack stack = this.tile.getInputItem();
        if (!stack.m_41619_() && stack.m_41720_() instanceof IWand) {
            int xAxis = mouseX - this.getWidth();
            int yAxis = mouseY - this.getHeight();
            List<ItemStack> stackList = this.tile.getRequestList(new WandInfo(stack), this.tile.hasOut());
            int count = Math.min(this.enchaView.length, stackList.size());
            for (int i = 0; i < count; ++i) {
                this.enchaView[i] = false;
                if (this.isRender(tipX, tipY, mouseX, mouseY, 53, 17)) {
                    ArrayList<Object> tipList = new ArrayList<Object>();
                    tipList.add(this.getText("request_item").m_130940_(GREEN));
                    tipList.add(stackList.get(i).m_41786_());
                    this.m_96597_(pose, tipList, xAxis, yAxis);
                    this.enchaView[i] = true;
                }
                tipY += 18;
            }
        }
    }

    @Override
    protected ResourceLocation getTEX() {
        return TEX;
    }
}

