/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.tile.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import sweetmagic.SweetMagicCore;
import sweetmagic.api.emagic.SMElement;
import sweetmagic.api.iitem.IWand;
import sweetmagic.init.tile.gui.GuiSMBase;
import sweetmagic.init.tile.gui.util.SMButton;
import sweetmagic.init.tile.gui.util.SMRenderTex;
import sweetmagic.init.tile.menu.WandReconstructMenu;
import sweetmagic.init.tile.sm.TileWandReconstruct;

public class GuiWandReconstruct
extends GuiSMBase<WandReconstructMenu> {
    private static final ResourceLocation TEX = SweetMagicCore.getSRC("textures/gui/gui_wand_reconstruct.png");
    private final TileWandReconstruct tile;
    private boolean[] lootView = new boolean[4];
    private float scrollOffset = 0.0f;
    private int startIndex = 0;
    private boolean scrolling = false;
    private int mainSelectID = -1;
    private int subSelectID = -1;
    private boolean selectFlag = false;
    private boolean isTier5 = false;

    public GuiWandReconstruct(WandReconstructMenu menu, Inventory pInv, Component title) {
        super(menu, pInv, title);
        this.setGuiSize(220, 178);
        this.tile = menu.tile;
        this.mainSelectID = this.tile.mainSelectId;
        this.subSelectID = this.tile.subSelectId;
        this.addRenderTexList(new SMRenderTex(MISC, 7, 6, 0, 0, 11, 77, new SMRenderTex.MFRenderGage(menu.tile, true)));
        SMButton.SMButtonTip buttonTip = new SMButton.SMButtonTip("", 30, 0, this.tile){

            public boolean isFlagText(TileWandReconstruct tile) {
                return tile.canCraft;
            }

            @Override
            public String getTip() {
                return this.isFlagText(GuiWandReconstruct.this.tile) ? "caraft_start" : "no_recipe";
            }
        };
        SMButton button = new SMButton(MISC, 12, 86, 114, 15, 32, 12, buttonTip){

            @Override
            public boolean isButtonRender() {
                return GuiWandReconstruct.this.tile.canCraft;
            }
        };
        this.addButtonMap(0, button);
    }

    @Override
    protected void m_7286_(PoseStack pose, float parTick, int mouseX, int mouseY) {
        Item item;
        super.m_7286_(pose, parTick, mouseX, mouseY);
        int x = this.getWidth();
        int y = this.getHeight();
        RenderSystem.m_157456_((int)0, (ResourceLocation)MISC);
        if (!this.tile.canCraft) {
            this.m_93228_(pose, x + 12, y + 86, 20, 0, 32, 14);
        }
        if (this.tile.craftTime > 0) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.getTEX());
            int progress = this.tile.getCraftProgress(27);
            this.m_93228_(pose, x + 30, y + 33, 30, 183, 57, progress);
            RenderSystem.m_157456_((int)0, (ResourceLocation)MISC);
        }
        int h = (int)(60.0f * this.scrollOffset);
        this.m_93228_(pose, x + 204, y + 9 + h, 83, 93, 8, 15);
        ItemStack stack = this.tile.getInputItem();
        if (!stack.m_41619_() && (item = stack.m_41720_()) instanceof IWand) {
            IWand wand = (IWand)item;
            this.isTier5 = wand.getWandTier() == 5;
            int count = Math.min(4, this.tile.elementList.size());
            if (this.mainSelectID != -1) {
                this.renderSlotItem(((WandReconstructMenu)this.menu).subslotList.get(0), this.tile.getRequestStack(this.mainSelectID), pose);
            }
            if (this.subSelectID != -1) {
                this.renderSlotItem(((WandReconstructMenu)this.menu).subslotList.get(1), this.tile.getRequestStack(this.subSelectID), pose);
            }
            for (int i = 0; i < count; ++i) {
                int id = i + this.startIndex;
                this.m_93228_(pose, x + 101, y + 7 + i * 20, 99, 113 + (this.lootView[i] ? 20 : 0), 101, 20);
                if (id == this.mainSelectID) {
                    this.m_93228_(pose, x + 101, y + 7 + i * 20, 99, 153, 101, 20);
                }
                if (id == this.subSelectID) {
                    this.m_93228_(pose, x + 101, y + 7 + i * 20, 99, 153, 101, 20);
                }
                this.f_96542_.m_115218_(this.tile.getRequestStack(id), x + 105, y + 9 + i * 20);
                pose.m_85836_();
                SMElement ele = this.tile.elementList.get(id);
                pose.m_85837_(0.0, 0.0, 200.0);
                this.f_96547_.m_92763_(pose, (Component)this.getText("smelement_type", new Object[]{this.enumString(ele.name()).getString()}), (float)(x + 122), (float)(y + 14 + i * 20), 0xEEEEEE);
                pose.m_85849_();
            }
        }
    }

    @Override
    protected void m_7027_(PoseStack pose, int mouseX, int mouseY) {
        Item item;
        super.m_7027_(pose, mouseX, mouseY);
        int tipX = this.getWidth() + 100;
        int tipY = this.getHeight() + 7;
        ItemStack stack = this.tile.getInputItem();
        if (!stack.m_41619_() && (item = stack.m_41720_()) instanceof IWand) {
            IWand wand = (IWand)item;
            int xAxis = mouseX - this.getWidth();
            int yAxis = mouseY - this.getHeight();
            int count = Math.min(4, this.tile.elementList.size());
            this.renderItemLabel(((WandReconstructMenu)this.menu).subslotList.get(0), this.tile.getRequestStack(this.mainSelectID), pose, mouseX, mouseY);
            this.renderItemLabel(((WandReconstructMenu)this.menu).subslotList.get(1), this.tile.getRequestStack(this.subSelectID), pose, mouseX, mouseY);
            for (int i = 0; i < count; ++i) {
                this.lootView[i] = false;
                if (this.isRender(tipX, tipY, mouseX, mouseY, 98, 19)) {
                    ArrayList tipList = new ArrayList();
                    this.m_96597_(pose, tipList, xAxis, yAxis);
                    this.lootView[i] = true;
                }
                tipY += 20;
            }
        }
    }

    @Override
    public boolean m_6375_(double guiX, double guiY, int mouseButton) {
        int aX = this.f_97735_ + 204;
        int aY = (int)((float)(this.f_97736_ + 9) + this.scrollOffset * 60.0f);
        int w = 8;
        int h = 14;
        this.scrolling = guiX >= (double)aX && guiX < (double)(aX + w) && guiY >= (double)aY && guiY < (double)(aY + h);
        aX = this.f_97735_ + 58;
        aY = this.f_97736_ + 91;
        w = 29;
        h = 12;
        if (guiX >= (double)aX && guiX < (double)(aX + w) && guiY >= (double)aY && guiY < (double)(aY + h)) {
            this.clickButton(0);
            return super.m_6375_(guiX, guiY, mouseButton);
        }
        int x = this.getWidth();
        int y = this.getHeight();
        double dX = guiX - (double)(x + 100);
        for (int id = 0; id < 4; ++id) {
            double dY = guiY - (double)(y + 7 + 20 * id);
            if (!(dX >= 0.0) || !(dX <= 98.0) || !(dY >= 0.0) || !(dY < 20.0)) continue;
            int newSelectID = id + this.startIndex;
            if (newSelectID == this.mainSelectID || newSelectID == this.subSelectID) {
                if (newSelectID == this.mainSelectID) {
                    this.mainSelectID = -1;
                    this.clickButton(this.mainSelectID + 2);
                } else {
                    this.subSelectID = -1;
                    this.clickButton(this.subSelectID + 2 + 15);
                }
                return super.m_6375_(guiX, guiY, mouseButton);
            }
            if (this.mainSelectID == -1) {
                this.selectFlag = false;
            } else if (this.subSelectID == -1 && this.isTier5) {
                this.selectFlag = true;
            }
            if (!this.selectFlag) {
                this.mainSelectID = newSelectID;
                this.clickButton(this.mainSelectID + 2);
            } else {
                this.subSelectID = newSelectID;
                this.clickButton(this.subSelectID + 2 + 15);
            }
            if (this.isTier5) {
                this.selectFlag = !this.selectFlag;
            }
            this.player.m_9236_().m_5594_(null, this.player.m_20183_(), SoundEvents.f_12490_, SoundSource.PLAYERS, 0.25f, 1.0f);
        }
        return super.m_6375_(guiX, guiY, mouseButton);
    }

    public boolean m_7979_(double mouseX, double mouseY, int mouseButton, double dragX, double dragY) {
        int size = this.tile.elementList.size();
        if (!this.scrolling) {
            return super.m_7979_(mouseX, mouseY, mouseButton, dragX, dragY);
        }
        int i = this.f_97736_ + 20;
        int j = i + 73;
        int offscreenRows = size - 4;
        this.scrollOffset = ((float)mouseY - (float)i + 5.0f) / ((float)(j - i) - 15.0f);
        this.scrollOffset = Mth.m_14036_((float)this.scrollOffset, (float)0.0f, (float)1.0f);
        this.startIndex = (int)((double)(this.scrollOffset * (float)offscreenRows) + 0.5);
        return true;
    }

    public boolean m_6050_(double mouseX, double mouseY, double scrollDelta) {
        int size = this.tile.elementList.size();
        int offscreenRows = size - 4;
        this.scrollOffset = (float)((double)this.scrollOffset - scrollDelta / (double)offscreenRows);
        this.scrollOffset = Mth.m_14036_((float)this.scrollOffset, (float)0.0f, (float)1.0f);
        this.startIndex = (int)((double)(this.scrollOffset * (float)offscreenRows) + 0.5);
        return true;
    }

    @Override
    protected ResourceLocation getTEX() {
        return TEX;
    }
}

