/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.tile.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import sweetmagic.SweetMagicCore;
import sweetmagic.init.ItemInit;
import sweetmagic.init.tile.gui.GuiSMBase;
import sweetmagic.init.tile.menu.WarpMenu;
import sweetmagic.init.tile.sm.TileWarp;

public class GuiWarp
extends GuiSMBase<WarpMenu> {
    private static final ItemStack CLERO = new ItemStack((ItemLike)ItemInit.clero_petal);
    private static final ResourceLocation TEX = SweetMagicCore.getSRC("textures/gui/gui_warp.png");
    private final TileWarp tile;
    private boolean[] buttonView = new boolean[4];

    public GuiWarp(WarpMenu menu, Inventory pInv, Component title) {
        super(menu, pInv, title);
        this.setGuiSize(173, 134);
        this.tile = menu.tile;
    }

    @Override
    protected void m_7286_(PoseStack pose, float parTick, int mouseX, int mouseY) {
        int i;
        super.m_7286_(pose, parTick, mouseX, mouseY);
        int x = this.getWidth();
        int y = this.getHeight();
        RenderSystem.m_157456_((int)0, (ResourceLocation)MISC);
        for (i = 0; i < 4; ++i) {
            if (this.tile.getInputItem(i).m_41619_()) continue;
            this.m_93228_(pose, x + 17 + i * 36, y + 31, 20, 16 + (this.buttonView[i] ? 16 : 0), 32, 14);
        }
        for (i = 0; i < 4; ++i) {
            this.renderSlotItem(((WarpMenu)this.menu).invSlot[i], CLERO, pose);
        }
    }

    @Override
    protected void m_7027_(PoseStack pose, int mouseX, int mouseY) {
        super.m_7027_(pose, mouseX, mouseY);
        int xAxis = mouseX - this.getWidth();
        int yAxis = mouseY - this.getHeight();
        int tipX = this.getWidth() + 17;
        int tipY = this.getHeight() + 31;
        for (int id = 0; id < 4; ++id) {
            this.buttonView[id] = false;
            if (this.isRender(tipX, tipY, mouseX, mouseY, 31, 11)) {
                ItemStack stack = this.tile.getInputItem(id);
                if (stack.m_41619_()) {
                    tipX += 36;
                    continue;
                }
                CompoundTag tags = stack.m_41783_();
                if (tags == null || !tags.m_128441_("pX")) {
                    tipX += 36;
                    return;
                }
                ArrayList<MutableComponent> tipList = new ArrayList<MutableComponent>();
                int x = tags.m_128451_("pX");
                int y = tags.m_128451_("pY");
                int z = tags.m_128451_("pZ");
                String dim = tags.m_128461_("dim_view");
                String pos = x + ", " + y + ", " + z;
                tipList.add(this.getTipArray(new Object[]{stack.m_41786_()}).m_130940_(GREEN));
                tipList.add(this.empty());
                tipList.add(this.getTipArray(new Object[]{this.getText("teleport_pos"), pos}).m_130940_(GOLD));
                tipList.add(this.getTipArray(new Object[]{this.getText("teleport_dim"), dim}).m_130940_(GOLD));
                tipList.add(this.empty());
                tipList.add(this.getText("teleport_action").m_130940_(GREEN));
                this.m_96597_(pose, tipList, xAxis, yAxis);
                this.buttonView[id] = true;
            }
            tipX += 36;
        }
        for (int i = 0; i < 4; ++i) {
            this.renderItemLabel(((WarpMenu)this.menu).invSlot[i], CLERO, pose, mouseX, mouseY, this.createTipList(CLERO, "slot_need"));
        }
    }

    @Override
    public boolean m_6375_(double guiX, double guiY, int mouseButton) {
        int x = this.getWidth();
        int y = this.getHeight();
        for (int i = 0; i < 4; ++i) {
            double dX = guiX - (double)(x + 17 + i * 36);
            double dY = guiY - (double)(y + 31);
            if (!(dX >= 0.0) || !(dX <= 31.0) || !(dY >= 0.0) || !(dY < 11.0)) continue;
            this.clickButton(i);
            this.m_7861_();
            this.m_7379_();
        }
        return super.m_6375_(guiX, guiY, mouseButton);
    }

    @Override
    protected ResourceLocation getTEX() {
        return TEX;
    }
}

