/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.tile.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundRenameItemPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import sweetmagic.SweetMagicCore;
import sweetmagic.handler.PacketHandler;
import sweetmagic.init.LootInit;
import sweetmagic.init.tile.gui.GuiSMBase;
import sweetmagic.init.tile.menu.WoodChestLootMenu;
import sweetmagic.init.tile.sm.TileWoodChest;
import sweetmagic.packet.WoodChestLootPKT;

public class GuiWoodChestLoot
extends GuiSMBase<WoodChestLootMenu> {
    private static final ResourceLocation TEX = SweetMagicCore.getSRC("textures/gui/gui_woodchest_loot.png");
    public final TileWoodChest tile;
    private EditBox count;
    private EditBox chance;
    private boolean[] lootView = new boolean[4];
    private float scrollOffset = 0.0f;
    private int startIndex = 0;
    private boolean scrolling = false;
    private boolean isView = false;
    private int selectID = -1;

    public GuiWoodChestLoot(WoodChestLootMenu menu, Inventory pInv, Component title) {
        super(menu, pInv, title);
        this.setGuiSize(176, 174);
        this.tile = menu.tile;
        ResourceLocation loot = this.tile.lootTable;
        if (loot == null) {
            return;
        }
        for (int i = 0; i < LootInit.lootList.size(); ++i) {
            if (!loot.equals((Object)LootInit.lootList.get(i))) continue;
            this.selectID = i;
            break;
        }
    }

    @Override
    protected void m_7286_(PoseStack pose, float parTick, int mouseX, int mouseY) {
        int id;
        super.m_7286_(pose, parTick, mouseX, mouseY);
        int x = this.getWidth();
        int y = this.getHeight();
        if (this.isView) {
            this.m_93228_(pose, x + 20, y + 70, 180, 18, 27, 12);
        }
        int h = (int)(60.0f * this.scrollOffset);
        RenderSystem.m_157456_((int)0, (ResourceLocation)MISC);
        this.m_93228_(pose, x + 160, y + 9 + h, 83, 93, 8, 15);
        int size = LootInit.lootList.size();
        for (id = 0; id < 4; ++id) {
            this.m_93228_(pose, x + 57, y + 7 + id * 20, 99, 93, 101, 20);
            if (id + this.startIndex >= size) break;
            this.m_93228_(pose, x + 57, y + 7 + id * 20, 99, 113 + (this.lootView[id] ? 20 : 0), 101, 20);
            if (id + this.startIndex != this.selectID) continue;
            this.m_93228_(pose, x + 57, y + 7 + id * 20, 99, 153, 101, 20);
        }
        this.f_96547_.m_92763_(pose, (Component)this.getText("save"), (float)(x + 25), (float)(y + 72), 0xFFFFFF);
        for (id = 0; id < 4 && id + this.startIndex < size; ++id) {
            String lootText = LootInit.lootList.get(id + this.startIndex).toString();
            String result = lootText.substring(lootText.indexOf("/") + 1);
            String tip = result.substring(result.indexOf("/") + 1);
            this.f_96547_.m_92763_(pose, (Component)this.getLabel(tip), (float)(x + 60), (float)(y + 12 + id * 20), 2868292);
        }
    }

    @Override
    protected void m_7027_(PoseStack pose, int mouseX, int mouseY) {
        super.m_7027_(pose, mouseX, mouseY);
        int tipX = this.getWidth() + 20;
        int tipY = this.getHeight() + 70;
        int xAxis = mouseX - this.getWidth();
        int yAxis = mouseY - this.getHeight();
        this.isView = this.isRender(tipX, tipY, mouseX, mouseY, 27, 12);
        tipX = this.getWidth() + 57;
        tipY = this.getWidth() - 104;
        for (int id = 0; id < 4; ++id) {
            this.lootView[id] = false;
            if (this.isRender(tipX, tipY, mouseX, mouseY, 98, 19)) {
                if (id + this.startIndex >= LootInit.lootList.size()) break;
                String loot = LootInit.lootList.get(id + this.startIndex).toString();
                this.m_96602_(pose, (Component)this.getLabel(loot.substring(loot.indexOf(":") + 1), GOLD), xAxis - 80, yAxis - 6);
                this.lootView[id] = true;
            }
            tipY += 20;
        }
    }

    @Override
    public boolean m_6375_(double guiX, double guiY, int mouseButton) {
        int aX = this.f_97735_ + 159;
        int aY = (int)((float)(this.f_97736_ + 8) + this.scrollOffset * 60.0f);
        int w = 8;
        int h = 14;
        if (guiX >= (double)aX && guiX < (double)(aX + w) && guiY >= (double)aY && guiY < (double)(aY + h)) {
            this.scrolling = true;
        }
        aX = this.f_97735_ + 20;
        aY = this.f_97736_ + 70;
        w = 27;
        h = 12;
        if (guiX >= (double)aX && guiX < (double)(aX + w) && guiY >= (double)aY && guiY < (double)(aY + h)) {
            PacketHandler.sendToServer(new WoodChestLootPKT(Integer.valueOf(this.count.m_94155_()), Float.valueOf(this.chance.m_94155_()).floatValue(), this.selectID, this.tile.m_58899_()));
            this.f_96541_.f_91074_.m_6915_();
        }
        int x = this.getWidth();
        int y = this.getHeight();
        double dX = guiX - (double)(x + 57);
        for (int id = 0; id < 4; ++id) {
            double dY = guiY - (double)(y + 7 + 20 * id);
            if (!(dX >= 0.0) || !(dX <= 95.0) || !(dY >= 0.0) || !(dY < 18.0)) continue;
            this.selectID = id + this.startIndex;
        }
        return super.m_6375_(guiX, guiY, mouseButton);
    }

    public boolean m_7979_(double mouseX, double mouseY, int mouseButton, double dragX, double dragY) {
        if (!this.scrolling) {
            return super.m_7979_(mouseX, mouseY, mouseButton, dragX, dragY);
        }
        int i = this.f_97736_ + 9;
        int j = i + 83;
        List<ResourceLocation> enchaList = LootInit.lootList;
        int offscreenRows = enchaList.size() - 4;
        this.scrollOffset = ((float)mouseY - (float)i + 5.0f) / ((float)(j - i) - 15.0f);
        this.scrollOffset = Mth.m_14036_((float)this.scrollOffset, (float)0.0f, (float)1.0f);
        this.startIndex = (int)((double)(this.scrollOffset * (float)offscreenRows) + 0.5);
        return true;
    }

    public boolean m_6050_(double mouseX, double mouseY, double scrollDelta) {
        List<ResourceLocation> enchaList = LootInit.lootList;
        int offscreenRows = enchaList.size() - 4;
        this.scrollOffset = (float)((double)this.scrollOffset - scrollDelta / (double)offscreenRows);
        this.scrollOffset = Mth.m_14036_((float)this.scrollOffset, (float)0.0f, (float)1.0f);
        this.startIndex = (int)((double)(this.scrollOffset * (float)offscreenRows) + 0.5);
        return true;
    }

    public void m_181908_() {
        super.m_181908_();
        this.count.m_94120_();
        this.chance.m_94120_();
    }

    protected void m_7856_() {
        super.m_7856_();
        this.subInit();
        this.f_96541_.f_91068_.m_90926_(true);
    }

    protected void subInit() {
        this.f_96541_.f_91068_.m_90926_(true);
        int x = this.getWidth();
        int y = this.getHeight();
        this.count = new EditBox(this.f_96547_, x + 9, y + 19, 116, 12, (Component)this.getTip("container.repair1"));
        this.count.m_94190_(false);
        this.count.m_94202_(-1);
        this.count.m_94205_(-1);
        this.count.m_94182_(false);
        this.count.m_94199_(40);
        this.count.m_94151_(this::onNameChanged);
        this.count.m_94144_("" + this.tile.count);
        this.chance = new EditBox(this.f_96547_, x + 9, y + 46, 116, 12, (Component)this.getTip("container.repair"));
        this.chance.m_94190_(false);
        this.chance.m_94202_(-1);
        this.chance.m_94205_(-1);
        this.chance.m_94182_(false);
        this.chance.m_94199_(40);
        this.chance.m_94151_(this::onNameChanged);
        this.chance.m_94144_("" + this.tile.chance);
        this.m_7787_((GuiEventListener)this.count);
        this.m_94718_((GuiEventListener)this.count);
        this.m_7522_((GuiEventListener)this.count);
        this.m_7787_((GuiEventListener)this.chance);
        this.m_94718_((GuiEventListener)this.chance);
        this.m_7522_((GuiEventListener)this.chance);
    }

    public void m_6574_(Minecraft mc, int x, int y) {
        String countString = this.count.m_94155_();
        String chanceString = this.chance.m_94155_();
        this.m_6575_(mc, x, y);
        this.count.m_94144_(countString);
        this.chance.m_94144_(chanceString);
    }

    public boolean m_7933_(int id, int par1, int par2) {
        if (id == 256) {
            this.f_96541_.f_91074_.m_6915_();
        }
        return !this.count.m_7933_(id, par1, par2) && !this.chance.m_7933_(id, par1, par2) ? super.m_7933_(id, par1, par2) : true;
    }

    private void onNameChanged(String name) {
        if (name.isEmpty()) {
            return;
        }
        String s = name;
        this.f_96541_.f_91074_.f_108617_.m_104955_((Packet)new ServerboundRenameItemPacket(s));
    }

    @Override
    public void m_6305_(PoseStack pose, int mouseX, int mouseY, float parTick) {
        super.m_6305_(pose, mouseX, mouseY, parTick);
        this.count.m_6305_(pose, mouseX, mouseY, parTick);
        this.chance.m_6305_(pose, mouseX, mouseY, parTick);
    }

    @Override
    protected ResourceLocation getTEX() {
        return TEX;
    }
}

