/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.tile.inventory;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.antlr.v4.runtime.misc.NotNull;
import sweetmagic.api.iitem.info.BaseItemInfo;

public abstract class BaseSMInventory
implements IItemHandlerModifiable {
    public ItemStack stack;
    public ItemStackHandler inv;

    public BaseSMInventory(BaseItemInfo info) {
        this.setStack(info.getStack());
    }

    public BaseSMInventory(ItemStack stack) {
        this.setStack(stack);
    }

    public ItemStackHandler getInv() {
        return this.inv;
    }

    public void setInv(ItemStackHandler inv) {
        this.inv = inv;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public void setStack(ItemStack stack) {
        this.stack = stack;
    }

    public List<ItemStack> getStackList() {
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        for (int i = 0; i < this.getInv().getSlots(); ++i) {
            ItemStack stack = this.getInv().getStackInSlot(i);
            if (stack.m_41619_()) continue;
            stackList.add(stack);
        }
        return stackList;
    }

    public List<ItemStack> getStackAllList() {
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        for (int i = 0; i < this.getInv().getSlots(); ++i) {
            stackList.add(this.getInv().getStackInSlot(i));
        }
        return stackList;
    }

    public int getSlots() {
        return this.getInv().getSlots();
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        return this.getInv().getStackInSlot(slot);
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        ItemStack ret = this.getInv().insertItem(slot, stack, simulate);
        this.writeBack();
        return ret;
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        ItemStack ret = this.getInv().extractItem(slot, amount, simulate);
        this.writeBack();
        return ret;
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        return this.getInv().isItemValid(slot, stack);
    }

    public void setStackInSlot(int slot, @NotNull ItemStack stack) {
        this.getInv().setStackInSlot(slot, stack);
        this.writeBack();
    }

    public void writeBack() {
        for (int i = 0; i < this.getInv().getSlots(); ++i) {
            if (!this.getInv().getStackInSlot(i).m_41619_()) continue;
            this.getInv().setStackInSlot(i, ItemStack.f_41583_);
        }
        this.writeToNBT(this.getTag());
    }

    public CompoundTag getTag() {
        return this.getStack().m_41784_();
    }

    public void readFromNBT(CompoundTag tags) {
        this.getInv().deserializeNBT(tags.m_128469_("Items"));
    }

    public void writeToNBT(CompoundTag tags) {
        tags.m_128365_("Items", (Tag)this.getInv().serializeNBT());
    }
}

