/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.tile.menu;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import sweetmagic.init.MenuInit;
import sweetmagic.init.tile.menu.BaseSMMenu;
import sweetmagic.init.tile.menu.container.SMCraftingContainer;
import sweetmagic.init.tile.slot.ChangeSlot;
import sweetmagic.init.tile.sm.TileAbstractSM;
import sweetmagic.init.tile.sm.TileAetherCraftTable;
import sweetmagic.util.ItemHelper;

public class AetherCraftTableMenu
extends BaseSMMenu {
    public int maxSlots = 0;
    private int offSet = 0;
    public float scrollOffset = 0.0f;
    public final TileAetherCraftTable tile;
    private final ContainerLevelAccess access;
    private final SMCraftingContainer craftSlots;
    private final ResultContainer resultSlots = new ResultContainer();
    public final NonNullList<Slot> slotList = NonNullList.m_122779_();

    public AetherCraftTableMenu(int windowId, Inventory pInv, FriendlyByteBuf data) {
        this(windowId, pInv, (TileAetherCraftTable)MenuInit.getTile(TileAetherCraftTable::new, pInv, data));
    }

    public AetherCraftTableMenu(int windowId, Inventory pInv, TileAetherCraftTable tile) {
        super(MenuInit.aetherCraftTableMenu, windowId, pInv, tile);
        this.tile = tile;
        this.access = ContainerLevelAccess.m_39289_((Level)tile.m_58904_(), (BlockPos)tile.m_58899_());
        this.addSlotInv();
        this.craftSlots = new SMCraftingContainer(this, (TileAbstractSM.StackHandler)tile.getInput());
        this.m_38897_((Slot)new ResultSlot(this.player, (CraftingContainer)this.craftSlots, (Container)this.resultSlots, 0, 133, 120));
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                this.m_38897_(new Slot((Container)this.craftSlots, x + y * 3, 45 + x * 18, 102 + y * 18));
            }
        }
        this.setPInv(pInv, 8, 159);
        this.setSlotSize(this.maxSlots + 10);
        this.access.m_39292_((par1, par2) -> this.slotChangedCraftingGrid(this, (Level)par1, this.player, this.craftSlots, this.resultSlots));
    }

    public void addSlotInv() {
        BlockPos targetPos = this.getTargetPos();
        if (targetPos == null) {
            return;
        }
        int count = 0;
        List<TileHandler> handlerList = this.getHandlerList(targetPos, true);
        for (TileHandler tileHandler : handlerList) {
            boolean isOver = false;
            IItemHandler handler = tileHandler.handler();
            for (int i = 0; i < handler.getSlots(); ++i) {
                int pY = count >= 45 ? -1000 : 8 + count / 9 * 18;
                int masStackSize = handler.getSlotLimit(i);
                if (!isOver && masStackSize > 64) {
                    isOver = true;
                }
                this.addSlots((Slot)new ChangeSlot(tileHandler, i, 8 + count % 9 * 18, pY, this, masStackSize), false);
                ++count;
            }
            if (!isOver) continue;
            tileHandler.sentPKT();
        }
        this.updateSlotPos(0);
    }

    protected Slot addSlots(Slot slot, boolean flag) {
        this.slotList.add((Object)slot);
        return flag ? slot : this.m_38897_(slot);
    }

    public BlockPos getTargetPos() {
        Iterable<BlockPos> posArray = this.tile.getRangePos(this.tile.m_58899_(), 16);
        BlockPos targetPos = null;
        for (BlockPos pos : posArray) {
            if (!this.tile.isReader(this.tile.getBlock(pos))) continue;
            targetPos = pos;
            break;
        }
        return targetPos;
    }

    public List<TileHandler> getHandlerList(BlockPos pos, boolean addSlot) {
        ArrayList<BlockEntity> tileList = new ArrayList<BlockEntity>();
        for (Direction face : Direction.values()) {
            BlockEntity tile = this.tile.m_58904_().m_7702_(pos.m_121945_(face));
            if (tile == null || tile instanceof TileAetherCraftTable || !tile.getCapability(ForgeCapabilities.ITEM_HANDLER, face).filter(IItemHandlerModifiable.class::isInstance).isPresent()) continue;
            tileList.add(tile);
        }
        ArrayList<TileHandler> handlerList = new ArrayList<TileHandler>();
        if (tileList.isEmpty()) {
            return handlerList;
        }
        int chestCount = 0;
        for (BlockEntity tile : tileList) {
            tile.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(i -> {
                if (addSlot) {
                    this.maxSlots += i.getSlots();
                }
                handlerList.add(new TileHandler(tile, (IItemHandler)i));
            });
            if (++chestCount < this.tile.getMaxViewChest()) continue;
            break;
        }
        return handlerList;
    }

    public void updateSlotPos(int offsetY) {
        this.updateSlotPos(offsetY, this.tile.getSortType());
    }

    public void updateSlotPos(int offsetY, int id) {
        this.offSet = offsetY;
        int maxY = this.maxSlots / 9;
        if (this.maxSlots % 9 != 0) {
            ++maxY;
        }
        List<Slot> slotList = this.sortSlot(id);
        this.slotList.clear();
        for (int y = 0; y < maxY; ++y) {
            for (int x = 0; x < 9; ++x) {
                if (x + y * 9 >= this.maxSlots) {
                    return;
                }
                int tX = x + (y - offsetY) * 9;
                int pX = 8 + x * 18;
                int pY = tX >= 45 || tX < 0 ? -1000 : 8 + (y - offsetY) * 18;
                ChangeSlot slot = (ChangeSlot)slotList.get(x + y * 9);
                slot.setActive(tX < 45 && tX >= 0);
                this.setSlotPos((Slot)slot, pX, pY);
                this.addSlots((Slot)slot, true);
            }
        }
    }

    public List<Slot> sortSlot(int id) {
        return switch (id) {
            case 1 -> this.sortSlotName();
            case 2 -> this.sortSlotChest();
            default -> this.sortSlotId();
        };
    }

    public List<Slot> sortSlotId() {
        ArrayList slotList = new ArrayList();
        ArrayList<Slot> slotStackList = new ArrayList<Slot>();
        ArrayList<Slot> slotEmptyList = new ArrayList<Slot>();
        for (int i = 0; i < this.maxSlots; ++i) {
            Slot slot = (Slot)this.f_38839_.get(i);
            if (slot.m_7993_().m_41619_()) {
                slotEmptyList.add(slot);
                continue;
            }
            slotStackList.add(slot);
        }
        slotList.addAll(slotStackList);
        slotList.addAll(slotEmptyList);
        return slotList.stream().sorted((s1, s2) -> ItemHelper.sortSlot(s1, s2, this.tile.getAscending())).toList();
    }

    public List<Slot> sortSlotName() {
        ArrayList slotList = new ArrayList();
        ArrayList<Slot> slotStackList = new ArrayList<Slot>();
        ArrayList<Slot> slotEmptyList = new ArrayList<Slot>();
        for (int i = 0; i < this.maxSlots; ++i) {
            Slot slot = (Slot)this.f_38839_.get(i);
            if (slot.m_7993_().m_41619_()) {
                slotEmptyList.add(slot);
                continue;
            }
            slotStackList.add(slot);
        }
        slotList.addAll(slotStackList);
        slotList.addAll(slotEmptyList);
        return slotList.stream().sorted((s1, s2) -> ItemHelper.sortName(s1, s2, this.tile.getAscending())).toList();
    }

    public List<Slot> sortSlotChest() {
        ArrayList<Slot> slotList = new ArrayList<Slot>();
        for (int i = 0; i < this.maxSlots; ++i) {
            slotList.add((Slot)this.f_38839_.get(i));
        }
        if (!this.tile.getAscending()) {
            Collections.reverse(slotList);
        }
        return slotList;
    }

    public void setSlotPos(Slot slot, int x, int y) {
        this.setSlotPos(slot, "f_40220_", x);
        this.setSlotPos(slot, "f_40221_", y);
    }

    public void setSlotPos(Slot slot, String fieldName, int newValue) {
        try {
            Field field = ObfuscationReflectionHelper.findField(Slot.class, (String)fieldName);
            field.setAccessible(true);
            field.set(slot, newValue);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public void slotsChangInv(Container con) {
        if (this.player.f_19853_.m_5776_()) {
            this.updateSlotPos(this.offSet);
        }
    }

    public boolean m_6366_(Player player, int id) {
        this.tile.clickButton();
        switch (id) {
            case 0: 
            case 1: 
            case 2: {
                this.tile.setSortType(id);
                this.updateSlotPos(0);
                this.tile.sendPKT();
                this.scrollOffset = 0.0f;
                break;
            }
            case 3: {
                this.tile.setAscending(!this.tile.getAscending());
                this.updateSlotPos(0);
                this.tile.sendPKT();
                break;
            }
            case 4: {
                this.compactInventory();
            }
        }
        return true;
    }

    public void compactInventory() {
        if (!this.tile.isSever()) {
            return;
        }
        BlockPos targetPos = this.getTargetPos();
        if (targetPos == null) {
            return;
        }
        List<TileHandler> handlerList = this.getHandlerList(targetPos, false).stream().filter(s -> s.handler() instanceof IItemHandlerModifiable).toList();
        if (handlerList.isEmpty()) {
            return;
        }
        for (int i = handlerList.size() - 2; i >= 0; --i) {
            this.compactInventoryHandler(handlerList.get(i).handler(), handlerList.get(i + 1).handler());
        }
        handlerList.forEach(h -> ItemHelper.compactInventory((IItemHandlerModifiable)h.handler()));
    }

    public int compactInventoryHandler(IItemHandler hand1, IItemHandler hand2) {
        for (int k = 0; k < hand2.getSlots(); ++k) {
            ItemStack input = hand2.getStackInSlot(k);
            if (input.m_41619_()) continue;
            for (int i = 0; i < hand1.getSlots(); ++i) {
                ItemStack inStack = hand1.insertItem(i, input.m_41777_(), false);
                input.m_41764_(inStack.m_41613_());
            }
        }
        return 0;
    }

    protected void slotChangedCraftingGrid(AbstractContainerMenu menu, Level world, Player player, CraftingContainer con, ResultContainer result) {
        CraftingRecipe recipe;
        if (world.m_5776_()) {
            return;
        }
        ServerPlayer sPlayer = (ServerPlayer)player;
        ItemStack stack = ItemStack.f_41583_;
        Optional opti = world.m_7654_().m_129894_().m_44015_(RecipeType.f_44107_, (Container)con, world);
        if (opti.isPresent() && result.m_40135_(world, sPlayer, (Recipe)(recipe = (CraftingRecipe)opti.get()))) {
            stack = recipe.m_5874_((Container)con);
        }
        result.m_6836_(0, stack);
        menu.m_150404_(0, stack);
        sPlayer.f_8906_.m_9829_((Packet)new ClientboundContainerSetSlotPacket(menu.f_38840_, menu.m_182425_(), 0, stack));
    }

    public void m_6199_(Container con) {
        this.access.m_39292_((par1, par2) -> this.slotChangedCraftingGrid(this, (Level)par1, this.player, this.craftSlots, this.resultSlots));
    }

    public void fillCraftSlotsStackedContents(StackedContents con) {
        this.craftSlots.m_5809_(con);
    }

    public void clearCraftingContent() {
        this.craftSlots.m_6211_();
        this.resultSlots.m_6211_();
    }

    public boolean recipeMatches(Recipe<? super CraftingContainer> recipe) {
        return recipe.m_5818_((Container)this.craftSlots, this.player.f_19853_);
    }

    public boolean m_5882_(ItemStack stack, Slot slot) {
        return slot.f_40218_ != this.resultSlots && super.m_5882_(stack, slot);
    }

    public int getResultSlotIndex() {
        return 0;
    }

    public int getGridWidth() {
        return this.craftSlots.m_39347_();
    }

    public int getGridHeight() {
        return this.craftSlots.m_39346_();
    }

    @Override
    public ItemStack m_7648_(Player player, int index) {
        int slotCount;
        ItemStack stack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot == null || !slot.m_6657_() || index <= this.maxSlots - 1 && this.oldIndex == index && this.tickCount == player.f_19797_) {
            return stack;
        }
        this.tickCount = player.f_19797_;
        this.oldIndex = index;
        ItemStack stack1 = slot.m_7993_();
        stack = stack1.m_41777_();
        int maxSlots = this.maxSlots;
        if (index + maxSlots == 0) {
            this.access.m_39292_((par1, par2) -> stack1.m_41720_().m_7836_(stack1, par1, player));
            if (!this.m_38903_(stack1, 10, 46, true)) {
                return ItemStack.f_41583_;
            }
            slot.m_40234_(stack1, stack);
        }
        if (index < (slotCount = this.getSlotSize()) ? !this.m_38903_(stack1, slotCount, this.f_38839_.size(), true) : !this.m_38903_(stack1, 0, slotCount - 10, false)) {
            return ItemStack.f_41583_;
        }
        if (stack1.m_41619_()) {
            slot.m_5852_(ItemStack.f_41583_);
        } else {
            slot.m_6654_();
        }
        if (stack1.m_41613_() == stack.m_41613_()) {
            return ItemStack.f_41583_;
        }
        slot.m_142406_(player, stack1);
        if (index == 0) {
            player.m_36176_(stack1, false);
        }
        return stack;
    }

    public void m_150399_(int slotId, int dragType, ClickType clickType, Player player) {
        if (slotId == -999 || this.f_38839_.size() >= slotId + 36 || slotId < 0) {
            ItemStack stack = this.m_142621_();
            if (slotId >= 0 && slotId < this.maxSlots) {
                ItemStack slotStack = ((Slot)this.f_38839_.get(slotId)).m_7993_();
                if (!stack.m_41619_() && !slotStack.m_41619_()) {
                    if (!this.insertItem(stack)) {
                        super.m_150399_(slotId, dragType, clickType, player);
                    }
                    return;
                }
            }
            super.m_150399_(slotId, dragType, clickType, player);
            return;
        }
        super.m_150399_(slotId, dragType, clickType, player);
    }

    public boolean insertItem(ItemStack input) {
        List<Slot> slotList = this.sortSlot(this.tile.getSortType());
        for (Slot slot : slotList) {
            ItemStack inStack = slot.m_150659_(input.m_41777_());
            input.m_41764_(inStack.m_41613_());
            if (!inStack.m_41619_()) continue;
            break;
        }
        return true;
    }

    protected boolean m_38903_(ItemStack stack, int slotStart, int slotEnd, boolean par1) {
        return this.moveSlot(stack, slotStart, slotEnd, par1);
    }

    @Override
    public boolean checkSlotValue(Slot slot, ItemStack stack) {
        return slot.m_5866_(stack) > 64;
    }

    public record TileHandler(BlockEntity tile, IItemHandler handler) {
        public void sentPKT() {
            Level world = this.tile.m_58904_();
            if (world == null) {
                return;
            }
            BlockPos pos = this.tile.m_58899_();
            BlockState state = world.m_8055_(pos);
            if (world.m_46805_(pos)) {
                world.m_46745_(pos).m_8092_(true);
            }
            world.m_7260_(pos, state, state, 2);
        }
    }
}

