/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.tile.menu;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.network.NetworkHooks;
import sweetmagic.init.MenuInit;
import sweetmagic.init.RecipeTypeInit;
import sweetmagic.init.tile.menu.BaseSMMenu;
import sweetmagic.init.tile.menu.container.BaseContainer;
import sweetmagic.init.tile.slot.SMSlot;
import sweetmagic.init.tile.sm.TileFurnitureTable;
import sweetmagic.util.ItemHelper;

public class FurnitureTableMenu
extends BaseSMMenu {
    public final Slot inputSlot;
    public final Slot resultSlot;
    public final TileFurnitureTable tile;
    public List<Recipe<?>> recipeList = new ArrayList();
    private Runnable slotUpdateListener = () -> {};

    public FurnitureTableMenu(int windowId, Inventory pInv, FriendlyByteBuf data) {
        this(windowId, pInv, (TileFurnitureTable)MenuInit.getTile(TileFurnitureTable::new, pInv, data));
    }

    public FurnitureTableMenu(int windowId, Inventory pInv, TileFurnitureTable tile) {
        super(MenuInit.furnitureTableMenu, windowId, pInv, tile);
        this.tile = tile;
        IItemHandler out = this.tile.getOut();
        SMSlot slot = new SMSlot(this.tile.getInput(), 0, 16, 33){

            public void m_6654_() {
                super.m_6654_();
                FurnitureTableMenu.this.slotsChangedSide(this.f_40218_);
                FurnitureTableMenu.this.m_6199_(this.f_40218_);
                FurnitureTableMenu.this.slotUpdateListener.run();
            }
        };
        for (int x = 0; x < 9; ++x) {
            SMSlot slotSide = new SMSlot(this.tile.getInputSide(), x, 8 + x * 18, 8){

                public void m_6654_() {
                    super.m_6654_();
                    FurnitureTableMenu.this.slotsChangedSide(this.f_40218_);
                    FurnitureTableMenu.this.m_6199_(this.f_40218_);
                    FurnitureTableMenu.this.slotUpdateListener.run();
                }
            };
            this.m_38897_((Slot)slotSide);
        }
        this.inputSlot = this.m_38897_((Slot)slot);
        this.resultSlot = this.m_38897_((Slot)new SMSlot(this.tile.getResult(), 0, 16, 69, s -> false));
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.m_38897_((Slot)new SMSlot(out, x + y * 9, 8 + x * 18, 113 + y * 18, s -> false));
            }
        }
        this.setPInv(pInv, 8, 171);
        this.setSlotSize(this.tile.getInvSize() + 9 + 2);
        if (!tile.isUpdate && this.tile.m_58904_().m_5776_()) {
            this.m_6199_(this.inputSlot.f_40218_);
        }
    }

    public void m_6199_(Container container) {
        ItemStack stack = this.inputSlot.m_7993_();
        this.tile.chekcSlot();
        if (stack.m_41619_()) {
            this.tile.selectId = 0;
            this.tile.isSelect = false;
            this.tile.outStack = ItemStack.f_41583_;
            this.recipeList = new ArrayList();
            this.tile.sendPKT();
            return;
        }
        if (!stack.m_150930_(this.tile.outStack.m_41720_()) || this.recipeList.isEmpty()) {
            this.setupRecipeList(container, stack);
        }
    }

    public void slotsChangedSide(Container container) {
        this.tile.insertInput();
    }

    private void setupRecipeList(Container container, final ItemStack stack) {
        this.recipeList = new ArrayList();
        if (stack.m_41619_()) {
            return;
        }
        SimpleContainer con = new SimpleContainer(1){

            public ItemStack m_8020_(int i) {
                return stack;
            }
        };
        Level world = this.tile.m_58904_();
        this.recipeList.addAll(world.m_7465_().m_44056_(RecipeType.f_44112_, (Container)con, world));
        this.recipeList.addAll(world.m_7465_().m_44056_(RecipeTypeInit.FURNITURE, (Container)con, world));
        ArrayList itemList = new ArrayList();
        this.recipeList = this.recipeList.stream().filter(s -> this.itemFilter(itemList, s.m_8043_().m_41720_())).sorted((s1, s2) -> ItemHelper.sortItemStack(s1.m_8043_(), s2.m_8043_())).toList();
    }

    public boolean itemFilter(List<Item> list, Item item) {
        if (list.contains(item)) {
            return false;
        }
        list.add(item);
        return true;
    }

    public void registerUpdateListener(Runnable run) {
        this.slotUpdateListener = run;
    }

    public boolean m_6366_(Player player, int id) {
        if (id == 0) {
            if (this.tile.isSelect) {
                this.tile.craftStart();
                this.tile.clickButton();
            }
            return true;
        }
        if (id == 1) {
            if (this.tile.isSelect && player instanceof ServerPlayer) {
                ServerPlayer sePlayer = (ServerPlayer)player;
                NetworkHooks.openScreen((ServerPlayer)sePlayer, (MenuProvider)new BaseContainer.ContainerFurnitureCraft(this.tile), (BlockPos)this.tile.m_58899_());
                this.tile.clickButton();
            }
            return true;
        }
        Level world = this.tile.m_58904_();
        if (!world.m_5776_()) {
            this.m_6199_(this.inputSlot.f_40218_);
        }
        if (id - 2 >= this.recipeList.size() || world.m_5776_()) {
            return true;
        }
        if (this.tile.selectId == id) {
            this.tile.selectId = 0;
            this.tile.isSelect = false;
            this.tile.outStack = ItemStack.f_41583_;
            this.tile.inputStack = ItemStack.f_41583_;
        } else {
            this.tile.selectId = id;
            this.tile.isSelect = true;
            this.tile.outStack = this.recipeList.get(id - 2).m_8043_().m_41777_();
            this.tile.inputStack = this.tile.getInputItem().m_41777_();
            int count = this.tile.outStack.m_41613_();
            int value = this.tile.setCount / count;
            this.tile.setCount = Math.max(value * count, count);
        }
        this.tile.isCraft = false;
        this.tile.clickButton();
        this.tile.sendPKT();
        return true;
    }
}

