/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.tile.menu;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import sweetmagic.init.MenuInit;
import sweetmagic.init.tile.menu.BaseSMMenu;
import sweetmagic.init.tile.slot.SMSlot;
import sweetmagic.init.tile.sm.TileWoodChest;
import sweetmagic.util.ItemHelper;

public class WoodChestMenu
extends BaseSMMenu {
    public final TileWoodChest tile;
    public final int data;

    public WoodChestMenu(int windowId, Inventory pInv, FriendlyByteBuf data) {
        this(windowId, pInv, (TileWoodChest)MenuInit.getTile(TileWoodChest::new, pInv, data));
    }

    public WoodChestMenu(int windowId, Inventory pInv, TileWoodChest tile) {
        super(MenuInit.woodChestMenu, windowId, pInv, tile);
        this.tile = tile;
        this.data = this.tile.getData();
        int addY = this.data == 3 ? 1 : 0;
        IItemHandler fuel = this.tile.getInput();
        for (int y = 0; y < 8; ++y) {
            for (int x = 0; x < 13; ++x) {
                this.m_38897_((Slot)new SMSlot(fuel, x + y * 13, 12 + x * 18, 5 + y * 18));
            }
        }
        this.setPInv(pInv, 48, 151 + addY, 1);
        this.setSlotSize(this.tile.getInvSize());
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        SoundEvent sound = null;
        float pitch = 0.9f;
        switch (this.data) {
            case 0: 
            case 5: 
            case 7: {
                sound = SoundEvents.f_12311_;
                break;
            }
            case 1: {
                sound = SoundEvents.f_11724_;
                break;
            }
            case 2: {
                sound = SoundEvents.f_12055_;
                break;
            }
            case 3: {
                pitch = 1.4f;
                sound = SoundEvents.f_11724_;
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 11: {
                sound = SoundEvents.f_12628_;
                break;
            }
            case 8: {
                sound = SoundEvents.f_12088_;
            }
        }
        if (sound != null) {
            this.tile.playSound(this.tile.m_58899_(), sound, 0.5f, this.rand.nextFloat() * 0.1f + pitch);
        }
    }

    public boolean m_6366_(Player player, int id) {
        switch (id) {
            case 0: {
                ItemHelper.compactInventory((IItemHandlerModifiable)this.tile.inputInv);
                this.tile.clickButton();
                break;
            }
            case 1: {
                ItemHelper.inventoryInput(player, (IItemHandlerModifiable)this.tile.inputInv);
                this.tile.clickButton();
                break;
            }
            case 2: {
                ItemHelper.inventoryOutput(player, (IItemHandlerModifiable)this.tile.inputInv);
                this.tile.clickButton();
                break;
            }
            case 3: {
                this.tile.invTrash(false);
            }
        }
        return true;
    }
}

