/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.tile.menu.container;

import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import sweetmagic.init.tile.sm.TileAbstractSM;

public class SMCraftingContainer
extends CraftingContainer {
    private boolean doNotCallUpdates;
    private final TileAbstractSM.StackHandler hand;
    private final AbstractContainerMenu menu;

    public SMCraftingContainer(AbstractContainerMenu menu, TileAbstractSM.StackHandler handl) {
        super(menu, 3, 3);
        this.hand = handl;
        this.menu = menu;
        this.doNotCallUpdates = false;
    }

    @Nonnull
    public ItemStack m_8020_(int slot) {
        this.validate(slot);
        return this.hand.getStackInSlot(slot);
    }

    public void validate(int slot) {
        if (this.isValid(slot)) {
            return;
        }
        throw new IndexOutOfBoundsException("Someone attempted to poll an outofbounds stack at slot " + slot + " report to them, NOT Crafting Station");
    }

    public boolean isValid(int slot) {
        return slot >= 0 && slot < this.m_6643_();
    }

    @Nonnull
    public ItemStack m_7407_(int slot, int count) {
        this.validate(slot);
        ItemStack stack = this.hand.extractItem(slot, count, false);
        if (!stack.m_41619_()) {
            this.onCraftMatrixChanged();
        }
        return stack;
    }

    public void m_6836_(int slot, @Nonnull ItemStack stack) {
        this.validate(slot);
        this.hand.setStackInSlot(slot, stack);
        this.onCraftMatrixChanged();
    }

    @Nonnull
    public ItemStack m_8016_(int index) {
        this.validate(index);
        ItemStack stack = this.m_8020_(index);
        if (stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        this.onCraftMatrixChanged();
        this.m_6836_(index, ItemStack.f_41583_);
        return stack;
    }

    public NonNullList<ItemStack> getStackList() {
        return this.hand.getContents();
    }

    public boolean m_7983_() {
        return IntStream.range(0, this.hand.getSlots()).allMatch(i -> this.hand.getStackInSlot(i).m_41619_());
    }

    public void m_6211_() {
    }

    public void setDoNotCallUpdates(boolean doNotCallUpdate) {
        this.doNotCallUpdates = doNotCallUpdate;
    }

    public void onCraftMatrixChanged() {
        if (!this.doNotCallUpdates) {
            this.menu.m_6199_((Container)this);
        }
    }
}

