/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.tile.sm;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Difficulty;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullLazy;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import org.jetbrains.annotations.NotNull;
import sweetmagic.api.util.ISMTip;
import sweetmagic.init.block.base.BaseFaceBlock;
import sweetmagic.init.capability.SidItemHandler;
import sweetmagic.init.capability.icap.ICapabilityResolver;
import sweetmagic.init.item.sm.SMItem;
import sweetmagic.init.tile.slot.WrappedItemHandler;
import sweetmagic.util.WorldHelper;

public abstract class TileAbstractSM
extends BlockEntity
implements MenuProvider,
ISMTip {
    public int tickTime = 0;
    public int clientTime = 0;
    public boolean changeOutput = false;
    protected Random rand = new Random();
    protected ICapabilityResolver<IItemHandler> resolver = null;
    protected static final WrappedItemHandler.WriteMode IN = WrappedItemHandler.WriteMode.IN;
    protected static final WrappedItemHandler.WriteMode IN_OUT = WrappedItemHandler.WriteMode.IN_OUT;
    protected static final WrappedItemHandler.WriteMode OUT = WrappedItemHandler.WriteMode.OUT;

    public TileAbstractSM(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public CompoundTag m_5995_() {
        return this.m_187480_();
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        CompoundTag tags = pkt.m_131708_();
        this.m_142466_(tags);
    }

    public void handleUpdateTag(CompoundTag tags) {
        this.deserializeNBT(tags);
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195642_((BlockEntity)this, BlockEntity::m_5995_);
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("tickTime", this.tickTime);
        tag.m_128379_("changeOutput", this.changeOutput);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.tickTime = tag.m_128451_("tickTime");
        this.changeOutput = tag.m_128471_("changeOutput");
    }

    public BlockState getState(BlockPos pos) {
        return this.m_58898_() ? this.m_58904_().m_8055_(pos) : Blocks.f_50016_.m_49966_();
    }

    public Block getBlock(BlockPos pos) {
        return this.getState(pos).m_60734_();
    }

    public BlockEntity getTile(BlockPos pos) {
        return this.m_58904_().m_7702_(pos);
    }

    public <T extends BlockEntity> T getTile(BlockEntityType.BlockEntitySupplier<T> tiType, BlockPos pos) {
        BlockEntity tile = this.getTile(pos);
        return (T)(tile != null ? tile : null);
    }

    public Direction getFace() {
        BlockState state = this.getState(this.m_58899_());
        return !state.m_61138_((Property)BaseFaceBlock.FACING) ? Direction.NORTH : (Direction)state.m_61143_((Property)BaseFaceBlock.FACING);
    }

    public float getRot() {
        return switch (this.getFace()) {
            case Direction.SOUTH -> 180.0f;
            case Direction.WEST -> 90.0f;
            case Direction.EAST -> 270.0f;
            default -> 0.0f;
        };
    }

    public void cycleChangeOutput() {
        this.changeOutput = !this.changeOutput;
        this.clickButton();
        this.sendInfo();
    }

    public int getMaxStackSize() {
        return 64;
    }

    public void playSound(Entity entity, SoundEvent sound, float vol, float pit) {
        this.m_58904_().m_6263_(null, entity.f_19854_, entity.f_19855_, entity.f_19856_, sound, SoundSource.BLOCKS, vol, pit);
    }

    public void playSound(BlockPos pos, SoundEvent sound, float vol, float pit) {
        this.m_58904_().m_5594_(null, pos, sound, SoundSource.BLOCKS, vol, pit);
    }

    public void playSound(Level world, BlockPos pos, SoundEvent sound, float vol, float pit) {
        world.m_5594_(null, pos, sound, SoundSource.BLOCKS, vol, pit);
    }

    protected long getTime() {
        return this.m_58904_().m_46467_();
    }

    public boolean isSever() {
        return !this.m_58904_().m_5776_();
    }

    public BlockEntity getEntity(BlockPos pos) {
        return this.m_58904_().m_7702_(pos);
    }

    public static void serverTick(Level world, BlockPos pos, BlockState state, TileAbstractSM tile) {
        tile.serverTick(world, pos, state);
    }

    public void serverTick(Level world, BlockPos pos, BlockState state) {
        ++this.tickTime;
    }

    public static void clientTick(Level world, BlockPos pos, BlockState state, TileAbstractSM tile) {
        tile.clientTick(world, pos, state);
    }

    public void clientTick(Level world, BlockPos pos, BlockState state) {
        if (this.clientTime++ >= 72000) {
            this.clientTime = 0;
        }
        if (this.tickTime++ >= 6000) {
            this.tickTime = 0;
        }
        if (this.tickTime % 20 == 0 && this.isRSStop() && this.isRSPower()) {
            this.addParticlesAroundSelf(world, this.rand, pos, (ParticleOptions)DustParticleOptions.f_123656_);
        }
    }

    protected void spawnParticleRing(ServerLevel server, ParticleOptions par, double range, BlockPos pos, double addY, double ySpeed, double moveValue) {
        double x = (double)pos.m_123341_() + 0.5;
        double y = (double)pos.m_123342_() + 1.0 + addY;
        double z = (double)pos.m_123343_() + 0.5;
        for (double degree = -range * Math.PI; degree < range * Math.PI; degree += 0.05) {
            double rate = range;
            server.m_8767_(par, x + Math.cos(degree) * rate, y, z + Math.sin(degree) * rate, 0, -Math.cos(degree) * 0.25, ySpeed, -Math.sin(degree) * 0.25, moveValue);
        }
    }

    protected void spawnParticleRing(Level world, ParticleOptions par, double range, BlockPos pos, double addY, double ySpeed, float chance) {
        double x = (double)pos.m_123341_() + 0.5;
        double y = (double)pos.m_123342_() + 1.0 + addY;
        double z = (double)pos.m_123343_() + 0.5;
        for (double degree = -range * Math.PI; degree < range * Math.PI; degree += 0.05) {
            if (chance < this.rand.nextFloat()) continue;
            double rate = range;
            world.m_7106_(par, x + Math.cos(degree) * rate, y, z + Math.sin(degree) * rate, Math.cos(degree) * 0.25 * (double)this.getRandFloat(), this.rand.nextDouble() * 0.1, Math.sin(degree) * 0.1 * (double)this.getRandFloat());
        }
    }

    protected void spawnParticleCycle(Level world, ParticleOptions par, double x, double y, double z, Direction face, double range, double angle, boolean isRevese) {
        int way = isRevese ? -1 : 1;
        world.m_7106_(par, x, y, z, (double)(face.m_122411_() * way), range, angle + (double)((float)(way * 1) * SMItem.SPEED));
    }

    protected void spawnParticleCycle(Level world, ParticleOptions par, BlockPos pos, Direction face, double range, double angle, boolean isRevese) {
        int way = isRevese ? -1 : 0;
        world.m_7106_(par, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, (double)(face.m_122411_() * way), range, angle + (double)((float)(way * 1) * SMItem.SPEED));
    }

    protected void addParticlesAroundSelf(Level world, Random rand, BlockPos pos, ParticleOptions par) {
        for (int i = 0; i < 4; ++i) {
            double x = rand.nextDouble() * 0.02;
            double y = rand.nextDouble() * 0.02;
            double z = rand.nextDouble() * 0.02;
            world.m_7106_(par, this.getRandX(pos, rand, 0.5), this.getRandY(pos, rand), this.getRandZ(pos, rand, 0.5), x, y, z);
        }
    }

    public void addParticle(ParticleOptions par, double x, double y, double z, double xS, double yS, double zS) {
        this.m_58904_().m_7106_(par, x, y, z, xS, yS, zS);
    }

    public double getRandX(BlockPos pos, Random rand, double scale) {
        return (double)pos.m_123341_() + (2.0 * rand.nextDouble() - 1.0) * scale + 0.5;
    }

    public double getRandY(BlockPos pos, Random rand) {
        return (double)pos.m_123342_() + rand.nextDouble() * 0.5 + 1.0;
    }

    public double getRandZ(BlockPos pos, Random rand, double scale) {
        return (double)pos.m_123343_() + (2.0 * rand.nextDouble() - 1.0) * scale + 0.5;
    }

    public float getRandFloat() {
        return this.rand.nextFloat() - this.rand.nextFloat();
    }

    public float getRandFloat(float rate) {
        return this.getRandFloat() * rate;
    }

    public int getProgress(int value, int nowValue, int maxValue) {
        return Math.min(value, (int)((float)value * (float)nowValue / (float)maxValue));
    }

    public CompoundTag saveStackList(CompoundTag nbt, List<ItemStack> stackList, String name) {
        if (stackList != null && !stackList.isEmpty()) {
            ListTag tagsList = new ListTag();
            for (ItemStack stack : stackList) {
                if (stack.m_41619_()) continue;
                tagsList.add((Object)stack.m_41739_(new CompoundTag()));
            }
            nbt.m_128365_(name, (Tag)tagsList);
        }
        return nbt;
    }

    public List<ItemStack> loadAllStack(CompoundTag nbt, String name) {
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        nbt.m_128437_(name, 10).forEach(t -> stackList.add(ItemStack.m_41712_((CompoundTag)this.getTag((Tag)t))));
        return stackList;
    }

    public CompoundTag saveStackListList(CompoundTag nbt, List<List<ItemStack>> stackListList, String name) {
        if (stackListList != null && !stackListList.isEmpty()) {
            ListTag tagsListList = new ListTag();
            for (List<ItemStack> stackList : stackListList) {
                ListTag tagsList = new ListTag();
                for (ItemStack stack : stackList) {
                    if (stack.m_41619_()) continue;
                    tagsList.add((Object)stack.m_41739_(new CompoundTag()));
                }
                tagsListList.add((Object)tagsList);
            }
            nbt.m_128365_(name, (Tag)tagsListList);
        }
        return nbt;
    }

    public List<List<ItemStack>> loadAllStackList(CompoundTag nbt, String name) {
        ListTag tagsListList = nbt.m_128437_(name, 9);
        ArrayList<List<ItemStack>> stackListList = new ArrayList<List<ItemStack>>();
        for (int i = 0; i < tagsListList.size(); ++i) {
            ArrayList stackList = new ArrayList();
            tagsListList.m_128744_(i).forEach(t -> stackList.add(ItemStack.m_41712_((CompoundTag)this.getTag((Tag)t))));
            stackListList.add(stackList);
        }
        return stackListList;
    }

    public CompoundTag saveFloatList(CompoundTag nbt, List<Float> floatList, String name) {
        if (floatList != null && !floatList.isEmpty()) {
            ListTag tagsList = new ListTag();
            for (Float f : floatList) {
                CompoundTag tags = new CompoundTag();
                tags.m_128350_("floatList", f.floatValue());
                tagsList.add((Object)tags);
            }
            nbt.m_128365_(name, (Tag)tagsList);
        }
        return nbt;
    }

    public List<Float> loadAllFloat(CompoundTag nbt, String name) {
        ArrayList<Float> floatList = new ArrayList<Float>();
        nbt.m_128437_(name, 10).forEach(t -> floatList.add(Float.valueOf(this.getTag((Tag)t).m_128457_("floatList"))));
        return floatList;
    }

    public CompoundTag saveIntList(CompoundTag nbt, List<Integer> intList, String name) {
        if (intList != null && !intList.isEmpty()) {
            ListTag tagsList = new ListTag();
            for (int i : intList) {
                CompoundTag tags = new CompoundTag();
                tags.m_128405_("intList", i);
                tagsList.add((Object)tags);
            }
            nbt.m_128365_(name, (Tag)tagsList);
        }
        return nbt;
    }

    public List<Integer> loadAllInt(CompoundTag nbt, String name) {
        ArrayList<Integer> intList = new ArrayList<Integer>();
        nbt.m_128437_(name, 10).forEach(t -> intList.add(this.getTag((Tag)t).m_128451_("intList")));
        return intList;
    }

    public void sendPKT() {
        Level world = this.m_58904_();
        if (world == null) {
            return;
        }
        BlockPos pos = this.m_58899_();
        BlockState state = world.m_8055_(pos);
        if (world.m_46805_(pos)) {
            world.m_46745_(pos).m_8092_(true);
        }
        world.m_7260_(pos, state, state, 2);
    }

    public int getInvSize() {
        return 0;
    }

    public CompoundTag getTag(Tag tag) {
        return (CompoundTag)tag;
    }

    public Component m_5446_() {
        return Component.m_237113_((String)"");
    }

    public void addStackList(List<ItemStack> stackList, ItemStack stack) {
        if (!stack.m_41619_()) {
            stackList.add(stack);
        }
    }

    public Iterable<BlockPos> getRangePos(BlockPos pos, int range) {
        return WorldHelper.getRangePos(pos, range);
    }

    public Iterable<BlockPos> getRangePosUnder(BlockPos pos, int range) {
        return WorldHelper.getRangePos(pos, -range, 0.0, -range, range, range, range);
    }

    public IItemHandler getItemHandler(BlockEntity tile, Direction face) {
        Optional cap = tile.getCapability(ForgeCapabilities.ITEM_HANDLER, face).resolve();
        if (cap.isPresent()) {
            return (IItemHandler)cap.get();
        }
        if (tile instanceof WorldlyContainer) {
            WorldlyContainer con = (WorldlyContainer)tile;
            return new SidedInvWrapper(con, face);
        }
        if (tile instanceof Container) {
            Container con = (Container)tile;
            return new InvWrapper(con);
        }
        return null;
    }

    public IFluidHandler getFluidHandler(BlockEntity tile, Direction face) {
        Optional cap = tile.getCapability(ForgeCapabilities.FLUID_HANDLER, face).resolve();
        return cap.isPresent() ? (IFluidHandler)cap.get() : null;
    }

    public <T extends Entity> List<T> getEntityList(Class<T> enClass, double range) {
        return WorldHelper.getEntityList(this.m_58904_(), enClass, this.getAABB(range));
    }

    public <T extends Entity> List<T> getEntityList(Class<T> enClass, Predicate<T> filter, double range) {
        return WorldHelper.getEntityList(this.m_58904_(), enClass, filter, this.getAABB(range));
    }

    public <T extends Entity> List<T> getEntityListHalf(Class<T> enClass, Predicate<T> filter, double range) {
        return WorldHelper.getEntityList(this.m_58904_(), enClass, filter, this.getAABBHalf(range));
    }

    public <T extends Entity> List<T> getEntityListUp(Class<T> enClass, Predicate<T> filter, double range) {
        return WorldHelper.getEntityList(this.m_58904_(), enClass, filter, this.getAABBUp(range));
    }

    public AABB getAABB(double range) {
        return this.getAABB(range, range, range);
    }

    public AABB getAABBHalf(double range) {
        return this.getAABB(range, Math.max(1.0, range * 0.5), range);
    }

    public AABB getAABBUp(double range) {
        BlockPos pos = this.m_58899_();
        return new AABB(WorldHelper.offset(pos, -range, 0.0, -range), WorldHelper.offset(pos, range, range, range));
    }

    public AABB getAABB(double x, double y, double z) {
        return WorldHelper.getAABB(this.m_58899_(), x, y, z);
    }

    public void clickButton() {
        this.playSound(this.m_58899_(), SoundEvents.f_12490_, 0.15f, this.rand.nextFloat() * 0.1f + 0.9f);
    }

    public boolean isAir() {
        return this.getState(this.m_58899_()).m_60795_();
    }

    public boolean isRSPower() {
        return this.m_58904_().m_46755_(this.m_58899_()) > 0;
    }

    public boolean isRSStop() {
        return false;
    }

    public boolean isPeaceful(Level world) {
        return world.m_46791_() == Difficulty.PEACEFUL;
    }

    public void addPotion(LivingEntity entity, MobEffect potion, int time, int level) {
        entity.m_7292_(new MobEffectInstance(potion, time, level, true, false));
    }

    public boolean isInfoEmpty() {
        return true;
    }

    public int getClientTime() {
        return this.clientTime;
    }

    public boolean checkAABB(Level world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        BlockState underState = world.m_8055_(pos.m_7495_());
        VoxelShape aabb = state.m_60734_().m_7947_(state, (BlockGetter)world, pos);
        VoxelShape underAABB = underState.m_60734_().m_7947_(underState, (BlockGetter)world, pos.m_7495_());
        return aabb.equals(Shapes.m_83040_()) && underAABB.equals(Shapes.m_83040_());
    }

    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
        return null;
    }

    public CompoundTag save(ItemStack stack, CompoundTag tags) {
        CompoundTag tags2;
        ResourceLocation src = Registry.f_122827_.m_7981_((Object)stack.m_41720_());
        tags.m_128359_("id", src == null ? "minecraft:air" : src.toString());
        tags.m_128405_("Count", stack.m_41613_());
        if (stack.m_41783_() != null) {
            tags.m_128365_("tag", (Tag)stack.m_41783_().m_6426_());
        }
        if ((tags2 = this.serializeCaps()) != null && !tags2.m_128456_()) {
            tags.m_128365_("ForgeCaps", (Tag)tags2);
        }
        return tags;
    }

    public ItemStack of(CompoundTag tags) {
        try {
            return this.getStack(tags);
        }
        catch (RuntimeException run) {
            return ItemStack.f_41583_;
        }
    }

    public ItemStack getStack(CompoundTag tags) {
        int count = tags.m_128451_("Count");
        Item item = (Item)Registry.f_122827_.m_7745_(new ResourceLocation(tags.m_128461_("id")));
        ItemStack stack = new ItemStack((ItemLike)item, count);
        if (tags.m_128425_("tag", 10)) {
            stack.m_41751_(tags.m_128469_("tag"));
        }
        return stack;
    }

    protected void sendInfo() {
        Level world = this.m_58904_();
        if (world == null) {
            return;
        }
        BlockPos pos = this.m_58899_();
        BlockState state = world.m_8055_(pos);
        if (world.m_46805_(pos)) {
            world.m_46745_(pos).m_8092_(true);
        }
        world.m_7260_(this.m_58899_(), state, state, 2);
    }

    public ItemStack getDropStack(ItemStack stack) {
        if (!this.isInfoEmpty()) {
            stack.m_41700_("BlockEntityTag", (Tag)this.m_187482_());
        }
        return stack;
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        if (this.resolver != null) {
            this.resolver.invalidateAll();
        }
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER && this.resolver != null) {
            return this.resolver.getCapabilityUnchecked(cap, side);
        }
        return super.getCapability(cap, side);
    }

    public NonNullLazy<IItemHandler> getHandler(IItemHandlerModifiable handler, WrappedItemHandler.WriteMode mode) {
        return () -> new WrappedItemHandler(handler, mode);
    }

    public SingleHandlerProvider createHand(IItemHandlerModifiable ... hand) {
        return new SingleHandlerProvider(hand);
    }

    protected class SingleHandlerProvider
    extends SidItemHandler {
        private final ICapabilityResolver<IItemHandler> inRes;

        protected SingleHandlerProvider(NonNullLazy<IItemHandler> hand) {
            this.inRes = this.getBasicResolver((NonNullSupplier<IItemHandler>)hand);
        }

        protected SingleHandlerProvider(IItemHandlerModifiable hand, WrappedItemHandler.WriteMode mode) {
            this.inRes = this.getBasicResolver((NonNullSupplier<IItemHandler>)this.getHandler(hand, mode));
        }

        protected SingleHandlerProvider(IItemHandlerModifiable ... hand) {
            this.inRes = this.getBasicResolver((NonNullSupplier<IItemHandler>)this.getHandlerArray(hand));
        }

        @Override
        protected ICapabilityResolver<IItemHandler> getResolver(@Nullable Direction face) {
            return this.inRes;
        }

        @Override
        public void invalidateAll() {
            this.inRes.invalidateAll();
        }
    }

    protected class InOutHandlerProvider
    extends SidItemHandler {
        private final ICapabilityResolver<IItemHandler> inRes;
        private final ICapabilityResolver<IItemHandler> outRes;

        protected InOutHandlerProvider(IItemHandlerModifiable in, IItemHandlerModifiable out) {
            this.inRes = this.getBasicResolver((NonNullSupplier<IItemHandler>)this.getHandler(in, IN));
            this.outRes = this.getBasicResolver((NonNullSupplier<IItemHandler>)this.getHandler(out, OUT));
        }

        protected InOutHandlerProvider(ICapabilityResolver<IItemHandler> in, ICapabilityResolver<IItemHandler> out) {
            this.inRes = in;
            this.outRes = out;
        }

        @Override
        protected ICapabilityResolver<IItemHandler> getResolver(@Nullable Direction face) {
            if (face == null) {
                return this.inRes;
            }
            return switch (face) {
                case Direction.DOWN -> this.outRes;
                default -> this.inRes;
            };
        }

        @Override
        public void invalidateAll() {
            this.inRes.invalidateAll();
            this.outRes.invalidateAll();
        }
    }

    public class MagiaHandler
    extends StackHandler {
        public MagiaHandler(int size) {
            super(size);
        }

        public MagiaHandler(int size, boolean isUpdate) {
            super(size, isUpdate);
        }

        public int getSlotLimit(int slot) {
            return TileAbstractSM.this.getMaxStackSize();
        }

        protected int getStackLimit(int slot, @NotNull ItemStack stack) {
            return TileAbstractSM.this.getMaxStackSize();
        }

        public CompoundTag serializeNBT() {
            ListTag nbtTagList = new ListTag();
            for (int i = 0; i < this.stacks.size(); ++i) {
                if (((ItemStack)this.stacks.get(i)).m_41619_()) continue;
                CompoundTag itemTag = new CompoundTag();
                itemTag.m_128405_("Slot", i);
                TileAbstractSM.this.save((ItemStack)this.stacks.get(i), itemTag);
                nbtTagList.add((Object)itemTag);
            }
            CompoundTag nbt = new CompoundTag();
            nbt.m_128365_("Items", (Tag)nbtTagList);
            nbt.m_128405_("Size", this.stacks.size());
            return nbt;
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.setSize(nbt.m_128425_("Size", 3) ? nbt.m_128451_("Size") : this.stacks.size());
            ListTag tagList = nbt.m_128437_("Items", 10);
            for (int i = 0; i < tagList.size(); ++i) {
                CompoundTag itemTags = tagList.m_128728_(i);
                int slot = itemTags.m_128451_("Slot");
                if (slot < 0 || slot >= this.stacks.size()) continue;
                this.stacks.set(slot, (Object)TileAbstractSM.this.of(itemTags));
            }
            this.onLoad();
        }
    }

    public class StackHandler
    extends ItemStackHandler {
        public boolean isUpdate;

        public StackHandler(int size) {
            super(size);
            this.isUpdate = false;
        }

        public StackHandler(int size, boolean isUpdate) {
            super(size);
            this.isUpdate = false;
            this.isUpdate = true;
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            TileAbstractSM.this.m_6596_();
            if (this.isUpdate) {
                TileAbstractSM.this.sendInfo();
            }
        }

        public NonNullList<ItemStack> getContents() {
            return this.stacks;
        }
    }
}

