/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.tile.sm;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import sweetmagic.init.TagInit;
import sweetmagic.init.TileInit;
import sweetmagic.init.block.magic.AetherHopper;
import sweetmagic.init.tile.menu.AetherHopperMenu;
import sweetmagic.init.tile.sm.TileAbstractSM;
import sweetmagic.init.tile.sm.TileSMMagic;
import sweetmagic.util.ItemHelper;

public class TileAetherHopper
extends TileSMMagic {
    public int maxMagiaFlux = 20000;
    public final TileAbstractSM.StackHandler inputInv = new TileAbstractSM.StackHandler(this.getInvSize());
    protected final TileAbstractSM.StackHandler wandInv = new TileAbstractSM.StackHandler(this.getInvSize());

    public TileAetherHopper(BlockPos pos, BlockState state) {
        this(TileInit.aetherHopper, pos, state);
    }

    public TileAetherHopper(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.resolver = (TileAbstractSM)this.new TileAbstractSM.SingleHandlerProvider((IItemHandlerModifiable)this.inputInv, IN_OUT);
    }

    @Override
    public void serverTick(Level world, BlockPos pos, BlockState state) {
        super.serverTick(world, pos, state);
        if (this.tickTime % 40 != 0 || this.isRSPower()) {
            return;
        }
        this.tickTime = 0;
        this.suctionItem(pos);
        this.extractItem(pos);
        if (!this.isMFEmpty()) {
            this.setHopperItem(world, pos);
        }
    }

    public void extractItem(BlockPos pos) {
        BlockEntity tile = this.getTile(pos.m_121945_(this.getFace()));
        if (tile == null) {
            return;
        }
        IItemHandler handler = this.getItemHandler(tile, this.getFaceReverse());
        if (handler == null) {
            return;
        }
        block0: for (int h = 0; h < this.getInvSize(); ++h) {
            ItemStack input = this.getInputItem(h);
            if (input.m_41619_()) continue;
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack inStack = handler.insertItem(i, input.m_41777_(), false);
                input.m_41764_(inStack.m_41613_());
                if (inStack.m_41619_()) continue block0;
            }
        }
    }

    public void suctionItem(BlockPos pos) {
        Direction face = this.getFace() == Direction.UP ? Direction.DOWN : Direction.UP;
        BlockEntity tile = this.getTile(pos.m_121945_(face));
        if (tile == null) {
            return;
        }
        IItemHandler handler = this.getItemHandler(tile, this.getFace() == Direction.UP ? Direction.UP : Direction.DOWN);
        if (handler == null) {
            return;
        }
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack output = handler.getStackInSlot(i);
            if (output.m_41619_()) continue;
            ItemStack stack = ItemHelper.insertStack(this.getInput(), output.m_41777_(), false);
            output.m_41764_(stack.m_41613_());
        }
    }

    public void setHopperItem(Level world, BlockPos pos) {
        int z;
        int y;
        ItemStack stack = this.getWandItem();
        if (stack.m_41619_()) {
            return;
        }
        CompoundTag tag = stack.m_41783_();
        if (tag == null || !tag.m_128441_("X")) {
            return;
        }
        int x = tag.m_128451_("X");
        BlockPos targetPos = new BlockPos(x, y = tag.m_128451_("Y"), z = tag.m_128451_("Z"));
        if (!this.getState(targetPos).m_204336_(TagInit.AETHER_HOPPER)) {
            return;
        }
        IItemHandler handler = this.getItemHandler(this.getTile(targetPos), Direction.UP);
        if (handler == null) {
            return;
        }
        int sumMF = 0;
        int mf = this.getMF();
        block0: for (int h = 0; h < this.getInvSize(); ++h) {
            ItemStack input = this.getInputItem(h);
            if (input.m_41619_()) continue;
            if (mf - sumMF < input.m_41613_()) {
                return;
            }
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack inStack = handler.insertItem(i, input.m_41777_(), false);
                input.m_41764_(inStack.m_41613_());
                if (!inStack.m_41619_()) continue;
                sumMF += input.m_41613_();
                continue block0;
            }
        }
        if (sumMF > 0) {
            this.setMF(mf - sumMF);
            this.sendPKT();
        }
    }

    @Override
    public int getInvSize() {
        return 24;
    }

    @Override
    public int getMaxMF() {
        return this.maxMagiaFlux;
    }

    @Override
    public IItemHandler getInput() {
        return this.inputInv;
    }

    public ItemStack getInputItem(int i) {
        return this.getInput().getStackInSlot(i);
    }

    public IItemHandler getWand() {
        return this.wandInv;
    }

    public ItemStack getWandItem() {
        return this.getWand().getStackInSlot(0);
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("inputInv", (Tag)this.inputInv.serializeNBT());
        tag.m_128365_("wandInv", (Tag)this.wandInv.serializeNBT());
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.inputInv.deserializeNBT(tag.m_128469_("inputInv"));
        this.wandInv.deserializeNBT(tag.m_128469_("wandInv"));
    }

    @Override
    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
        return new AetherHopperMenu(windowId, inv, this);
    }

    @Override
    public Direction getFace() {
        return (Direction)this.getState(this.m_58899_()).m_61143_((Property)AetherHopper.FACING);
    }

    public Direction getFaceReverse() {
        return switch ((Direction)this.getState(this.m_58899_()).m_61143_((Property)AetherHopper.FACING)) {
            case Direction.NORTH -> Direction.SOUTH;
            case Direction.SOUTH -> Direction.NORTH;
            case Direction.WEST -> Direction.EAST;
            case Direction.EAST -> Direction.WEST;
            case Direction.UP -> Direction.UP;
            case Direction.DOWN -> Direction.UP;
            default -> Direction.NORTH;
        };
    }

    @Override
    public boolean isRSStop() {
        return true;
    }

    public List<ItemStack> getInputList() {
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        for (int i = 0; i < this.getInvSize(); ++i) {
            stackList.add(this.getInputItem(i));
        }
        return stackList;
    }

    public List<ItemStack> getInvList() {
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        for (int i = 0; i < this.getInvSize(); ++i) {
            this.addStackList(stackList, this.getInputItem(i));
        }
        this.addStackList(stackList, this.getWandItem());
        return stackList;
    }

    @Override
    public boolean isInfoEmpty() {
        return this.getInvList().isEmpty() && this.isMFEmpty();
    }
}

