/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.tile.sm;

import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import sweetmagic.init.BlockInit;
import sweetmagic.init.TagInit;
import sweetmagic.init.TileInit;
import sweetmagic.init.tile.sm.TilePedalCreate;
import sweetmagic.util.WorldHelper;

public class TileAltarCreatStar
extends TilePedalCreate {
    public int maxMagiaFlux = 2000000;
    public boolean isRangeBlock = false;

    public TileAltarCreatStar(BlockPos pos, BlockState state) {
        super(TileInit.altarCreatStar, pos, state);
    }

    public TileAltarCreatStar(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void clientTick(Level world, BlockPos pos, BlockState state) {
        super.clientTick(world, pos, state);
        if (this.tickTime % 20 != 0) {
            return;
        }
        this.isHaveBlock = this.getState(pos.m_7495_()).m_204336_(TagInit.PC_BLOCK);
        this.isRangeBlock = this.checkRangeBlock(false);
        if (!this.isCraft || this.nowTick > (this.maxCrafttime - 1) * 20) {
            return;
        }
        float addY = (float)this.nowTick * 0.00575f * (this.quickCraft ? 2.0f : 1.0f);
        this.spawnParticleRing(world, (float)pos.m_123341_() + 0.5f, (float)pos.m_123342_() + 1.4f + addY, (float)pos.m_123343_() + 0.5f, 0.0, 0.0, 0.0, 0.75);
    }

    @Override
    public MutableComponent checkCanCraft(List<ItemStack> stackList) {
        if (!this.checkRangeBlock(false)) {
            return this.getTipArray(new Object[]{this.getText("pedastal_norangeblock"), ":", this.getRangeBlock().m_49954_().m_130940_(RED), this.getText("or"), this.getOverRangeBlock().m_49954_().m_130940_(RED)});
        }
        return super.checkCanCraft(stackList);
    }

    public boolean checkRangeBlock(boolean isClient) {
        BlockPos pos = this.m_58899_().m_7495_();
        List<BlockPos> dcPosList = Arrays.asList(pos.m_122012_(), pos.m_122019_(), pos.m_122029_(), pos.m_122024_());
        List<BlockPos> acPosList = Arrays.asList(pos.m_122013_(2), pos.m_122020_(2), pos.m_122030_(2), pos.m_122025_(2), WorldHelper.offset(pos, -1.0, 0.0, -1.0), WorldHelper.offset(pos, 1.0, 0.0, -1.0), WorldHelper.offset(pos, -1.0, 0.0, 1.0), WorldHelper.offset(pos, 1.0, 0.0, 1.0));
        for (BlockPos p : dcPosList) {
            if (this.getState(p).m_204336_(TagInit.DC_BLOCK)) continue;
            return false;
        }
        for (BlockPos p : acPosList) {
            if (this.getState(p).m_204336_(TagInit.AC_BLOCK)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Block getNeedBlock() {
        return BlockInit.purecrystal_block;
    }

    public Block getRangeBlock() {
        return BlockInit.divinecrystal_block;
    }

    public Block getOverRangeBlock() {
        return BlockInit.aethercrystal_block;
    }

    @Override
    public int getMaxMF() {
        return this.maxMagiaFlux;
    }

    @Override
    public int getReceiveMF() {
        return 80000;
    }
}

