/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.tile.sm;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.DropperBlockEntity;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import sweetmagic.api.SweetMagicAPI;
import sweetmagic.api.iblock.ISMCrop;
import sweetmagic.api.iblock.ITileFluid;
import sweetmagic.init.TileInit;
import sweetmagic.init.block.magic.AquariumPot;
import sweetmagic.init.fluid.FluidTankHandler;
import sweetmagic.init.tile.menu.AquariumPotMenu;
import sweetmagic.init.tile.sm.TileAbstractSM;
import sweetmagic.init.tile.sm.TileSMMagic;
import sweetmagic.util.WorldHelper;

public class TileAquariumPot
extends TileSMMagic
implements ITileFluid {
    public int maxMagiaFlux = 500000;
    public boolean isReceive = false;
    private int stackCount = 1;
    public static final int MAX_STACKCOUNT = 8;
    private ItemStack stack = ItemStack.f_41583_;
    private Direction face = Direction.NORTH;
    private static final Direction[] ALLFACE = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
    private static final int MAX_FLUID_VALUE = 64000;
    public FluidStack fluid = new FluidStack(Fluids.f_76191_, 0);
    protected final FluidTankHandler.TankProperty fluidPro;
    public LazyOptional<IFluidHandler> fluidHandler = LazyOptional.of(() -> this.createFluidHandler());
    protected final TileAbstractSM.StackHandler inputInv = new TileAbstractSM.StackHandler(1);

    public TileAquariumPot(BlockPos pos, BlockState state) {
        this(TileInit.aquariumpot, pos, state);
    }

    public TileAquariumPot(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.resolver = (TileAbstractSM)this.new TileAbstractSM.SingleHandlerProvider((IItemHandlerModifiable)this.inputInv, IN);
        this.fluidPro = new FluidTankHandler.TankProperty(64000, true, false, f -> f.m_6212_((Fluid)Fluids.f_76195_));
    }

    @Override
    public void serverTick(Level world, BlockPos pos, BlockState state) {
        ItemStack stack;
        super.serverTick(world, pos, state);
        this.onUpdate(world, pos, false);
        if (this.tickTime % 20 == 0 && !this.isMaxStackCount() && !(stack = this.getInputItem()).m_41619_() && stack.m_150930_(this.getStack().m_41720_())) {
            this.addStackCount(stack);
        }
        if (this.tickTime % 600 == 0) {
            this.tickTime = 0;
        }
    }

    @Override
    public void clientTick(Level world, BlockPos pos, BlockState state) {
        super.clientTick(world, pos, state);
        this.onUpdate(world, pos, true);
        if (this.tickTime % 200 == 0) {
            this.tickTime = 0;
        }
    }

    public void onUpdate(Level world, BlockPos pos, boolean isClient) {
        if (this.isMaxMF() || isClient) {
            return;
        }
        switch (this.getData(pos)) {
            case 0: {
                this.dmPot(world, pos, isClient);
                break;
            }
            case 2: {
                this.snodDropPot(world, pos, isClient);
                break;
            }
            case 3: {
                this.turkeyBalloonPot(world, pos, isClient);
                break;
            }
            case 4: {
                this.ultramarineRosePot(world, pos, isClient);
                break;
            }
            case 5: {
                this.solidStarPot(world, pos, isClient);
                break;
            }
            case 6: {
                this.zinniaPot(world, pos, isClient);
                break;
            }
            case 7: {
                this.hydoraPot(world, pos, isClient);
                break;
            }
            case 8: {
                this.carnationPot(world, pos, isClient);
                break;
            }
            case 9: {
                this.ericsPot(world, pos, isClient);
                break;
            }
            case 10: {
                this.cosmosPot(world, pos, isClient);
            }
        }
    }

    public void addStackCount(ItemStack stack) {
        this.setStackCount(this.getStackCount() + 1);
        CompoundTag tags = stack.m_41783_();
        if (tags != null) {
            this.setMF(this.getMF() + tags.m_128451_("mf"));
        }
        this.sentClient();
        stack.m_41774_(1);
    }

    public void dmPot(Level world, BlockPos pos, boolean isClient) {
        if (world.m_46471_()) {
            if (this.tickTime % 20 == 0 && !isClient) {
                this.setMF(this.getMF() + 25 * this.getStackCount());
                this.sentClient();
            } else if (this.tickTime % 100 == 0 && isClient) {
                this.spawnParticles(world, pos);
            }
        }
        if (this.tickTime % 100 == 0 && world.m_46470_()) {
            LevelData levelData;
            ResourceKey overWorld = Level.f_46428_;
            MinecraftServer mcServer = world.m_7654_();
            if (overWorld == null || mcServer == null) {
                return;
            }
            ServerLevel server = mcServer.m_129880_(overWorld);
            if (server != null && (levelData = server.m_6106_()) instanceof ServerLevelData) {
                ServerLevelData worldInfo = (ServerLevelData)levelData;
                worldInfo.m_6398_(0);
                worldInfo.m_5557_(false);
                this.setMF(this.getMF() + 6250 * this.getStackCount());
                this.sentClient();
            }
        }
    }

    public void snodDropPot(Level world, BlockPos pos, boolean isClient) {
        if (((Biome)world.m_204166_(pos).get()).m_47554_() > 0.0f && pos.m_123342_() < 120) {
            return;
        }
        if (this.tickTime % 20 == 0 && !isClient) {
            this.setMF(this.getMF() + 15 * this.getStackCount());
            this.sentClient();
        }
        if (this.tickTime % 100 == 0 && isClient) {
            this.spawnParticles(world, pos);
        }
    }

    public void turkeyBalloonPot(Level world, BlockPos pos, boolean isClient) {
        if (this.tickTime % 10 != 0) {
            return;
        }
        List<ExperienceOrb> expList = this.getEntityList(ExperienceOrb.class, 16.0).stream().filter(e -> e.m_20801_() > 0).toList();
        int sumXP = 0;
        for (ExperienceOrb entity : expList) {
            sumXP += entity.m_20801_();
            entity.m_146870_();
        }
        this.setMF(this.getMF() + sumXP * (8 + this.getStackCount()));
        this.sendInfo();
    }

    public void ultramarineRosePot(Level world, BlockPos pos, boolean isClient) {
        if (this.tickTime % 600 != 0) {
            return;
        }
        BlockEntity tile = this.getTile(pos.m_7495_());
        if (tile == null || tile instanceof HopperBlockEntity || tile instanceof DropperBlockEntity) {
            return;
        }
        IItemHandler handler = this.getItemHandler(tile, Direction.UP);
        if (handler == null) {
            return;
        }
        int sumMF = 0;
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack inStack = handler.extractItem(i, Integer.MAX_VALUE, false);
            if (inStack.m_41619_()) continue;
            sumMF = SweetMagicAPI.hasMF(inStack.m_41720_()) ? (sumMF += SweetMagicAPI.getMF(inStack) * inStack.m_41613_()) : (sumMF += (2 + this.getStackCount()) * inStack.m_41613_());
            inStack.m_41774_(inStack.m_41613_());
        }
        if (sumMF > 0) {
            this.setMF(this.getMF() + sumMF);
            this.sendPKT();
            this.playSound(pos, SoundEvents.f_12331_, 0.35f, 1.0f);
        }
    }

    public void zinniaPot(Level world, BlockPos pos, boolean isClient) {
        if (this.tickTime % 40 != 0) {
            return;
        }
        boolean isCharge = false;
        float sumLightValue = 0.0f;
        for (int x = -2; x <= 2; ++x) {
            for (int z = -2; z <= 2; ++z) {
                if (x > -2 && x < 2 && z == -1) {
                    z = 2;
                }
                for (int y = 0; y <= 1; ++y) {
                    float power;
                    BlockState state = this.getState(WorldHelper.offset(pos, x, y, z));
                    Block block = state.m_60734_();
                    if (block == Blocks.f_50016_ || (power = (float)block.getLightEmission(state, (BlockGetter)world, pos) * 0.5f) <= 0.0f) continue;
                    if (!this.getState(WorldHelper.offset(pos, x / 2, 0.0, z / 2)).m_60795_()) {
                        return;
                    }
                    isCharge = true;
                    sumLightValue += power;
                }
            }
        }
        if (isCharge) {
            if (!isClient) {
                int stackCount = this.getStackCount();
                this.setMF(this.getMF() + (int)(sumLightValue * (0.75f + (float)stackCount * 0.25f)));
                this.sentClient();
            } else {
                this.spawnParticles(world, pos);
            }
        }
    }

    public void solidStarPot(Level world, BlockPos pos, boolean isClient) {
        if (this.tickTime % 40 != 0) {
            return;
        }
        float sumLightValue = 0.0f;
        for (int x = -2; x <= 2; ++x) {
            for (int z = -2; z <= 2; ++z) {
                if (x == 0 && z == 0) continue;
                if (x > -2 && x < 2 && z == -1) {
                    z = 2;
                }
                for (int y = 0; y <= 1; ++y) {
                    BlockPos p = WorldHelper.offset(pos, x, y, z);
                    BlockState state = this.getState(p);
                    sumLightValue += state.m_60734_().getEnchantPowerBonus(state, (LevelReader)world, p) * 1.5f;
                }
            }
        }
        if (sumLightValue > 0.0f) {
            if (!isClient) {
                int stackCount = this.getStackCount();
                this.setMF(this.getMF() + (int)(sumLightValue * (0.75f + (float)stackCount * 0.25f)));
                this.sentClient();
            } else {
                this.spawnParticles(world, pos);
            }
        }
    }

    public void hydoraPot(Level world, BlockPos pos, boolean isClient) {
        if (this.tickTime % 10 != 0) {
            return;
        }
        List<Monster> entityList = this.getEntityList(Monster.class, 16.0).stream().filter(t -> !t.m_6084_()).toList();
        if (entityList.isEmpty()) {
            return;
        }
        int sumMF = 0;
        for (Monster entity : entityList) {
            CompoundTag tags = entity.getPersistentData();
            if (tags == null || tags.m_128471_("isSMDeadAquarium")) continue;
            tags.m_128379_("isSMDeadAquarium", true);
            entity.m_7380_(tags);
            sumMF = (int)((float)sumMF + entity.m_21233_() * 20.0f * (float)this.getStackCount());
        }
        if (sumMF > 0) {
            if (!isClient) {
                this.setMF(this.getMF() + sumMF);
                this.sentClient();
            } else {
                this.spawnParticles(world, pos);
            }
        }
    }

    public void carnationPot(Level world, BlockPos pos, boolean isClient) {
        if (this.tickTime % 20 != 0) {
            return;
        }
        Iterable<BlockPos> posList = WorldHelper.getRangePos(pos, -1.0, 0.0, -1.0, 1.0, 0.0, 1.0);
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        for (BlockPos p : posList) {
            ISMCrop crop;
            BlockState state;
            Block block;
            if (p.m_123341_() == 0 && p.m_123343_() == 0 || !((block = (state = this.getState(p)).m_60734_()) instanceof ISMCrop) || !(crop = (ISMCrop)block).isMaxAge(state) || !SweetMagicAPI.hasMF(crop.getCrop().m_5456_())) continue;
            stackList.addAll(crop.rightClickStack(world, state, p));
        }
        if (!stackList.isEmpty()) {
            if (!isClient) {
                int sumMF = 0;
                int stackCount = this.getStackCount();
                for (ItemStack stack : stackList) {
                    sumMF = (int)((float)sumMF + (float)SweetMagicAPI.getMF(stack) * 2.0f * (float)stackCount);
                }
                this.setMF(this.getMF() + sumMF);
                this.sendPKT();
                this.playSound(pos, SoundEvents.f_11991_, 0.25f, 0.8f + this.rand.nextFloat() * 0.4f);
            } else {
                this.spawnParticles(world, pos);
            }
        }
    }

    public void ericsPot(Level world, BlockPos pos, boolean isClient) {
        if (this.getTime() % 7L != 0L) {
            return;
        }
        BlockPos p = pos.m_121945_(this.face);
        Block block = this.getBlock(p);
        if (block instanceof SnowLayerBlock) {
            if (!isClient) {
                this.m_58904_().m_46961_(p, false);
                this.m_58904_().m_7471_(p, false);
                this.setMF(this.getMF() + 40 * this.getStackCount());
                this.sentClient();
            } else {
                this.spawnParticles(world, pos);
            }
        }
        this.face = this.face.m_122427_();
    }

    public void cosmosPot(Level world, BlockPos pos, boolean isClient) {
        if (this.tickTime % 40 != 0) {
            return;
        }
        int sumMF = 0;
        for (Direction face : ALLFACE) {
            BlockPos p = pos.m_121945_(face);
            BlockState state = this.getState(p);
            Block block = state.m_60734_();
            if (!state.m_60713_(Blocks.f_49991_) && !(block instanceof BaseFireBlock)) continue;
            if (block instanceof LiquidBlock) {
                LiquidBlock liq = (LiquidBlock)block;
                if ((Integer)state.m_61143_((Property)LiquidBlock.f_54688_) != 0) continue;
            }
            sumMF += state.m_60713_(Blocks.f_49991_) ? 8000 : 400;
            world.m_7731_(p, Blocks.f_50016_.m_49966_(), 3);
            this.playSound(p, SoundEvents.f_11937_, 1.0f, 1.0f);
        }
        if (!this.getContent().isEmpty() && this.getFluidValue() > 0) {
            int value = Math.min(1000, this.getFluidValue());
            sumMF += value * 2;
            this.getContent().shrink(value);
        }
        if (sumMF > 0) {
            if (!isClient) {
                int stackCount = this.getStackCount();
                this.setMF(this.getMF() + sumMF * stackCount);
                this.sendPKT();
            } else {
                this.spawnParticles(world, pos);
            }
        }
    }

    public int getData(BlockPos pos) {
        int n;
        Block block = this.getBlock(pos);
        if (block instanceof AquariumPot) {
            AquariumPot pot = (AquariumPot)block;
            n = pot.getData();
        } else {
            n = 0;
        }
        return n;
    }

    public ItemStack getStack() {
        return this.stack.m_41619_() ? ((AquariumPot)this.getBlock(this.m_58899_())).getStack() : this.stack;
    }

    @Override
    public int getMaxMF() {
        return this.maxMagiaFlux;
    }

    @Override
    public boolean getReceive() {
        return this.isReceive;
    }

    public void spawnParticles(Level world, BlockPos pos) {
        Random rand = this.rand;
        SimpleParticleType par = ParticleTypes.f_123748_;
        for (int i = 0; i < 4; ++i) {
            double x = rand.nextGaussian() * 0.02;
            double y = rand.nextGaussian() * 0.02;
            double z = rand.nextGaussian() * 0.02;
            world.m_7106_((ParticleOptions)par, (double)((float)pos.m_123341_() + 0.5f + this.getRandFloat(0.5f)), (double)((float)pos.m_123342_() + 0.5f + this.getRandFloat(0.5f)), (double)((float)pos.m_123343_() + 0.5f + this.getRandFloat(0.5f)), x, y, z);
        }
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("inputInv", (Tag)this.inputInv.serializeNBT());
        tag.m_128405_("stackCount", this.getStackCount());
        CompoundTag fluidNBT = new CompoundTag();
        this.getContent().writeToNBT(fluidNBT);
        tag.m_128365_("fluid", (Tag)fluidNBT);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.inputInv.deserializeNBT(tag.m_128469_("inputInv"));
        this.setStackCount(tag.m_128451_("stackCount"));
        this.setContent(FluidStack.loadFluidStackFromNBT((CompoundTag)tag.m_128469_("fluid")));
    }

    public int getStackCount() {
        return this.stackCount;
    }

    public void setStackCount(int stackCount) {
        this.stackCount = stackCount;
    }

    public boolean isMaxStackCount() {
        return this.getStackCount() >= 8;
    }

    @Override
    public IItemHandler getInput() {
        return this.inputInv;
    }

    public ItemStack getInputItem() {
        return this.getInput().getStackInSlot(0);
    }

    public int getProgress(int value) {
        return this.getProgress(value, this.getStackCount(), 8);
    }

    @Override
    public int fluidTanks() {
        return 1;
    }

    @Override
    public IFluidHandler createFluidHandler() {
        return new FluidTankHandler(this);
    }

    @Override
    public void setContent(FluidStack fluid) {
        this.fluid = fluid;
        this.m_6596_();
    }

    @Override
    public FluidTankHandler.TankProperty getTank() {
        return this.fluidPro;
    }

    @Override
    public FluidStack getContent() {
        return this.fluid;
    }

    @Override
    public void setAmount(int amount) {
        this.fluid.setAmount(amount);
    }

    @Override
    public int getFluidValue() {
        return this.getContent().getAmount();
    }

    @Override
    public void sendData() {
        this.sendInfo();
    }

    public LazyOptional<IFluidHandler> getFluidHandler() {
        return this.fluidHandler;
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction face) {
        if (cap == ForgeCapabilities.FLUID_HANDLER && this.getData(this.m_58899_()) == 10) {
            return this.getFluidHandler();
        }
        return super.getCapability(cap, face);
    }

    public void m_7651_() {
        super.m_7651_();
        if (this.getFluidHandler() != null) {
            this.getFluidHandler().invalidate();
        }
    }

    @Override
    public int getMaxFuildValue() {
        return 64000;
    }

    @Override
    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
        return new AquariumPotMenu(windowId, inv, this);
    }

    @Override
    public boolean isInfoEmpty() {
        return this.isMFEmpty() && this.getInputItem().m_41619_() && this.getStackCount() <= 1;
    }
}

