/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.tile.sm;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import sweetmagic.init.TileInit;
import sweetmagic.init.tile.sm.TileAbstractSMCook;
import sweetmagic.recipe.bottle.BottleRecipe;

public class TileBottle
extends TileAbstractSMCook {
    private static final int MAX_CRAFT_TIME = 8;
    public int craftTime = 0;
    public int amount = 0;
    public boolean isCraft = false;
    public boolean isFinish = false;
    public List<ItemStack> craftList = new ArrayList<ItemStack>();
    public List<ItemStack> resultList = new ArrayList<ItemStack>();

    public TileBottle(BlockPos pos, BlockState state) {
        super(TileInit.bottle, pos, state);
    }

    public TileBottle(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void serverTick(Level world, BlockPos pos, BlockState state) {
        super.serverTick(world, pos, state);
        if (this.tickTime % 10 != 0) {
            return;
        }
        this.tickTime = 0;
        this.m_6596_();
        if (!this.isCraft) {
            return;
        }
        this.addCookTime();
        if (this.isFinishCook()) {
            this.craftFinish();
        }
    }

    @Override
    public void clientTick(Level world, BlockPos pos, BlockState state) {
        super.clientTick(world, pos, state);
        if (this.tickTime % 10 != 0 || !this.isFinish && !this.isCook()) {
            return;
        }
        if (this.isFinish) {
            for (int i = 0; i < 8; ++i) {
                this.spawnParticle(world, pos);
            }
            this.isFinish = false;
            this.sendPKT();
        } else {
            this.spawnParticle(world, pos);
        }
    }

    public void spawnParticle(Level world, BlockPos pos) {
        double x = (double)pos.m_123341_() + 0.8 - this.rand.nextDouble() * 0.6;
        double y = (double)pos.m_123342_() + 0.9 + this.rand.nextDouble() * 0.15;
        double z = (double)pos.m_123343_() + 0.8 - this.rand.nextDouble() * 0.6;
        world.m_6485_((ParticleOptions)ParticleTypes.f_123759_, true, x, y, z, 0.0, 0.0, 0.0);
    }

    @Override
    public boolean checkRecipe() {
        return !BottleRecipe.getRecipe(this.m_58904_(), this.craftList).isEmpty();
    }

    @Override
    public void craftStart() {
        this.isCraft = true;
        this.setState(1);
        this.sendPKT();
        this.playSound(this.m_58899_(), SoundEvents.f_12019_, 1.0f, 1.0f);
        if (this.player != null) {
            this.resultList = this.setCookQuality(this.player, this.resultList, this.amount);
        }
    }

    @Override
    public void craftFinish() {
        this.tickTime = 9;
        this.isCraft = false;
        this.isFinish = true;
        this.setState(2);
        this.sendPKT();
        this.playSound(this.m_58899_(), SoundEvents.f_11914_, 1.0f, 1.0f);
    }

    @Override
    public void clearInfo() {
        this.amount = 0;
        this.craftTime = 0;
        this.isCraft = false;
        this.isFinish = false;
        this.craftList.clear();
        this.resultList.clear();
        this.sendPKT();
    }

    @Override
    public List<ItemStack> getDropList() {
        return this.craftList;
    }

    @Override
    public int getMaxCookTime() {
        return 8;
    }

    @Override
    public int getCookTime() {
        return this.craftTime;
    }

    @Override
    public void setCookTime(int cookTime) {
        this.craftTime = cookTime;
    }

    @Override
    public boolean isCook() {
        return this.isCraft;
    }

    @Override
    public List<ItemStack> getCraftList() {
        return this.craftList;
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128379_("isCraft", this.isCraft);
        tag.m_128379_("isFinish", this.isFinish);
        tag.m_128405_("craftTime", this.craftTime);
        tag.m_128405_("amount", this.amount);
        this.saveStackList(tag, this.craftList, "craftList");
        this.saveStackList(tag, this.resultList, "resultList");
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.isCraft = tag.m_128471_("isCraft");
        this.isFinish = tag.m_128471_("isFinish");
        this.craftTime = tag.m_128451_("craftTime");
        this.amount = tag.m_128451_("amount");
        this.craftList = this.loadAllStack(tag, "craftList");
        this.resultList = this.loadAllStack(tag, "resultList");
    }
}

