/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.tile.sm;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandlerModifiable;
import sweetmagic.init.TileInit;
import sweetmagic.init.tile.menu.CardboardStorageMenu;
import sweetmagic.init.tile.sm.TileAbstractSM;

public class TileCardboardStorage
extends TileAbstractSM {
    public final TileAbstractSM.MagiaHandler inputInv = new TileAbstractSM.MagiaHandler(1, true);
    public final TileAbstractSM.StackHandler storageInv = new TileAbstractSM.StackHandler(1, true);

    public TileCardboardStorage(BlockPos pos, BlockState state) {
        this(TileInit.cardboardStorage, pos, state);
    }

    public TileCardboardStorage(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.resolver = (TileAbstractSM)this.new TileAbstractSM.SingleHandlerProvider((IItemHandlerModifiable)this.inputInv, IN_OUT);
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("inputInv", (Tag)this.inputInv.serializeNBT());
        tag.m_128365_("storageInv", (Tag)this.storageInv.serializeNBT());
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.inputInv.deserializeNBT(tag.m_128469_("inputInv"));
        this.storageInv.deserializeNBT(tag.m_128469_("storageInv"));
    }

    @Override
    public int getInvSize() {
        return 1;
    }

    public int getMaxStackSize(int size) {
        return 6400 * (1 + size);
    }

    @Override
    public int getMaxStackSize() {
        return this.getMaxStackSize(this.getStorageItem().m_41613_());
    }

    public TileAbstractSM.MagiaHandler getInput() {
        return this.inputInv;
    }

    public ItemStack getInputItem() {
        return this.getInput().getStackInSlot(0);
    }

    public TileAbstractSM.StackHandler getStorage() {
        return this.storageInv;
    }

    public ItemStack getStorageItem() {
        return this.getStorage().getStackInSlot(0);
    }

    @Override
    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
        return new CardboardStorageMenu(windowId, inv, this);
    }

    @Override
    public boolean isInfoEmpty() {
        return this.getInputList().isEmpty();
    }

    public List<ItemStack> getInputList() {
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        this.addStackList(stackList, this.getInputItem());
        this.addStackList(stackList, this.getStorageItem());
        return stackList;
    }

    public List<ItemStack> getInvList() {
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        stackList.add(this.getInputItem());
        stackList.add(this.getStorageItem());
        return stackList;
    }
}

