/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.tile.sm;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import sweetmagic.api.SweetMagicAPI;
import sweetmagic.init.BlockInit;
import sweetmagic.init.TileInit;
import sweetmagic.init.tile.menu.MFChangerMenu;
import sweetmagic.init.tile.sm.TileAbstractSM;
import sweetmagic.init.tile.sm.TileSMMagic;

public class TileMFChanger
extends TileSMMagic {
    public int maxMagiaFlux = 30000;
    public boolean isReceive = false;
    protected final TileAbstractSM.StackHandler inputInv = new TileAbstractSM.StackHandler(this.getInvSize()){

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            return SweetMagicAPI.hasMF(stack) ? super.insertItem(slot, stack, simulate) : stack;
        }
    };

    public TileMFChanger(BlockPos pos, BlockState state) {
        this(TileInit.changer, pos, state);
    }

    public TileMFChanger(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.resolver = (TileAbstractSM)this.new TileAbstractSM.SingleHandlerProvider((IItemHandlerModifiable)this.inputInv, IN);
    }

    @Override
    public void serverTick(Level level, BlockPos pos, BlockState state) {
        super.serverTick(level, pos, state);
        if (this.getTickTime() % 40 != 0 || this.isRSPower()) {
            return;
        }
        if (!this.isMaxMF()) {
            this.changeMF();
        }
    }

    protected boolean changeMF() {
        boolean isUpdate = false;
        for (int i = 0; i < this.getInvSize(); ++i) {
            ItemStack stack = this.getInputItem(i);
            if (stack.m_41619_() || !SweetMagicAPI.hasMF(stack)) continue;
            int mfValue = this.getItemMF(stack.m_41720_());
            int value = (this.getMaxMF() - this.getMF()) / mfValue + 1;
            value = value > stack.m_41613_() ? stack.m_41613_() : value;
            int itemMF = mfValue * value;
            this.setMF(this.getMF() + itemMF);
            isUpdate = true;
            stack.m_41774_(value);
            if (this.isMaxMF()) break;
        }
        if (isUpdate) {
            this.sentClient();
        }
        return true;
    }

    @Override
    public void loadNBT(CompoundTag tags) {
        this.inputInv.deserializeNBT(tags.m_128469_("inputInv"));
    }

    @Override
    public void saveNBT(CompoundTag tags) {
        tags.m_128365_("inputInv", (Tag)this.inputInv.serializeNBT());
    }

    @Override
    public int getMaxMF() {
        return this.maxMagiaFlux;
    }

    @Override
    public boolean getReceive() {
        return this.isReceive;
    }

    @Override
    public int getInvSize() {
        return 3;
    }

    @Override
    public IItemHandler getInput() {
        return this.inputInv;
    }

    public ItemStack getInputItem(int i) {
        return this.getInput().getStackInSlot(i);
    }

    @Override
    public Component m_5446_() {
        return BlockInit.mfchanger.m_49954_();
    }

    @Override
    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
        return new MFChangerMenu(windowId, inv, this);
    }

    @Override
    public boolean isRSStop() {
        return true;
    }

    public List<ItemStack> getInvList() {
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        for (int i = 0; i < this.getInvSize(); ++i) {
            this.addStackList(stackList, this.getInputItem(i));
        }
        return stackList;
    }

    @Override
    public boolean isInfoEmpty() {
        return this.getInvList().isEmpty() && this.isMFEmpty();
    }
}

