/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.tile.sm;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import sweetmagic.init.TileInit;
import sweetmagic.init.block.magic.MFFurnace;
import sweetmagic.init.tile.menu.MFFurnaceMenu;
import sweetmagic.init.tile.sm.TileAbstractSM;
import sweetmagic.init.tile.sm.TileSMMagic;
import sweetmagic.util.ItemHelper;

public class TileMFFurnace
extends TileSMMagic {
    public float exp = 0.0f;
    public int craftTime = 0;
    public int maxCraftTime = 0;
    protected final int costMF = 5;
    protected final int maxMagiaFlux = 20000;
    public boolean isCraft = false;
    protected ItemStack stack = ItemStack.f_41583_;
    protected final RecipeWrapper dummyFurnace = new RecipeWrapper((IItemHandlerModifiable)new ItemStackHandler());
    protected final TileAbstractSM.StackHandler inputInv = new TileAbstractSM.StackHandler(this.getInvSize() + 1);
    protected final TileAbstractSM.StackHandler outInv = new TileAbstractSM.StackHandler(this.getInvSize());

    public TileMFFurnace(BlockPos pos, BlockState state) {
        this(TileInit.mffurnace, pos, state);
    }

    public TileMFFurnace(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.resolver = (TileAbstractSM)this.new TileAbstractSM.InOutHandlerProvider((IItemHandlerModifiable)this.inputInv, (IItemHandlerModifiable)this.outInv);
    }

    @Override
    public void serverTick(Level world, BlockPos pos, BlockState state) {
        super.serverTick(world, pos, state);
        if (!this.isCraft && this.tickTime % 10 != 0 || this.isRSPower()) {
            return;
        }
        if (this.isCraft) {
            ++this.craftTime;
            this.sendPKT();
            if (this.craftTime >= this.maxCraftTime) {
                this.craftFinish(world, pos);
            }
        } else if (this.canSmelt(world, pos)) {
            this.craftStart(world, pos);
        }
    }

    public boolean canSmelt(Level world, BlockPos pos) {
        ItemHelper.compactSimpleInventory((IItemHandlerModifiable)this.inputInv);
        this.suctionItem(world, pos);
        return this.canSmelt(world, this.inputInv.getStackInSlot(0));
    }

    public boolean canSmelt(Level world, ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        ItemStack result = this.checkSmeltResult(world, stack);
        if (result.m_41619_() || this.isMFEmpty() || this.getCostMF() > this.getMF()) {
            return false;
        }
        return ItemHelper.insertStack(this.getOut(), result.m_41777_(), true).m_41619_();
    }

    public ItemStack checkSmeltResult(Level world, ItemStack stack) {
        this.dummyFurnace.m_6836_(0, stack);
        Optional recipe = world.m_7465_().m_44015_(RecipeType.f_44108_, (Container)this.dummyFurnace, world);
        this.dummyFurnace.m_6836_(0, ItemStack.f_41583_);
        return recipe.map(Recipe::m_8043_).orElse(ItemStack.f_41583_);
    }

    public void craftStart(Level world, BlockPos pos) {
        ItemStack stack = this.getInputItem(0);
        this.stack = stack.m_41777_();
        stack.m_41774_(1);
        this.dummyFurnace.m_6836_(0, this.stack);
        SmeltingRecipe recipe = (SmeltingRecipe)world.m_7465_().m_44015_(RecipeType.f_44108_, (Container)this.dummyFurnace, world).get();
        this.maxCraftTime = (int)((float)recipe.m_43753_() / this.getCraftRate());
        this.exp += recipe.m_43750_();
        this.craftTime = 1;
        this.tickTime = -1;
        this.isCraft = true;
        this.sendPKT();
        world.m_7731_(pos, (BlockState)this.getState(pos).m_61124_((Property)MFFurnace.ISCRAFT, (Comparable)Boolean.valueOf(true)), 3);
    }

    public void craftFinish(Level world, BlockPos pos) {
        ItemStack result = this.checkSmeltResult(world, this.stack).m_41777_();
        ItemHelper.insertStack(this.getOut(), result, false);
        ItemHelper.compactSimpleInventory((IItemHandlerModifiable)this.outInv);
        this.extractItem(pos);
        this.craftTime = 0;
        this.tickTime = -1;
        this.isCraft = false;
        this.stack = ItemStack.f_41583_;
        this.setMF(this.getMF() - this.getCostMF());
        this.sendPKT();
        if (!this.canSmelt(world, pos)) {
            world.m_7731_(pos, (BlockState)this.getState(pos).m_61124_((Property)MFFurnace.ISCRAFT, (Comparable)Boolean.valueOf(false)), 3);
        }
    }

    public void suctionItem(Level world, BlockPos pos) {
        BlockEntity tile = this.getTile(pos.m_7494_());
        if (tile == null) {
            return;
        }
        IItemHandler handler = this.getItemHandler(tile, Direction.DOWN);
        if (handler == null) {
            return;
        }
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack output = handler.getStackInSlot(i);
            if (output.m_41619_() || !this.canSmelt(world, output)) continue;
            ItemStack stack = ItemHelper.insertStack(this.getInput(), output.m_41777_(), false);
            output.m_41764_(stack.m_41613_());
        }
    }

    public void extractItem(BlockPos pos) {
        BlockEntity tile = this.getTile(pos.m_7495_());
        if (tile == null) {
            return;
        }
        IItemHandler handler = this.getItemHandler(tile, Direction.UP);
        if (handler == null) {
            return;
        }
        block0: for (int h = 0; h < this.getInvSize(); ++h) {
            ItemStack input = this.getOutItem(h);
            if (input.m_41619_()) continue;
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack inStack = handler.insertItem(i, input.m_41777_(), false);
                input.m_41764_(inStack.m_41613_());
                if (inStack.m_41619_()) continue block0;
            }
        }
    }

    @Override
    public int getInvSize() {
        return 18;
    }

    @Override
    public int getMaxMF() {
        return this.maxMagiaFlux;
    }

    public int getCostMF() {
        return this.costMF;
    }

    @Override
    public int getReceiveMF() {
        return 5000;
    }

    public float getCraftRate() {
        return 5.0f;
    }

    @Override
    public IItemHandler getInput() {
        return this.inputInv;
    }

    public ItemStack getInputItem(int i) {
        return this.getInput().getStackInSlot(i);
    }

    public IItemHandler getOut() {
        return this.outInv;
    }

    public ItemStack getOutItem(int i) {
        return this.getOut().getStackInSlot(i);
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("inputInv", (Tag)this.inputInv.serializeNBT());
        tag.m_128365_("outInv", (Tag)this.outInv.serializeNBT());
        tag.m_128405_("tickTime", this.tickTime);
        tag.m_128405_("craftTime", this.craftTime);
        tag.m_128405_("maxCraftTime", this.maxCraftTime);
        tag.m_128350_("exp", this.exp);
        tag.m_128379_("isCraft", this.isCraft);
        tag.m_128365_("outPutStack", (Tag)this.stack.m_41739_(new CompoundTag()));
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.inputInv.deserializeNBT(tag.m_128469_("inputInv"));
        this.outInv.deserializeNBT(tag.m_128469_("outInv"));
        this.tickTime = tag.m_128451_("tickTime");
        this.craftTime = tag.m_128451_("craftTime");
        this.maxCraftTime = tag.m_128451_("maxCraftTime");
        this.exp = tag.m_128457_("exp");
        this.isCraft = tag.m_128471_("isCraft");
        this.stack = ItemStack.m_41712_((CompoundTag)tag.m_128469_("outPutStack"));
    }

    public int getCraftProgress(int value) {
        return this.getProgress(value, this.craftTime, this.maxCraftTime);
    }

    @Override
    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
        return new MFFurnaceMenu(windowId, inv, this);
    }

    @Override
    public boolean isRSStop() {
        return true;
    }

    public List<ItemStack> getInvList() {
        int i;
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        for (i = 0; i < this.getInvSize() + 1; ++i) {
            this.addStackList(stackList, this.getInputItem(i));
        }
        for (i = 0; i < this.getInvSize(); ++i) {
            this.addStackList(stackList, this.getOutItem(i));
        }
        return stackList;
    }

    @Override
    public boolean isInfoEmpty() {
        return this.getInvList().isEmpty() && this.isMFEmpty();
    }
}

