/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.tile.sm;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import sweetmagic.api.iblock.ITileFluid;
import sweetmagic.init.ItemInit;
import sweetmagic.init.TileInit;
import sweetmagic.init.fluid.FluidTankHandler;
import sweetmagic.init.item.sm.SMBucket;
import sweetmagic.init.tile.menu.MFGeneraterMenu;
import sweetmagic.init.tile.sm.TileAbstractSM;
import sweetmagic.init.tile.sm.TileSMMagic;
import sweetmagic.util.ItemHelper;

public class TileMFGenerater
extends TileSMMagic
implements ITileFluid {
    public int craftTime = 0;
    public int maxMagiaFlux = 1000000;
    public static final int MAX_CRAFT_TIME = 5;
    public boolean isCraft = false;
    private static final Block AIR = Blocks.f_50016_;
    private static final Block MAGMA = Blocks.f_50450_;
    private static final BlockState LAVA = Blocks.f_49991_.m_49966_();
    private static final Direction[] ALLFACE = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
    private static final int MAX_FLUID_VALUE = 64000;
    public FluidStack fluid = new FluidStack(Fluids.f_76191_, 0);
    protected final FluidTankHandler.TankProperty fluidPro;
    public LazyOptional<IFluidHandler> fluidHandler = LazyOptional.of(() -> this.createFluidHandler());
    protected final TileAbstractSM.StackHandler inputInv = new TileAbstractSM.StackHandler(this.getInvSize());
    protected final TileAbstractSM.StackHandler bucketInv = new TileAbstractSM.StackHandler(1);

    public TileMFGenerater(BlockPos pos, BlockState state) {
        this(TileInit.mfGenerater, pos, state);
    }

    public TileMFGenerater(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.resolver = (TileAbstractSM)this.new TileAbstractSM.SingleHandlerProvider((IItemHandlerModifiable)this.inputInv, IN);
        this.fluidPro = new FluidTankHandler.TankProperty(64000, false, true, f -> f.m_6212_((Fluid)Fluids.f_76195_));
    }

    @Override
    public void serverTick(Level world, BlockPos pos, BlockState state) {
        super.serverTick(world, pos, state);
        if (this.tickTime % 20 != 0 || this.isRSPower()) {
            return;
        }
        if (!this.isCraft) {
            this.craftStart();
        } else if (this.craftTime++ >= 5) {
            this.craftFinish();
        }
        if (this.isCraft) {
            this.sendInfo();
        }
        this.fillBucket();
        this.fillTank(pos);
        this.setLava(world, pos.m_7495_());
    }

    public void craftStart() {
        ItemHelper.compactSimpleInventory((IItemHandlerModifiable)this.inputInv);
        ItemStack stack = this.getInputItem(0);
        if (stack.m_41619_() || !stack.m_204117_(Tags.Items.COBBLESTONE) || stack.m_41613_() < 8 || this.isMaxFluid() || this.getMF() < this.shrinkMF()) {
            return;
        }
        stack.m_41774_(8);
        this.isCraft = true;
        this.craftTime = 0;
        this.setMF(this.getMF() - this.shrinkMF());
        this.sendInfo();
    }

    public void craftFinish() {
        this.isCraft = false;
        FluidStack fluid = this.getContent();
        if (fluid.isEmpty()) {
            this.setContent(new FluidStack((Fluid)Fluids.f_76195_, 1000));
        } else {
            fluid.setAmount(Math.min(64000, this.getFluidValue() + 1000));
        }
        this.playSound(this.m_58899_(), SoundEvents.f_11783_, 0.5f, 1.0f);
        this.sendInfo();
    }

    public void fillBucket() {
        Item item;
        if (this.getFluidValue() <= 0) {
            return;
        }
        ItemStack stack = this.getBucketItem().m_41777_();
        if (stack.m_41619_() || !((item = stack.m_41720_()) instanceof SMBucket)) {
            return;
        }
        SMBucket bucket = (SMBucket)item;
        FluidStack fluid = new FluidStack((Fluid)Fluids.f_76195_, Math.min(1000, this.getFluidValue()));
        if (stack.m_150930_(ItemInit.alt_bucket)) {
            stack = new ItemStack((ItemLike)ItemInit.alt_bucket_lava);
        } else {
            fluid = bucket.getFluidStack(stack);
            int amount = Math.min(1000, this.getFluidValue());
            if (fluid.isEmpty()) {
                fluid = new FluidStack((Fluid)Fluids.f_76195_, amount);
            } else {
                fluid.grow(amount);
            }
        }
        bucket.saveFluid(stack, fluid);
        this.getContent().setAmount(Math.max(0, this.getFluidValue() - 1000));
        this.getBucketItem().m_41774_(1);
        ItemHelper.insertStack(this.getBucket(), stack, false);
        this.sendInfo();
    }

    public void fillTank(BlockPos pos) {
        if (this.getFluidValue() <= 0) {
            return;
        }
        BlockEntity tile = this.getTile(pos.m_121945_(Direction.UP));
        if (tile == null) {
            return;
        }
        IFluidHandler handler = this.getFluidHandler(tile, Direction.UP);
        if (handler == null) {
            return;
        }
        FluidStack flu = this.getContent().copy();
        flu.setAmount(Math.min(1000, this.getFluidValue()));
        int amount = handler.fill(flu, IFluidHandler.FluidAction.EXECUTE);
        this.getContent().shrink(amount);
    }

    public void setLava(Level world, BlockPos pos) {
        if (this.getFluidValue() < 1000 || this.getBlock(pos) != MAGMA) {
            return;
        }
        int count = 0;
        int maxCount = this.getFluidValue() / 1000;
        for (Direction face : ALLFACE) {
            if (this.getBlock(pos.m_121945_(face)) != AIR || count >= maxCount) continue;
            world.m_7731_(pos.m_121945_(face), LAVA, 3);
            ++count;
        }
        if (count > 0) {
            this.getContent().shrink(count * 1000);
            this.sendInfo();
        }
    }

    @Override
    public int getInvSize() {
        return 12;
    }

    @Override
    public int getMaxMF() {
        return this.maxMagiaFlux;
    }

    @Override
    public int getReceiveMF() {
        return 50000;
    }

    public int shrinkMF() {
        return 1000;
    }

    @Override
    public IItemHandler getInput() {
        return this.inputInv;
    }

    public ItemStack getInputItem(int i) {
        return this.getInput().getStackInSlot(i);
    }

    public IItemHandler getBucket() {
        return this.bucketInv;
    }

    public ItemStack getBucketItem() {
        return this.getBucket().getStackInSlot(0);
    }

    @Override
    public int fluidTanks() {
        return 1;
    }

    @Override
    public IFluidHandler createFluidHandler() {
        return new FluidTankHandler(this);
    }

    @Override
    public void setContent(FluidStack fluid) {
        this.fluid = fluid;
        this.m_6596_();
    }

    @Override
    public FluidTankHandler.TankProperty getTank() {
        return this.fluidPro;
    }

    @Override
    public FluidStack getContent() {
        return this.fluid;
    }

    @Override
    public void setAmount(int amount) {
        this.fluid.setAmount(amount);
    }

    @Override
    public int getFluidValue() {
        return this.getContent().getAmount();
    }

    @Override
    public void sendData() {
        this.sendInfo();
    }

    public LazyOptional<IFluidHandler> getFluidHandler() {
        return this.fluidHandler;
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction face) {
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.getFluidHandler();
        }
        return super.getCapability(cap, face);
    }

    public void m_7651_() {
        super.m_7651_();
        if (this.getFluidHandler() != null) {
            this.getFluidHandler().invalidate();
        }
    }

    @Override
    public int getMaxFuildValue() {
        return 64000;
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("outInv", (Tag)this.inputInv.serializeNBT());
        tag.m_128365_("bucketInv", (Tag)this.bucketInv.serializeNBT());
        CompoundTag fluidNBT = new CompoundTag();
        this.getContent().writeToNBT(fluidNBT);
        tag.m_128365_("fluid", (Tag)fluidNBT);
        tag.m_128379_("isCraft", this.isCraft);
        tag.m_128405_("craftTime", this.craftTime);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.inputInv.deserializeNBT(tag.m_128469_("outInv"));
        this.bucketInv.deserializeNBT(tag.m_128469_("bucketInv"));
        this.setContent(FluidStack.loadFluidStackFromNBT((CompoundTag)tag.m_128469_("fluid")));
        this.isCraft = tag.m_128471_("isCraft");
        this.craftTime = tag.m_128451_("craftTime");
    }

    @Override
    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
        return new MFGeneraterMenu(windowId, inv, this);
    }

    @Override
    public boolean isRSStop() {
        return true;
    }

    public List<ItemStack> getInvList() {
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        for (int i = 0; i < this.getInvSize(); ++i) {
            this.addStackList(stackList, this.getInputItem(i));
        }
        return stackList;
    }

    @Override
    public boolean isInfoEmpty() {
        return this.getInvList().isEmpty() && this.isMFEmpty() && this.getContent().isEmpty();
    }
}

