/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.tile.sm;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandler;
import sweetmagic.api.SweetMagicAPI;
import sweetmagic.api.iitem.IMFTool;
import sweetmagic.init.BlockInit;
import sweetmagic.init.TileInit;
import sweetmagic.init.tile.menu.MFTableMenu;
import sweetmagic.init.tile.sm.TileAbstractSM;
import sweetmagic.init.tile.sm.TileSMMagic;

public class TileMFTable
extends TileSMMagic {
    public int maxMagiaFlux = 20000;
    public boolean isReceive = true;
    protected final TileAbstractSM.StackHandler wandInv = new TileAbstractSM.StackHandler(this.getInvSize(), true){

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            return SweetMagicAPI.hasMF(stack) ? super.insertItem(slot, stack, simulate) : stack;
        }
    };
    protected final TileAbstractSM.StackHandler fuelInv = new TileAbstractSM.StackHandler(this.getInvSize()){

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            return SweetMagicAPI.hasMF(stack) ? super.insertItem(slot, stack, simulate) : stack;
        }
    };

    public TileMFTable(BlockPos pos, BlockState state) {
        super(TileInit.table, pos, state);
    }

    public TileMFTable(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void serverTick(Level level, BlockPos pos, BlockState state) {
        super.serverTick(level, pos, state);
        if (this.getTickTime() % 10 != 0) {
            return;
        }
        if (!this.isMaxMF()) {
            this.smeltItem();
        }
        if (this.getTickTime() % 20 != 0) {
            return;
        }
        if (!this.isMFEmpty()) {
            this.wandChargeMF();
        }
    }

    public void smeltItem() {
        ItemStack stack = this.getFuelItem();
        if (stack.m_41619_()) {
            return;
        }
        ItemStack copy = stack.m_41777_();
        copy.m_41764_(1);
        this.setMF(this.getMF() + this.getItemMF(copy));
        stack.m_41774_(1);
        this.sentClient();
    }

    public void wandChargeMF() {
        for (int i = 0; i < this.getInvSize(); ++i) {
            ItemStack stack = this.getInputItem(i);
            if (stack.m_41619_() || this.wandMaxMF(stack) || this.isMFEmpty()) continue;
            IMFTool wand = (IMFTool)stack.m_41720_();
            wand.insertMF(stack, this);
            if (!this.wandMaxMF(stack)) continue;
            this.playSound(this.getTilePos(), SoundEvents.f_12275_, 1.0f, 1.0f);
            this.m_58904_().m_46796_(2003, this.m_58899_().m_6630_(2), 0);
        }
    }

    public boolean wandMaxMF(ItemStack stack) {
        IMFTool wand = (IMFTool)stack.m_41720_();
        return wand.getMF(stack) >= wand.getMaxMF(stack);
    }

    @Override
    public void loadNBT(CompoundTag tags) {
        this.wandInv.deserializeNBT(tags.m_128469_("wandInv"));
        this.fuelInv.deserializeNBT(tags.m_128469_("fuelInv"));
    }

    @Override
    public void saveNBT(CompoundTag tags) {
        tags.m_128365_("wandInv", (Tag)this.wandInv.serializeNBT());
        tags.m_128365_("fuelInv", (Tag)this.fuelInv.serializeNBT());
    }

    @Override
    public int getMaxMF() {
        return this.maxMagiaFlux;
    }

    @Override
    public boolean getReceive() {
        return this.isReceive;
    }

    @Override
    public int getInvSize() {
        return 1;
    }

    @Override
    public IItemHandler getInput() {
        return this.wandInv;
    }

    public ItemStack getInputItem(int i) {
        return this.getInput().getStackInSlot(i);
    }

    public IItemHandler getFuel() {
        return this.fuelInv;
    }

    public ItemStack getFuelItem() {
        return this.getFuel().getStackInSlot(0);
    }

    @Override
    public int getShrinkMF() {
        return 5000;
    }

    @Override
    public Component m_5446_() {
        return BlockInit.mftable.m_49954_();
    }

    @Override
    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
        return new MFTableMenu(windowId, inv, this);
    }

    public List<ItemStack> getInvList() {
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        for (int i = 0; i < this.getInvSize(); ++i) {
            this.addStackList(stackList, this.getInputItem(i));
        }
        this.addStackList(stackList, this.getFuelItem());
        return stackList;
    }

    @Override
    public boolean isInfoEmpty() {
        return this.getInvList().isEmpty() && this.isMFEmpty();
    }
}

