/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.tile.sm;

import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandler;
import sweetmagic.api.SweetMagicAPI;
import sweetmagic.init.TileInit;
import sweetmagic.init.tile.sm.TileAbstractSM;
import sweetmagic.init.tile.sm.TileMFTable;

public class TileMFTableAdvanced
extends TileMFTable {
    public int maxMagiaFlux = 400000;
    protected final TileAbstractSM.StackHandler wandInv = new TileAbstractSM.StackHandler(this.getInvSize(), true){

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            return SweetMagicAPI.hasMF(stack) ? super.insertItem(slot, stack, simulate) : stack;
        }
    };

    public TileMFTableAdvanced(BlockPos pos, BlockState state) {
        super(TileInit.tableAdavance, pos, state);
    }

    public TileMFTableAdvanced(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void saveNBT(CompoundTag tags) {
        tags.m_128365_("wandInv", (Tag)this.wandInv.serializeNBT());
        tags.m_128365_("fuelInv", (Tag)this.fuelInv.serializeNBT());
    }

    @Override
    public void loadNBT(CompoundTag tags) {
        this.wandInv.deserializeNBT(tags.m_128469_("wandInv"));
        this.fuelInv.deserializeNBT(tags.m_128469_("fuelInv"));
    }

    @Override
    public int getInvSize() {
        return 4;
    }

    @Override
    public int getReceiveMF() {
        return 80000;
    }

    @Override
    public int getShrinkMF() {
        return 20000;
    }

    @Override
    public int getMaxMF() {
        return this.maxMagiaFlux;
    }

    @Override
    public IItemHandler getInput() {
        return this.wandInv;
    }
}

